/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.webservices;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WSDLVisitor {
    private static final Log log = LogFactory.getLog((Class)WSDLVisitor.class);
    protected final Definition definition;

    public WSDLVisitor(Definition definition) {
        this.definition = definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void walkTree() {
        this.begin();
        try {
            this.visit(this.definition);
            Iterator iterator = this.definition.getImports().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String namespaceURI = (String)entry.getKey();
                List importsForNamespace = (List)entry.getValue();
                Iterator iterator1 = importsForNamespace.iterator();
                while (iterator1.hasNext()) {
                    Import anImport = (Import)iterator1.next();
                    this.visit(anImport);
                }
            }
            this.visit(this.definition.getTypes());
            Collection messages = this.definition.getMessages().values();
            Iterator iterator2 = messages.iterator();
            while (iterator2.hasNext()) {
                Message message = (Message)iterator2.next();
                this.visit(message);
                Collection parts = message.getParts().values();
                Iterator iterator22 = parts.iterator();
                while (iterator22.hasNext()) {
                    Part part = (Part)iterator22.next();
                    this.visit(part);
                }
            }
            Collection services = this.definition.getServices().values();
            Iterator iterator3 = services.iterator();
            while (iterator3.hasNext()) {
                Service service = (Service)iterator3.next();
                this.visit(service);
                Collection ports = service.getPorts().values();
                Iterator iterator1 = ports.iterator();
                while (iterator1.hasNext()) {
                    Port port = (Port)iterator1.next();
                    this.visit(port);
                    Binding binding = port.getBinding();
                    this.visit(binding);
                    List bindingOperations = binding.getBindingOperations();
                    for (int i = 0; i < bindingOperations.size(); ++i) {
                        BindingOperation bindingOperation = (BindingOperation)bindingOperations.get(i);
                        this.visit(bindingOperation);
                        this.visit(bindingOperation.getBindingInput());
                        this.visit(bindingOperation.getBindingOutput());
                        Collection bindingFaults = bindingOperation.getBindingFaults().values();
                        Iterator iterator23 = bindingFaults.iterator();
                        while (iterator23.hasNext()) {
                            BindingFault bindingFault = (BindingFault)iterator23.next();
                            this.visit(bindingFault);
                        }
                    }
                    PortType portType = binding.getPortType();
                    this.visit(portType);
                    List operations = portType.getOperations();
                    for (int i = 0; i < operations.size(); ++i) {
                        Operation operation = (Operation)operations.get(i);
                        this.visit(operation);
                        Input input = operation.getInput();
                        this.visit(input);
                        Output output = operation.getOutput();
                        this.visit(output);
                        Collection faults = operation.getFaults().values();
                        Iterator iterator24 = faults.iterator();
                        while (iterator24.hasNext()) {
                            Fault fault = (Fault)iterator24.next();
                            this.visit(fault);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.end();
        }
    }

    protected void begin() {
    }

    protected void end() {
    }

    protected void visit(Fault fault) {
    }

    protected void visit(Definition definition) {
    }

    protected void visit(Import wsdlImport) {
    }

    protected void visit(Types types) {
    }

    protected void visit(BindingFault bindingFault) {
    }

    protected void visit(BindingOutput bindingOutput) {
    }

    protected void visit(BindingInput bindingInput) {
    }

    protected void visit(Output output) {
    }

    protected void visit(Part part) {
    }

    protected void visit(Message message) {
    }

    protected void visit(Input input) {
    }

    protected void visit(Operation operation) {
    }

    protected void visit(PortType portType) {
    }

    protected void visit(BindingOperation bindingOperation) {
    }

    protected void visit(Binding binding) {
    }

    protected void visit(Port port) {
    }

    protected void visit(Service service) {
    }

    protected SOAPBody getSOAPBody(List extensibilityElements) {
        SOAPBody body = null;
        for (int j = 0; j < extensibilityElements.size(); ++j) {
            Object element = extensibilityElements.get(j);
            if (!(element instanceof SOAPBody)) continue;
            body = (SOAPBody)element;
            break;
        }
        return body;
    }

    protected SOAPBinding getSOAPBinding(Binding binding) {
        SOAPBinding soapBinding = null;
        List extensibilityElements = binding.getExtensibilityElements();
        for (int i = 0; i < extensibilityElements.size(); ++i) {
            Object element = extensibilityElements.get(i);
            if (!(element instanceof SOAPBinding)) continue;
            soapBinding = (SOAPBinding)element;
        }
        return soapBinding;
    }
}

