/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.webservices.builder;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.webservices.builder.DescriptorVersion;
import org.apache.geronimo.webservices.builder.SchemaInfoBuilder;
import org.apache.geronimo.webservices.builder.SharedPortInfo;
import org.apache.openejb.jee.Handler;
import org.apache.openejb.jee.HandlerChain;
import org.apache.openejb.jee.HandlerChains;
import org.apache.openejb.jee.JavaWsdlMapping;
import org.apache.openejb.jee.ServiceEndpointInterfaceMapping;

public class PortInfo {
    private final String portComponentName;
    private final QName portQName;
    private final String seInterfaceName;
    private final List<Handler> handlers;
    private final SharedPortInfo sharedPortInfo;
    private SchemaInfoBuilder schemaInfoBuilder;
    private JavaWsdlMapping javaWsdlMapping;
    private Port port;
    private ServiceEndpointInterfaceMapping seiMapping;
    private URI contextURI;
    private String location;

    public PortInfo(SharedPortInfo sharedPortInfo, String portComponentName, QName portQName, String seiInterfaceName, HandlerChains handlerChains, String location) {
        this.sharedPortInfo = sharedPortInfo;
        this.portComponentName = portComponentName;
        this.portQName = portQName;
        this.seInterfaceName = seiInterfaceName;
        this.location = location;
        this.handlers = new ArrayList<Handler>();
        if (handlerChains != null) {
            for (HandlerChain chain : handlerChains.getHandlerChain()) {
                for (Handler handler : chain.getHandler()) {
                    this.handlers.add(handler);
                }
            }
        }
    }

    public DescriptorVersion getDescriptorVersion() {
        return this.sharedPortInfo.getDescriptorVersion();
    }

    public String getWsdlLocation() {
        return this.sharedPortInfo.getWsdlLocation();
    }

    public String getPortComponentName() {
        return this.portComponentName;
    }

    public QName getPortQName() {
        return this.portQName;
    }

    public Port getPort() {
        return this.port;
    }

    public SchemaInfoBuilder getSchemaInfoBuilder() {
        return this.schemaInfoBuilder;
    }

    public Definition getDefinition() {
        return this.schemaInfoBuilder.getDefinition();
    }

    public JavaWsdlMapping getJavaWsdlMapping() {
        return this.javaWsdlMapping;
    }

    public String getServiceEndpointInterfaceName() {
        return this.seInterfaceName;
    }

    public ServiceEndpointInterfaceMapping getServiceEndpointInterfaceMapping() {
        return this.seiMapping;
    }

    public List<Handler> getHandlers() {
        return this.handlers;
    }

    public URI getContextURI() {
        return this.contextURI;
    }

    public void initialize(JarFile moduleFile) throws DeploymentException {
        this.sharedPortInfo.initialize(moduleFile);
        this.schemaInfoBuilder = this.sharedPortInfo.getSchemaInfoBuilder();
        this.javaWsdlMapping = this.sharedPortInfo.getJavaWsdlMapping();
        QName portQName = this.getPortQName();
        String portComponentName = this.getPortComponentName();
        String seiInterfaceName = this.getServiceEndpointInterfaceName();
        Map wsdlPortMap = this.schemaInfoBuilder.getPortMap();
        Port wsdlPort = (Port)wsdlPortMap.get(portQName.getLocalPart());
        if (wsdlPort == null) {
            throw new DeploymentException("No WSDL Port definition for port-component " + portComponentName);
        }
        this.port = wsdlPort;
        this.seiMapping = this.sharedPortInfo.getSEIMappings().get(seiInterfaceName);
        this.location = this.schemaInfoBuilder.movePortLocation(portQName.getLocalPart(), this.location);
        try {
            this.contextURI = new URI(this.location);
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Could not construct URI for web service location", (Throwable)e);
        }
    }
}

