/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.webservices.builder;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.webservices.builder.DescriptorVersion;
import org.apache.geronimo.webservices.builder.SchemaInfoBuilder;
import org.apache.geronimo.webservices.builder.WSDescriptorParser;
import org.apache.geronimo.xbeans.j2ee.JavaWsdlMappingType;
import org.apache.geronimo.xbeans.j2ee.ServiceEndpointInterfaceMappingType;

public class SharedPortInfo {
    private String jaxrpcMappingFile;
    private String wsdlLocation;
    private JavaWsdlMappingType javaWsdlMapping;
    private SchemaInfoBuilder schemaInfoBuilder;
    private DescriptorVersion ddVersion;

    public SharedPortInfo(String wsdlLocation, String jaxrpcMappingFile) {
        this(wsdlLocation, jaxrpcMappingFile, DescriptorVersion.UNKNOWN);
    }

    public SharedPortInfo(String wsdlLocation, String jaxrpcMappingFile, DescriptorVersion ddVersion) {
        this.wsdlLocation = wsdlLocation;
        this.jaxrpcMappingFile = jaxrpcMappingFile;
        this.ddVersion = ddVersion;
    }

    public DescriptorVersion getDescriptorVersion() {
        return this.ddVersion;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public String getJaxrpcMappingFile() {
        return this.jaxrpcMappingFile;
    }

    public void initialize(JarFile moduleFile) throws DeploymentException {
        if (this.jaxrpcMappingFile == null) {
            throw new DeploymentException("JAX-RPC mapping file is required.");
        }
        if (this.wsdlLocation == null) {
            throw new DeploymentException("WSDL file is required.");
        }
        if (this.javaWsdlMapping == null) {
            URI jaxrpcMappingURI;
            try {
                jaxrpcMappingURI = new URI(this.jaxrpcMappingFile);
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Could not construct jaxrpc mapping uri from " + this.jaxrpcMappingFile, (Throwable)e);
            }
            this.javaWsdlMapping = WSDescriptorParser.readJaxrpcMapping(moduleFile, jaxrpcMappingURI);
        }
        if (this.schemaInfoBuilder == null) {
            URI wsdlURI;
            try {
                wsdlURI = new URI(this.wsdlLocation);
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("could not construct wsdl uri from " + this.wsdlLocation, (Throwable)e);
            }
            this.schemaInfoBuilder = new SchemaInfoBuilder(moduleFile, wsdlURI);
        }
    }

    public JavaWsdlMappingType getJavaWsdlMapping() {
        return this.javaWsdlMapping;
    }

    public SchemaInfoBuilder getSchemaInfoBuilder() {
        return this.schemaInfoBuilder;
    }

    public Map<String, ServiceEndpointInterfaceMappingType> getSEIMappings() {
        ServiceEndpointInterfaceMappingType[] mappings;
        if (this.javaWsdlMapping == null) {
            return Collections.emptyMap();
        }
        HashMap<String, ServiceEndpointInterfaceMappingType> seiMappings = new HashMap<String, ServiceEndpointInterfaceMappingType>();
        for (ServiceEndpointInterfaceMappingType seiMapping : mappings = this.javaWsdlMapping.getServiceEndpointInterfaceMappingArray()) {
            seiMappings.put(seiMapping.getServiceEndpointInterface().getStringValue().trim(), seiMapping);
        }
        return seiMappings;
    }
}

