/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web.security;

import java.net.URL;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import javax.servlet.HttpMethodConstraintElement;
import javax.servlet.Servlet;
import javax.servlet.ServletSecurityElement;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.HttpMethodConstraint;
import javax.servlet.annotation.ServletSecurity;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.kernel.util.JarUtils;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.geronimo.web.security.HTTPMethods;
import org.apache.geronimo.web.security.URLPattern;
import org.apache.geronimo.web.security.UncheckedItem;
import org.apache.geronimo.xbeans.javaee6.AuthConstraintType;
import org.apache.geronimo.xbeans.javaee6.RoleNameType;
import org.apache.geronimo.xbeans.javaee6.SecurityConstraintType;
import org.apache.geronimo.xbeans.javaee6.SecurityRoleRefType;
import org.apache.geronimo.xbeans.javaee6.SecurityRoleType;
import org.apache.geronimo.xbeans.javaee6.ServletMappingType;
import org.apache.geronimo.xbeans.javaee6.ServletType;
import org.apache.geronimo.xbeans.javaee6.UrlPatternType;
import org.apache.geronimo.xbeans.javaee6.WebAppDocument;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebResourceCollectionType;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecSecurityBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SpecSecurityBuilder.class);
    private final Set<String> securityRoles = new HashSet<String>();
    private final Map<String, URLPattern> uncheckedPatterns = new HashMap<String, URLPattern>();
    private final Map<UncheckedItem, HTTPMethods> uncheckedResourcePatterns = new HashMap<UncheckedItem, HTTPMethods>();
    private final Map<UncheckedItem, HTTPMethods> uncheckedUserPatterns = new HashMap<UncheckedItem, HTTPMethods>();
    private final Map<String, URLPattern> excludedPatterns = new HashMap<String, URLPattern>();
    private final Map<String, URLPattern> rolesPatterns = new HashMap<String, URLPattern>();
    private final Set<URLPattern> allSet = new HashSet<URLPattern>();
    private final Map<String, URLPattern> allMap = new HashMap<String, URLPattern>();
    private final RecordingPolicyConfiguration policyConfiguration = new RecordingPolicyConfiguration(true);
    private WebAppType initialWebApp;
    private Bundle bundle;
    private boolean annotationScanRequired;
    private Set<String> urlPatternsConfiguredInDeploymentPlans = new HashSet<String>();
    private WebAppType dynamicSecurityWebApp;
    private WebAppType annotationSecurityWebApp;

    public SpecSecurityBuilder(WebAppType webApp) {
        this(webApp, null, false);
    }

    public SpecSecurityBuilder(WebAppType initialWebApp, Bundle bundle, boolean annotationScanRequired) {
        this.initialWebApp = initialWebApp;
        if (annotationScanRequired && bundle == null) {
            throw new IllegalArgumentException("Bundle parameter could not be null while annotation scanning is required");
        }
        this.bundle = bundle;
        this.annotationScanRequired = annotationScanRequired;
        this.initialize();
    }

    public SpecSecurityBuilder(Bundle bundle, boolean annotationScanRequired) {
        this.bundle = bundle;
        this.annotationScanRequired = annotationScanRequired;
        URL specDDUrl = BundleUtils.getEntry((Bundle)bundle, (String)"WEB-INF/web.xml");
        if (specDDUrl == null) {
            this.initialWebApp = WebAppType.Factory.newInstance();
        } else {
            try {
                String specDD = JarUtils.readAll((URL)specDDUrl);
                XmlObject parsed = XmlBeansUtil.parse((String)specDD);
                WebAppDocument webAppDoc = SchemaConversionUtils.convertToServletSchema((XmlObject)parsed);
                this.initialWebApp = webAppDoc.getWebApp();
            }
            catch (XmlException e) {
                throw new IllegalArgumentException("Error parsing web.xml for " + bundle.getSymbolicName(), e);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error reading web.xml for " + bundle.getSymbolicName(), e);
            }
        }
        this.initialize();
    }

    public SpecSecurityBuilder(Bundle bundle, String deploymentDescriptor, boolean annotationScanRequired) {
        this.bundle = bundle;
        this.annotationScanRequired = annotationScanRequired;
        if (deploymentDescriptor == null || deploymentDescriptor.length() == 0) {
            this.initialWebApp = WebAppType.Factory.newInstance();
        } else {
            try {
                XmlObject parsed = XmlBeansUtil.parse((String)deploymentDescriptor);
                WebAppDocument webAppDoc = SchemaConversionUtils.convertToServletSchema((XmlObject)parsed);
                this.initialWebApp = webAppDoc.getWebApp();
            }
            catch (XmlException e) {
                throw new IllegalArgumentException("Error parsing web.xml for " + bundle.getSymbolicName(), e);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error reading web.xml for " + bundle.getSymbolicName(), e);
            }
        }
        this.initialize();
    }

    public void declareRoles(String ... roleNames) {
        for (String roleName : roleNames) {
            if (roleName == null || roleName.trim().length() == 0) {
                throw new IllegalArgumentException("RoleName of null value or empty string is not allowed in declareRoles method");
            }
            this.securityRoles.add(roleName.trim());
        }
    }

    public Set<String> setServletSecurity(ServletSecurityElement constraint, Collection<String> urlPatterns) {
        if (this.dynamicSecurityWebApp == null) {
            this.dynamicSecurityWebApp = WebAppType.Factory.newInstance();
        }
        HashSet<String> uneffectedUrlPatterns = new HashSet<String>();
        for (String urlPattern : urlPatterns) {
            if (!this.urlPatternsConfiguredInDeploymentPlans.contains(urlPattern)) continue;
            uneffectedUrlPatterns.add(urlPattern);
        }
        Collection<String> effectedUrlPatterns = null;
        if (uneffectedUrlPatterns.size() == 0) {
            effectedUrlPatterns = urlPatterns;
        } else {
            effectedUrlPatterns = new HashSet<String>();
            effectedUrlPatterns.addAll(urlPatterns);
            effectedUrlPatterns.removeAll(uneffectedUrlPatterns);
        }
        if (this.annotationSecurityWebApp != null) {
            this.overrideSecurityConstraints(this.annotationSecurityWebApp, effectedUrlPatterns);
        }
        this.overrideSecurityConstraints(this.dynamicSecurityWebApp, effectedUrlPatterns);
        if (constraint.getHttpMethodConstraints().size() > 0) {
            for (HttpMethodConstraintElement httpMethodConstraint : constraint.getHttpMethodConstraints()) {
                this.addNewHTTPMethodSecurityConstraint(this.dynamicSecurityWebApp, httpMethodConstraint.getRolesAllowed(), httpMethodConstraint.getTransportGuarantee(), httpMethodConstraint.getEmptyRoleSemantic(), httpMethodConstraint.getMethodName(), effectedUrlPatterns);
                this.declareRoles(httpMethodConstraint.getRolesAllowed());
            }
        }
        this.addNewHTTPSecurityConstraint(this.dynamicSecurityWebApp, constraint.getRolesAllowed(), constraint.getTransportGuarantee(), constraint.getEmptyRoleSemantic(), constraint.getMethodNames().toArray(new String[0]), effectedUrlPatterns);
        this.declareRoles(constraint.getRolesAllowed());
        return uneffectedUrlPatterns;
    }

    private void overrideSecurityConstraints(WebAppType webApp, Collection<String> urlPatterns) {
        for (SecurityConstraintType securityConstraint : webApp.getSecurityConstraintArray()) {
            int iCurrentWebResourceCollectionIndex = 0;
            for (WebResourceCollectionType webResourceCollection : securityConstraint.getWebResourceCollectionArray()) {
                HashSet<String> validateAnnotationUrlPatterns = new HashSet<String>();
                for (UrlPatternType urlPattern : webResourceCollection.getUrlPatternArray()) {
                    if (urlPatterns.contains(urlPattern.getStringValue())) continue;
                    validateAnnotationUrlPatterns.add(urlPattern.getStringValue());
                }
                if (validateAnnotationUrlPatterns.size() == 0) {
                    securityConstraint.removeWebResourceCollection(iCurrentWebResourceCollectionIndex);
                    continue;
                }
                if (validateAnnotationUrlPatterns.size() < webResourceCollection.getUrlPatternArray().length) {
                    int iLoopSize = webResourceCollection.getUrlPatternArray().length;
                    for (int i = 0; i < iLoopSize; ++i) {
                        webResourceCollection.removeUrlPattern(0);
                    }
                    for (String validateAnnotationUrlPattern : validateAnnotationUrlPatterns) {
                        webResourceCollection.addNewUrlPattern().setStringValue(validateAnnotationUrlPattern);
                    }
                }
                ++iCurrentWebResourceCollectionIndex;
            }
        }
    }

    public ComponentPermissions buildSpecSecurityConfig() {
        if (this.dynamicSecurityWebApp != null) {
            for (SecurityConstraintType securityConstraintType : this.dynamicSecurityWebApp.getSecurityConstraintArray()) {
                this.initialWebApp.addNewSecurityConstraint().set((XmlObject)securityConstraintType);
            }
        }
        if (this.annotationSecurityWebApp != null) {
            for (SecurityConstraintType securityConstraintType : this.annotationSecurityWebApp.getSecurityConstraintArray()) {
                this.initialWebApp.addNewSecurityConstraint().set((XmlObject)securityConstraintType);
            }
        }
        this.collectRoleNames(this.initialWebApp.getSecurityRoleArray());
        try {
            for (SecurityConstraintType securityConstraintType : this.initialWebApp.getServletArray()) {
                this.processRoleRefPermissions((ServletType)securityConstraintType);
            }
            this.addUnmappedJSPPermissions();
            this.analyzeSecurityConstraints(this.initialWebApp.getSecurityConstraintArray());
            this.removeExcludedDups();
            return this.buildComponentPermissions();
        }
        catch (PolicyContextException e) {
            throw new IllegalStateException("Should not happen", e);
        }
    }

    private void analyzeSecurityConstraints(SecurityConstraintType[] securityConstraintArray) {
        for (SecurityConstraintType securityConstraintType : securityConstraintArray) {
            WebResourceCollectionType[] webResourceCollectionTypeArray;
            Map<String, URLPattern> currentPatterns = securityConstraintType.isSetAuthConstraint() ? (securityConstraintType.getAuthConstraint().getRoleNameArray().length == 0 ? this.excludedPatterns : this.rolesPatterns) : this.uncheckedPatterns;
            String transport = "";
            if (securityConstraintType.isSetUserDataConstraint()) {
                transport = securityConstraintType.getUserDataConstraint().getTransportGuarantee().getStringValue().trim().toUpperCase();
            }
            for (WebResourceCollectionType webResourceCollectionType : webResourceCollectionTypeArray = securityConstraintType.getWebResourceCollectionArray()) {
                HashSet<String> httpMethods = new HashSet<String>();
                boolean isExcludedList = true;
                if (webResourceCollectionType.getHttpMethodArray().length > 0) {
                    isExcludedList = false;
                    for (String string : webResourceCollectionType.getHttpMethodArray()) {
                        if (string == null) continue;
                        httpMethods.add(string.trim());
                    }
                } else if (webResourceCollectionType.getHttpMethodOmissionArray().length > 0) {
                    for (String string : webResourceCollectionType.getHttpMethodOmissionArray()) {
                        if (string == null) continue;
                        httpMethods.add(string.trim());
                    }
                }
                for (String string : webResourceCollectionType.getUrlPatternArray()) {
                    String url = string.getStringValue().trim();
                    URLPattern pattern = currentPatterns.get(url);
                    if (pattern == null) {
                        pattern = new URLPattern(url, httpMethods, isExcludedList);
                        currentPatterns.put(url, pattern);
                    } else {
                        pattern.addMethods(httpMethods, isExcludedList);
                    }
                    URLPattern allPattern = this.allMap.get(url);
                    if (allPattern == null) {
                        allPattern = new URLPattern(url, httpMethods, isExcludedList);
                        this.allSet.add(allPattern);
                        this.allMap.put(url, allPattern);
                    } else {
                        allPattern.addMethods(httpMethods, isExcludedList);
                    }
                    if (currentPatterns == this.rolesPatterns) {
                        RoleNameType[] roleNameTypeArray;
                        for (RoleNameType roleNameType : roleNameTypeArray = securityConstraintType.getAuthConstraint().getRoleNameArray()) {
                            String role = roleNameType.getStringValue().trim();
                            if (role.equals("*")) {
                                pattern.addAllRoles(this.securityRoles);
                                continue;
                            }
                            pattern.addRole(role);
                        }
                    }
                    pattern.setTransport(transport);
                }
            }
        }
    }

    private void removeExcludedDups() {
        for (Map.Entry<String, URLPattern> excluded : this.excludedPatterns.entrySet()) {
            String url = excluded.getKey();
            URLPattern pattern = excluded.getValue();
            this.removeExcluded(url, pattern, this.uncheckedPatterns);
            this.removeExcluded(url, pattern, this.rolesPatterns);
        }
    }

    private void removeExcluded(String url, URLPattern pattern, Map<String, URLPattern> patterns) {
        URLPattern testPattern = patterns.get(url);
        if (testPattern != null && !testPattern.removeMethods(pattern)) {
            patterns.remove(url);
        }
    }

    private ComponentPermissions buildComponentPermissions() throws PolicyContextException {
        HTTPMethods methods;
        HTTPMethods methods2;
        String actions;
        String name;
        for (URLPattern pattern : this.excludedPatterns.values()) {
            name = pattern.getQualifiedPattern(this.allSet);
            actions = pattern.getMethods();
            this.policyConfiguration.addToExcludedPolicy((Permission)new WebResourcePermission(name, actions));
            this.policyConfiguration.addToExcludedPolicy((Permission)new WebUserDataPermission(name, actions));
        }
        for (URLPattern pattern : this.rolesPatterns.values()) {
            name = pattern.getQualifiedPattern(this.allSet);
            actions = pattern.getMethods();
            WebResourcePermission permission = new WebResourcePermission(name, actions);
            for (String roleName : pattern.getRoles()) {
                this.policyConfiguration.addToRole(roleName, (Permission)permission);
            }
            HTTPMethods methods3 = pattern.getHTTPMethods();
            int transportType = pattern.getTransport();
            this.addOrUpdatePattern(this.uncheckedUserPatterns, name, methods3, transportType);
        }
        for (URLPattern pattern : this.uncheckedPatterns.values()) {
            name = pattern.getQualifiedPattern(this.allSet);
            methods2 = pattern.getHTTPMethods();
            this.addOrUpdatePattern(this.uncheckedResourcePatterns, name, methods2, 0);
            int transportType = pattern.getTransport();
            this.addOrUpdatePattern(this.uncheckedUserPatterns, name, methods2, transportType);
        }
        for (URLPattern pattern : this.allSet) {
            name = pattern.getQualifiedPattern(this.allSet);
            methods2 = pattern.getComplementedHTTPMethods();
            if (methods2.isNone()) continue;
            this.addOrUpdatePattern(this.uncheckedResourcePatterns, name, methods2, 0);
            this.addOrUpdatePattern(this.uncheckedUserPatterns, name, methods2, 0);
        }
        if (!this.allMap.containsKey("/")) {
            URLPattern pattern = new URLPattern("/", Collections.EMPTY_SET, false);
            String name2 = pattern.getQualifiedPattern(this.allSet);
            methods = pattern.getComplementedHTTPMethods();
            this.addOrUpdatePattern(this.uncheckedResourcePatterns, name2, methods, 0);
            this.addOrUpdatePattern(this.uncheckedUserPatterns, name2, methods, 0);
        }
        for (UncheckedItem item : this.uncheckedResourcePatterns.keySet()) {
            methods = this.uncheckedResourcePatterns.get(item);
            actions = URLPattern.getMethodsWithTransport(methods, item.getTransportType());
            this.policyConfiguration.addToUncheckedPolicy((Permission)new WebResourcePermission(item.getName(), actions));
        }
        for (UncheckedItem item : this.uncheckedUserPatterns.keySet()) {
            methods = this.uncheckedUserPatterns.get(item);
            actions = URLPattern.getMethodsWithTransport(methods, item.getTransportType());
            this.policyConfiguration.addToUncheckedPolicy((Permission)new WebUserDataPermission(item.getName(), actions));
        }
        return this.policyConfiguration.getComponentPermissions();
    }

    private void addOrUpdatePattern(Map<UncheckedItem, HTTPMethods> patternMap, String name, HTTPMethods actions, int transportType) {
        UncheckedItem item = new UncheckedItem(name, transportType);
        HTTPMethods existingActions = patternMap.get(item);
        if (existingActions != null) {
            patternMap.put(item, existingActions.add(actions));
        } else {
            patternMap.put(item, new HTTPMethods(actions, false));
        }
    }

    protected void processRoleRefPermissions(ServletType servletType) throws PolicyContextException {
        String servletName = servletType.getServletName().getStringValue().trim();
        SecurityRoleRefType[] securityRoleRefTypeArray = servletType.getSecurityRoleRefArray();
        HashSet<String> unmappedRoles = new HashSet<String>(this.securityRoles);
        for (SecurityRoleRefType securityRoleRefType : securityRoleRefTypeArray) {
            String roleName = securityRoleRefType.getRoleName().getStringValue().trim();
            String roleLink = securityRoleRefType.getRoleLink().getStringValue().trim();
            this.policyConfiguration.addToRole(roleLink, (Permission)new WebRoleRefPermission(servletName, roleName));
            unmappedRoles.remove(roleName);
        }
        for (String roleName : unmappedRoles) {
            this.policyConfiguration.addToRole(roleName, (Permission)new WebRoleRefPermission(servletName, roleName));
        }
    }

    protected void addUnmappedJSPPermissions() throws PolicyContextException {
        for (String roleName : this.securityRoles) {
            this.policyConfiguration.addToRole(roleName, (Permission)new WebRoleRefPermission("", roleName));
        }
    }

    protected void collectRoleNames(SecurityRoleType[] securityRoles) {
        for (SecurityRoleType securityRole : securityRoles) {
            this.securityRoles.add(securityRole.getRoleName().getStringValue().trim());
        }
    }

    private void initialize() {
        for (SecurityConstraintType secuirtyConstrait : this.initialWebApp.getSecurityConstraintArray()) {
            for (WebResourceCollectionType webResourceCollection : secuirtyConstrait.getWebResourceCollectionArray()) {
                for (UrlPatternType urlPattern : webResourceCollection.getUrlPatternArray()) {
                    this.urlPatternsConfiguredInDeploymentPlans.add(urlPattern.getStringValue());
                }
            }
        }
        if (this.annotationScanRequired) {
            this.annotationSecurityWebApp = WebAppType.Factory.newInstance();
            this.scanServletConstraintAnnotations();
        }
    }

    private void scanServletConstraintAnnotations() {
        try {
            Map<String, Set<String>> servletClassNameUrlPatternsMap = this.genetateServletClassUrlPatternsMap();
            for (ServletType servlet : this.initialWebApp.getServletArray()) {
                ServletSecurity servletSecurity;
                String servletClassName;
                Class cls;
                if (servlet.getServletClass() == null || servlet.getServletClass().getStringValue().isEmpty() || !Servlet.class.isAssignableFrom(cls = this.bundle.loadClass(servletClassName = servlet.getServletClass().getStringValue())) || (servletSecurity = cls.getAnnotation(ServletSecurity.class)) == null) continue;
                Set<String> urlPatterns = servletClassNameUrlPatternsMap.get(servletClassName);
                if (urlPatterns == null || urlPatterns.isEmpty()) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("No url pattern for the servlet class " + servletClassName + " is found in the deployment plan, SecurityConstraint annotation is ignored");
                    continue;
                }
                HttpConstraint httpConstraint = servletSecurity.value();
                if (servletSecurity.httpMethodConstraints().length > 0) {
                    String[] omissionMethods = new String[servletSecurity.httpMethodConstraints().length];
                    int iIndex = 0;
                    for (HttpMethodConstraint httpMethodConstraint : servletSecurity.httpMethodConstraints()) {
                        String httpMethod = httpMethodConstraint.value().trim();
                        omissionMethods[iIndex++] = httpMethod;
                        this.addNewHTTPMethodSecurityConstraint(this.annotationSecurityWebApp, httpMethodConstraint.rolesAllowed(), httpMethodConstraint.transportGuarantee(), httpMethodConstraint.emptyRoleSemantic(), httpMethod, urlPatterns);
                    }
                    this.addNewHTTPSecurityConstraint(this.annotationSecurityWebApp, httpConstraint.rolesAllowed(), httpConstraint.transportGuarantee(), httpConstraint.value(), omissionMethods, urlPatterns);
                    continue;
                }
                this.addNewHTTPSecurityConstraint(this.annotationSecurityWebApp, httpConstraint.rolesAllowed(), httpConstraint.transportGuarantee(), httpConstraint.value(), new String[0], urlPatterns);
            }
        }
        catch (ClassNotFoundException e) {
            logger.error("Fail to load class", (Throwable)e);
        }
    }

    private SecurityConstraintType addNewSecurityConstraint(WebAppType webApp, String[] rolesAllowed, ServletSecurity.TransportGuarantee transportGuarantee, ServletSecurity.EmptyRoleSemantic emptyRoleSemantic) {
        if (rolesAllowed.length > 0 || transportGuarantee.equals((Object)ServletSecurity.TransportGuarantee.CONFIDENTIAL) || emptyRoleSemantic.equals((Object)ServletSecurity.EmptyRoleSemantic.DENY)) {
            SecurityConstraintType securityConstraint = webApp.addNewSecurityConstraint();
            if (transportGuarantee.equals((Object)ServletSecurity.TransportGuarantee.CONFIDENTIAL)) {
                securityConstraint.addNewUserDataConstraint().addNewTransportGuarantee().setStringValue(ServletSecurity.TransportGuarantee.CONFIDENTIAL.name());
            }
            if (emptyRoleSemantic.equals((Object)ServletSecurity.EmptyRoleSemantic.DENY)) {
                securityConstraint.addNewAuthConstraint();
            } else {
                AuthConstraintType authConstraint = securityConstraint.addNewAuthConstraint();
                for (String roleAllowed : rolesAllowed) {
                    authConstraint.addNewRoleName().setStringValue(roleAllowed);
                }
            }
            return securityConstraint;
        }
        return null;
    }

    private SecurityConstraintType addNewHTTPSecurityConstraint(WebAppType webApp, String[] rolesAllowed, ServletSecurity.TransportGuarantee transportGuarantee, ServletSecurity.EmptyRoleSemantic emptyRoleSemantic, String[] omissionMethods, Collection<String> urlPatterns) {
        SecurityConstraintType securityConstraint = this.addNewSecurityConstraint(webApp, rolesAllowed, transportGuarantee, emptyRoleSemantic);
        if (omissionMethods.length > 0 || securityConstraint != null) {
            if (securityConstraint == null) {
                securityConstraint = webApp.addNewSecurityConstraint();
            }
            WebResourceCollectionType webResourceCollection = securityConstraint.getWebResourceCollectionArray().length == 0 ? securityConstraint.addNewWebResourceCollection() : securityConstraint.getWebResourceCollectionArray(0);
            for (String omissionMethod : omissionMethods) {
                webResourceCollection.addNewHttpMethodOmission().setStringValue(omissionMethod);
            }
            for (String urlPattern : urlPatterns) {
                webResourceCollection.addNewUrlPattern().setStringValue(urlPattern);
            }
        }
        return securityConstraint;
    }

    private SecurityConstraintType addNewHTTPMethodSecurityConstraint(WebAppType webApp, String[] rolesAllowed, ServletSecurity.TransportGuarantee transportGuarantee, ServletSecurity.EmptyRoleSemantic emptyRoleSemantic, String httpMethod, Collection<String> urlPatterns) {
        SecurityConstraintType securityConstraint = this.addNewSecurityConstraint(webApp, rolesAllowed, transportGuarantee, emptyRoleSemantic);
        if (securityConstraint == null) {
            securityConstraint = webApp.addNewSecurityConstraint();
        }
        WebResourceCollectionType webResourceCollection = securityConstraint.getWebResourceCollectionArray().length == 0 ? securityConstraint.addNewWebResourceCollection() : securityConstraint.getWebResourceCollectionArray(0);
        for (String urlPattern : urlPatterns) {
            webResourceCollection.addNewUrlPattern().setStringValue(urlPattern);
        }
        webResourceCollection.addNewHttpMethod().setStringValue(httpMethod);
        return securityConstraint;
    }

    private Map<String, Set<String>> genetateServletClassUrlPatternsMap() {
        HashMap servletNameUrlPatternsMap = new HashMap();
        for (ServletMappingType servletMapping : this.initialWebApp.getServletMappingArray()) {
            String servletName = servletMapping.getServletName().getStringValue();
            HashSet<String> urlPatterns = (HashSet<String>)servletNameUrlPatternsMap.get(servletName);
            if (urlPatterns == null) {
                urlPatterns = new HashSet<String>();
                servletNameUrlPatternsMap.put(servletName, urlPatterns);
            }
            for (UrlPatternType urlPattern : servletMapping.getUrlPatternArray()) {
                if (this.urlPatternsConfiguredInDeploymentPlans.contains(urlPattern.getStringValue())) continue;
                urlPatterns.add(urlPattern.getStringValue());
            }
        }
        HashMap<String, Set<String>> servletClassUrlPatternsMap = new HashMap<String, Set<String>>();
        for (ServletType servlet : this.initialWebApp.getServletArray()) {
            Set servletMappingUrlPatterns;
            if (servlet.getServletClass() == null || servlet.getServletClass().getStringValue().isEmpty()) continue;
            String servletClassName = servlet.getServletClass().getStringValue();
            HashSet urlPatterns = (HashSet)servletClassUrlPatternsMap.get(servlet.getServletClass().getStringValue());
            if (urlPatterns == null) {
                urlPatterns = new HashSet();
                servletClassUrlPatternsMap.put(servletClassName, urlPatterns);
            }
            if ((servletMappingUrlPatterns = (Set)servletNameUrlPatternsMap.get(servlet.getServletName().getStringValue())) == null) continue;
            urlPatterns.addAll(servletMappingUrlPatterns);
        }
        return servletClassUrlPatternsMap;
    }

    public void clear() {
        this.securityRoles.clear();
        this.uncheckedPatterns.clear();
        this.uncheckedResourcePatterns.clear();
        this.uncheckedUserPatterns.clear();
        this.excludedPatterns.clear();
        this.rolesPatterns.clear();
        this.allSet.clear();
        this.allMap.clear();
        this.initialWebApp = null;
        this.bundle = null;
        this.urlPatternsConfiguredInDeploymentPlans = null;
        this.dynamicSecurityWebApp = null;
        this.annotationSecurityWebApp = null;
    }

    private static class RecordingPolicyConfiguration
    implements PolicyConfiguration {
        private final PermissionCollection excludedPermissions = new Permissions();
        private final PermissionCollection uncheckedPermissions = new Permissions();
        private final Map<String, PermissionCollection> rolePermissions = new HashMap<String, PermissionCollection>();
        private final StringBuilder audit;

        private RecordingPolicyConfiguration(boolean audit) {
            this.audit = audit ? new StringBuilder() : null;
        }

        public String getContextID() throws PolicyContextException {
            return null;
        }

        public void addToRole(String roleName, PermissionCollection permissions) {
            throw new IllegalStateException("not implemented");
        }

        public void addToRole(String roleName, Permission permission) throws PolicyContextException {
            PermissionCollection permissionsForRole;
            if (this.audit != null) {
                this.audit.append("Role: ").append(roleName).append(" -> ").append(permission).append('\n');
            }
            if ((permissionsForRole = this.rolePermissions.get(roleName)) == null) {
                permissionsForRole = new Permissions();
                this.rolePermissions.put(roleName, permissionsForRole);
            }
            permissionsForRole.add(permission);
        }

        public void addToUncheckedPolicy(PermissionCollection permissions) {
            throw new IllegalStateException("not implemented");
        }

        public void addToUncheckedPolicy(Permission permission) throws PolicyContextException {
            if (this.audit != null) {
                this.audit.append("Unchecked -> ").append(permission).append('\n');
            }
            this.uncheckedPermissions.add(permission);
        }

        public void addToExcludedPolicy(PermissionCollection permissions) {
            throw new IllegalStateException("not implemented");
        }

        public void addToExcludedPolicy(Permission permission) throws PolicyContextException {
            if (this.audit != null) {
                this.audit.append("Excluded -> ").append(permission).append('\n');
            }
            this.excludedPermissions.add(permission);
        }

        public void removeRole(String roleName) throws PolicyContextException {
            throw new IllegalStateException("not implemented");
        }

        public void removeUncheckedPolicy() throws PolicyContextException {
            throw new IllegalStateException("not implemented");
        }

        public void removeExcludedPolicy() throws PolicyContextException {
            throw new IllegalStateException("not implemented");
        }

        public void linkConfiguration(PolicyConfiguration link) throws PolicyContextException {
            throw new IllegalStateException("not implemented");
        }

        public void delete() throws PolicyContextException {
            throw new IllegalStateException("not implemented");
        }

        public void commit() throws PolicyContextException {
            throw new IllegalStateException("not implemented");
        }

        public boolean inService() throws PolicyContextException {
            throw new IllegalStateException("not implemented");
        }

        public ComponentPermissions getComponentPermissions() {
            return new ComponentPermissions(this.excludedPermissions, this.uncheckedPermissions, this.rolePermissions);
        }

        public String getAudit() {
            if (this.audit == null) {
                return "no audit kept";
            }
            return this.audit.toString();
        }
    }
}

