/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.osgi.web.extender;

import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebContainerEventDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebContainerEventDispatcher.class);
    private ServiceTracker tracker;
    private Bundle extenderBundle;

    public WebContainerEventDispatcher(BundleContext bundleContext) {
        this.extenderBundle = bundleContext.getBundle();
        if (this.isEventAdminPresent()) {
            this.tracker = new ServiceTracker(bundleContext, EventAdmin.class.getName(), null);
            this.tracker.open();
        }
    }

    private boolean isEventAdminPresent() {
        try {
            this.getClass().getClassLoader().loadClass("org.osgi.service.event.EventAdmin");
            return true;
        }
        catch (Throwable t) {
            LOGGER.debug("EventAdmin package is not available, just don't use it");
            return false;
        }
    }

    public void deploying(Bundle bundle, String contextPath) {
        this.dispatch("org/osgi/service/web/DEPLOYING", bundle, contextPath);
    }

    public void deployed(Bundle bundle, String contextPath) {
        this.dispatch("org/osgi/service/web/DEPLOYED", bundle, contextPath);
    }

    public void undeploying(Bundle bundle, String contextPath) {
        this.dispatch("org/osgi/service/web/UNDEPLOYING", bundle, contextPath);
    }

    public void undeployed(Bundle bundle, String contextPath) {
        this.dispatch("org/osgi/service/web/UNDEPLOYED", bundle, contextPath);
    }

    public void failed(Bundle bundle, String contextPath, Throwable cause) {
        EventAdmin eventAdmin = this.getEventAdmin();
        if (eventAdmin == null) {
            return;
        }
        Dictionary<String, Object> props = this.createDefaultProperties(bundle, contextPath);
        if (cause != null) {
            props.put("exception", cause);
        }
        eventAdmin.postEvent(new Event("org/osgi/service/web/FAILED", props));
    }

    public void collision(Bundle bundle, String contextPath, Collection<Long> bundleId) {
        EventAdmin eventAdmin = this.getEventAdmin();
        if (eventAdmin == null) {
            return;
        }
        Dictionary<String, Object> props = this.createDefaultProperties(bundle, contextPath);
        props.put("collision", contextPath);
        props.put("collision.bundles", bundleId);
        eventAdmin.postEvent(new Event("org/osgi/service/web/FAILED", props));
    }

    private void dispatch(String topic, Bundle bundle, String contextPath) {
        EventAdmin eventAdmin = this.getEventAdmin();
        if (eventAdmin == null) {
            return;
        }
        Dictionary<String, Object> props = this.createDefaultProperties(bundle, contextPath);
        eventAdmin.postEvent(new Event(topic, props));
    }

    private Dictionary<String, Object> createDefaultProperties(Bundle bundle, String contextPath) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("bundle.symbolicName", bundle.getSymbolicName());
        ((Dictionary)props).put("bundle.id", bundle.getBundleId());
        ((Dictionary)props).put("bundle", bundle);
        ((Dictionary)props).put("bundle.version", this.getBundleVersion(bundle));
        ((Dictionary)props).put("timestamp", System.currentTimeMillis());
        ((Dictionary)props).put("context.path", contextPath);
        ((Dictionary)props).put("extender.bundle", this.extenderBundle);
        ((Dictionary)props).put("extender.bundle.id", this.extenderBundle.getBundleId());
        ((Dictionary)props).put("extender.bundle.symbolicName", this.extenderBundle.getSymbolicName());
        ((Dictionary)props).put("extender.bundle.version", this.getBundleVersion(this.extenderBundle));
        return props;
    }

    private EventAdmin getEventAdmin() {
        return this.tracker != null ? (EventAdmin)this.tracker.getService() : null;
    }

    public void destroy() {
        if (this.tracker != null) {
            this.tracker.close();
        }
    }

    private Version getBundleVersion(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        String version = (String)headers.get("Bundle-Version");
        return version != null ? Version.parseVersion((String)version) : Version.emptyVersion;
    }
}

