/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import java.util.ArrayList;
import java.util.List;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.webfragment.ServletMappingUrlPatternMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.SubMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.openejb.jee.ServletMapping;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;

public class ServletMappingMergeHandler
implements WebFragmentMergeHandler<WebFragment, WebApp> {
    private List<SubMergeHandler<ServletMapping, ServletMapping>> subMergeHandlers = new ArrayList<SubMergeHandler<ServletMapping, ServletMapping>>(1);

    public ServletMappingMergeHandler() {
        this.subMergeHandlers.add(new ServletMappingUrlPatternMergeHandler());
    }

    @Override
    public void merge(WebFragment webFragment, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (ServletMapping srcServletMapping : webFragment.getServletMapping()) {
            String servletName = srcServletMapping.getServletName();
            ServletMapping targetServletMapping = (ServletMapping)mergeContext.getAttribute(ServletMappingMergeHandler.createServletMappingKey(servletName));
            if (targetServletMapping == null) {
                webApp.getServletMapping().add(srcServletMapping);
                mergeContext.setAttribute(ServletMappingMergeHandler.createServletMappingKey(servletName), srcServletMapping);
                for (SubMergeHandler<ServletMapping, ServletMapping> subMergeHandler : this.subMergeHandlers) {
                    subMergeHandler.add(srcServletMapping, mergeContext);
                }
                continue;
            }
            if (ServletMappingMergeHandler.isServletMappingFromWebXml(servletName, mergeContext)) continue;
            if (ServletMappingMergeHandler.isServletMappingFromAnnotation(servletName, mergeContext) && !srcServletMapping.getUrlPattern().isEmpty()) {
                targetServletMapping.getUrlPattern().clear();
                mergeContext.removeAttribute(ServletMappingMergeHandler.createServletMappingSourceKey(servletName));
            }
            for (SubMergeHandler<ServletMapping, ServletMapping> subMergeHandler : this.subMergeHandlers) {
                subMergeHandler.merge(srcServletMapping, targetServletMapping, mergeContext);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
        for (SubMergeHandler<ServletMapping, ServletMapping> subMergeHandler : this.subMergeHandlers) {
            subMergeHandler.postProcessWebXmlElement(webApp, context);
        }
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
        for (ServletMapping servletMapping : webApp.getServletMapping()) {
            String servletName = servletMapping.getServletName();
            context.setAttribute(ServletMappingMergeHandler.createServletMappingKey(servletName), servletMapping);
            context.setAttribute(ServletMappingMergeHandler.createServletMappingSourceKey(servletName), (Object)ElementSource.WEB_XML);
        }
        for (SubMergeHandler subMergeHandler : this.subMergeHandlers) {
            subMergeHandler.preProcessWebXmlElement(webApp, context);
        }
    }

    public static String createServletMappingKey(String servletName) {
        return "servlet-mapping.servlet-name" + servletName;
    }

    public static String createServletMappingSourceKey(String servletName) {
        return "servlet-mapping.servlet-name." + servletName + ".sources";
    }

    public static void addServletMapping(ServletMapping servletMapping, MergeContext mergeContext) {
        mergeContext.setAttribute(ServletMappingMergeHandler.createServletMappingKey(servletMapping.getServletName()), servletMapping);
    }

    public static boolean isServletMappingConfigured(String servletName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(ServletMappingMergeHandler.createServletMappingKey(servletName));
    }

    public static boolean isServletMappingFromAnnotation(String servletName, MergeContext mergeContext) {
        ElementSource elementSource = (ElementSource)((Object)mergeContext.getAttribute(ServletMappingMergeHandler.createServletMappingSourceKey(servletName)));
        return elementSource != null && elementSource.equals((Object)ElementSource.ANNOTATION);
    }

    public static boolean isServletMappingFromWebXml(String servletName, MergeContext mergeContext) {
        ElementSource elementSource = (ElementSource)((Object)mergeContext.getAttribute(ServletMappingMergeHandler.createServletMappingSourceKey(servletName)));
        return elementSource != null && elementSource.equals((Object)ElementSource.WEB_XML);
    }
}

