/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.openejb.jee.DataSource;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;

public class DataSourceMergeHandler
implements WebFragmentMergeHandler<WebFragment, WebApp> {
    @Override
    public void merge(WebFragment webFragment, WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (DataSource srcDataSource : webFragment.getDataSource()) {
            String dataSourceKey = DataSourceMergeHandler.createDataSourceKey(srcDataSource, mergeContext);
            MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(dataSourceKey);
            if (mergeItem != null && mergeItem.isFromWebFragment()) {
                throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateJNDIRefMessage("data-source", srcDataSource.getName(), mergeContext.getCurrentJarUrl(), mergeItem.getBelongedURL()));
            }
            webApp.getDataSource().add(srcDataSource);
            mergeContext.setAttribute(dataSourceKey, new MergeItem(srcDataSource, mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
        }
    }

    @Override
    public void postProcessWebXmlElement(WebApp webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebApp webApp, MergeContext mergeContext) throws DeploymentException {
        for (DataSource dataSource : webApp.getDataSource()) {
            mergeContext.setAttribute(DataSourceMergeHandler.createDataSourceKey(dataSource, mergeContext), new MergeItem(dataSource, null, ElementSource.WEB_XML));
        }
    }

    public static String createDataSourceKey(DataSource dataSource, MergeContext mergeContext) {
        return "data-source.name." + dataSource.getName();
    }
}

