/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.annotation.HandlesTypes;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.util.CircularReferencesException;
import org.apache.geronimo.j2ee.deployment.util.FragmentSortUtils;
import org.apache.geronimo.j2ee.deployment.util.IllegalConfigurationException;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.geronimo.kernel.util.JoinUtils;
import org.apache.geronimo.web25.deployment.AbstractWebModuleBuilder;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.annotation.AnnotationMergeHandler;
import org.apache.geronimo.web25.deployment.merge.annotation.ServletSecurityAnnotationMergeHandler;
import org.apache.geronimo.web25.deployment.merge.annotation.WebFilterAnnotationMergeHandler;
import org.apache.geronimo.web25.deployment.merge.annotation.WebListenerAnnotationMergeHandler;
import org.apache.geronimo.web25.deployment.merge.annotation.WebServletAnnotationMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.DataSourceMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.EjbLocalRefMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.EjbRefMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.EnvEntryMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.ErrorPageMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.FilterMappingMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.FilterMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.JspConfigMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.ListenerMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.LocaleEncodingMappingListMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.LoginConfigMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.MessageDestinationMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.MessageDestinationRefMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.MimeMappingMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.PersistenceContextRefMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.PersistenceUnitRefMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.PostConstructMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.PreDestroyMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.ResourceEnvRefMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.ResourceRefMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.SecurityConstraintMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.SecurityRoleMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.ServiceRefMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.ServletMappingMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.ServletMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.SessionConfigMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentEntry;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.WelcomeFileListMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.openejb.jee.AbsoluteOrdering;
import org.apache.openejb.jee.JaxbJavaee;
import org.apache.openejb.jee.Ordering;
import org.apache.openejb.jee.OrderingOrdering;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebFragment;
import org.apache.xbean.finder.BundleAnnotationFinder;
import org.apache.xbean.finder.BundleAssignableClassFinder;
import org.apache.xbean.osgi.bundle.util.BundleResourceFinder;
import org.apache.xbean.osgi.bundle.util.ClassDiscoveryFilter;
import org.apache.xbean.osgi.bundle.util.DiscoveryRange;
import org.apache.xbean.osgi.bundle.util.ResourceDiscoveryFilter;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class MergeHelper {
    private static final Logger logger = LoggerFactory.getLogger(MergeHelper.class);
    private static final AnnotationMergeHandler WEB_FILTER_ANNOTATION_MERGE_HANDLER = new WebFilterAnnotationMergeHandler();
    private static final WebFragmentMergeHandler[] WEB_FRAGMENT_MERGE_HANDLERS = new WebFragmentMergeHandler[]{new FilterMergeHandler(), new FilterMappingMergeHandler(), new ListenerMergeHandler(), new ServletMergeHandler(), new ServletMappingMergeHandler(), new SessionConfigMergeHandler(), new MimeMappingMergeHandler(), new WelcomeFileListMergeHandler(), new ErrorPageMergeHandler(), new JspConfigMergeHandler(), new SecurityConstraintMergeHandler(), new LoginConfigMergeHandler(), new SecurityRoleMergeHandler(), new EnvEntryMergeHandler(), new EjbRefMergeHandler(), new EjbLocalRefMergeHandler(), new ResourceRefMergeHandler(), new ResourceEnvRefMergeHandler(), new MessageDestinationRefMergeHandler(), new PersistenceContextRefMergeHandler(), new PersistenceUnitRefMergeHandler(), new PostConstructMergeHandler(), new PreDestroyMergeHandler(), new DataSourceMergeHandler(), new ServiceRefMergeHandler(), new MessageDestinationMergeHandler(), new LocaleEncodingMappingListMergeHandler()};
    private static final AnnotationMergeHandler WEB_LISTENER_ANNOTATION_MERGE_HANDLER = new WebListenerAnnotationMergeHandler();
    private static final AnnotationMergeHandler WEB_SERVLET_ANNOTATION_MERGE_HANDLER = new WebServletAnnotationMergeHandler();
    private static final AnnotationMergeHandler SERVLET_SECURITY_ANNOTATION_MERGE_HANDLER = new ServletSecurityAnnotationMergeHandler();

    public static WebFragmentEntry[] absoluteOrderWebFragments(EARContext earContext, Module module, Bundle bundle, WebApp webApp, Map<String, WebFragmentEntry> webFragmentEntryMap) throws DeploymentException {
        String webFragmentName;
        AbsoluteOrdering absoluteOrdering = webApp.getAbsoluteOrdering();
        LinkedHashSet<String> expliciteConfiguredWebFragmentNames = new LinkedHashSet<String>();
        LinkedList<WebFragmentEntry> orderedWebFragments = new LinkedList<WebFragmentEntry>();
        LinkedHashMap<String, WebFragmentEntry> unusedWebFragmentEntryMap = new LinkedHashMap<String, WebFragmentEntry>(webFragmentEntryMap);
        for (Object o : absoluteOrdering.getNameOrOthers()) {
            if (!(o instanceof String)) continue;
            webFragmentName = (String)o;
            unusedWebFragmentEntryMap.remove(webFragmentName);
        }
        for (Object o : absoluteOrdering.getNameOrOthers()) {
            if (o instanceof String) {
                webFragmentName = (String)o;
                if (!webFragmentEntryMap.containsKey(webFragmentName) || expliciteConfiguredWebFragmentNames.contains(webFragmentName)) continue;
                expliciteConfiguredWebFragmentNames.add(webFragmentName);
                orderedWebFragments.add(webFragmentEntryMap.get(webFragmentName));
                continue;
            }
            expliciteConfiguredWebFragmentNames.addAll(unusedWebFragmentEntryMap.keySet());
            orderedWebFragments.addAll(unusedWebFragmentEntryMap.values());
            unusedWebFragmentEntryMap.clear();
        }
        Set excludedURLs = (Set)AbstractWebModuleBuilder.EXCLUDED_JAR_URLS.get(module.getEarContext().getGeneralData());
        for (WebFragmentEntry excludedFragment : unusedWebFragmentEntryMap.values()) {
            excludedURLs.add(excludedFragment.getJarURL());
        }
        WebFragmentEntry[] webFragmentEntries = orderedWebFragments.toArray(new WebFragmentEntry[orderedWebFragments.size()]);
        MergeHelper.saveOrderedLibAttribute(earContext, module, webFragmentEntries);
        return webFragmentEntries;
    }

    public static void mergeAnnotations(Bundle bundle, WebApp webApp, MergeContext mergeContext, final String prefix) throws DeploymentException {
        final boolean isJarFile = prefix.endsWith(".jar");
        try {
            BundleAnnotationFinder bundleAnnotationFinder = new BundleAnnotationFinder(null, bundle, new ResourceDiscoveryFilter(){

                public boolean directoryDiscoveryRequired(String url) {
                    return !isJarFile;
                }

                public boolean rangeDiscoveryRequired(DiscoveryRange discoveryRange) {
                    return discoveryRange.equals((Object)DiscoveryRange.BUNDLE_CLASSPATH);
                }

                public boolean zipFileDiscoveryRequired(String url) {
                    return isJarFile ? url.equals(prefix) : false;
                }
            });
            List webServlets = bundleAnnotationFinder.findAnnotatedClasses(WebServlet.class);
            WEB_SERVLET_ANNOTATION_MERGE_HANDLER.merge(webServlets.toArray(new Class[0]), webApp, mergeContext);
            List webFilters = bundleAnnotationFinder.findAnnotatedClasses(WebFilter.class);
            WEB_FILTER_ANNOTATION_MERGE_HANDLER.merge(webFilters.toArray(new Class[0]), webApp, mergeContext);
            List webListeners = bundleAnnotationFinder.findAnnotatedClasses(WebListener.class);
            WEB_LISTENER_ANNOTATION_MERGE_HANDLER.merge(webListeners.toArray(new Class[0]), webApp, mergeContext);
        }
        catch (Exception e) {
            throw new DeploymentException("Fail to merge annotations in " + prefix, (Throwable)e);
        }
    }

    public static boolean mergeRequired(String attributeName, String parentElementName, String elementName, String value, MergeContext mergeContext) throws DeploymentException {
        MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(attributeName);
        if (mergeItem == null) {
            mergeContext.setAttribute(attributeName, new MergeItem(value, mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
            return true;
        }
        if (mergeItem.isFromWebFragment() && !mergeItem.getValue().equals(value)) {
            throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateValueMessage(parentElementName, elementName, (String)mergeItem.getValue(), mergeItem.getBelongedURL(), value, mergeContext.getCurrentJarUrl()));
        }
        return false;
    }

    public static boolean mergeRequired(String attributeName, String parentElementName, String KeyElementName, String keyName, String valueElementName, String value, MergeContext mergeContext) throws DeploymentException {
        if (value == null) {
            return false;
        }
        MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(attributeName);
        if (mergeItem == null) {
            mergeContext.setAttribute(attributeName, new MergeItem(value, mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
            return true;
        }
        if (mergeItem.isFromWebFragment() && !mergeItem.getValue().equals(value)) {
            throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateKeyValueMessage(parentElementName, KeyElementName, keyName, valueElementName, (String)mergeItem.getValue(), mergeItem.getBelongedURL(), value, mergeContext.getCurrentJarUrl()));
        }
        return false;
    }

    public static void processServletContainerInitializer(EARContext earContext, Module module, Bundle bundle) throws DeploymentException {
        ServiceReference reference = bundle.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        final Set excludedJarNames = (Set)AbstractWebModuleBuilder.EXCLUDED_JAR_URLS.get(module.getEarContext().getGeneralData());
        final HashSet servletContainerInitializers = new HashSet();
        try {
            PackageAdmin packageAdmin = (PackageAdmin)bundle.getBundleContext().getService(reference);
            BundleResourceFinder resourceFinder = new BundleResourceFinder(packageAdmin, bundle, "META-INF/services", "javax.servlet.ServletContainerInitializer");
            resourceFinder.find(new BundleResourceFinder.ResourceFinderCallback(){

                public boolean foundInDirectory(Bundle bundle, String basePath, URL url) throws Exception {
                    return true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean foundInJar(Bundle bundle, String jarName, ZipEntry entry, InputStream in) throws Exception {
                    if (!excludedJarNames.contains(jarName)) {
                        BufferedReader bufferedReader = null;
                        try {
                            bufferedReader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                            String line = null;
                            while ((line = bufferedReader.readLine()) != null) {
                                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                                servletContainerInitializers.add(line);
                            }
                        }
                        catch (IOException e) {
                            try {
                                logger.warn("Fail to scan META-INF/services/javax.servlet.ServletContainerInitializer", (Throwable)e);
                            }
                            catch (Throwable throwable) {
                                IOUtils.close(bufferedReader);
                                throw throwable;
                            }
                            IOUtils.close((Closeable)bufferedReader);
                        }
                        IOUtils.close((Closeable)bufferedReader);
                    }
                    return true;
                }
            });
            HashMap<String, Set> servletContainerInitializerClassNamesMap = new HashMap<String, Set>();
            for (String servletContainerInitializer : servletContainerInitializers) {
                Class servletContainerInitializerClass = null;
                try {
                    servletContainerInitializerClass = bundle.loadClass(servletContainerInitializer);
                }
                catch (Exception e) {
                    logger.warn("Fail to load ServletContainerInitializer class " + servletContainerInitializer, (Throwable)e);
                    continue;
                }
                if (!ServletContainerInitializer.class.isAssignableFrom(servletContainerInitializerClass)) {
                    logger.warn("Class " + servletContainerInitializer + " does not implement ServletContainerInitializer interface, ignored");
                    continue;
                }
                HandlesTypes handlesTypes = servletContainerInitializerClass.getAnnotation(HandlesTypes.class);
                if (handlesTypes == null || handlesTypes.value().length == 0) {
                    servletContainerInitializerClassNamesMap.put(servletContainerInitializer, null);
                    continue;
                }
                BundleAssignableClassFinder bundleClassFinder = new BundleAssignableClassFinder(packageAdmin, bundle, handlesTypes.value(), new ClassDiscoveryFilter(){

                    public boolean directoryDiscoveryRequired(String directory) {
                        return true;
                    }

                    public boolean jarFileDiscoveryRequired(String jarUrl) {
                        return !excludedJarNames.contains(jarUrl);
                    }

                    public boolean packageDiscoveryRequired(String packageName) {
                        return true;
                    }

                    public boolean rangeDiscoveryRequired(DiscoveryRange discoveryRange) {
                        return discoveryRange.equals((Object)DiscoveryRange.BUNDLE_CLASSPATH);
                    }
                });
                Set acceptedClassNames = bundleClassFinder.find();
                servletContainerInitializerClassNamesMap.put(servletContainerInitializer, acceptedClassNames.size() > 0 ? acceptedClassNames : null);
            }
            module.getEarContext().getGeneralData().put(AbstractWebModuleBuilder.SERVLET_CONTAINER_INITIALIZERS, servletContainerInitializerClassNamesMap);
        }
        catch (Exception e) {
            throw new DeploymentException("Fail to scan javax.servlet.ServletContainerInitializer", (Throwable)e);
        }
        finally {
            bundle.getBundleContext().ungetService(reference);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void processWebFragmentsAndAnnotations(EARContext earContext, Module module, Bundle bundle, WebApp webApp) throws DeploymentException {
        LinkedHashMap<String, WebFragment> jarUrlWebFragmentDocumentMap = new LinkedHashMap<String, WebFragment>();
        String validJarNamePrefix = module.isStandAlone() ? "WEB-INF/lib" : module.getTargetPath() + "/WEB-INF/lib";
        WebFragmentEntry[] webFragmentEntries = null;
        Enumeration enumeration = bundle.getEntryPaths(validJarNamePrefix);
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String url = (String)enumeration.nextElement();
                if (!url.endsWith(".jar")) continue;
                WebFragment webFragment = null;
                ZipInputStream in = null;
                try {
                    ZipEntry entry;
                    in = new ZipInputStream(bundle.getEntry(url).openStream());
                    while ((entry = in.getNextEntry()) != null) {
                        if (!entry.getName().equals("META-INF/web-fragment.xml")) continue;
                        webFragment = (WebFragment)JaxbJavaee.unmarshalJavaee(WebFragment.class, (InputStream)in);
                        break;
                    }
                }
                catch (IOException e) {
                    try {
                        logger.error("Fail to parse web-fragment.xml files in jar " + url, (Throwable)e);
                        throw new DeploymentException("Fail to scan web-fragment.xml files", (Throwable)e);
                        catch (ParserConfigurationException e2) {
                            logger.error("Fail to parse web-fragment.xml files in jar " + url, (Throwable)e2);
                            throw new DeploymentException("Fail to scan web-fragment.xml files", (Throwable)e2);
                        }
                        catch (SAXException e3) {
                            logger.error("Fail to parse web-fragment.xml files in jar " + url, (Throwable)e3);
                            throw new DeploymentException("Fail to scan web-fragment.xml files", (Throwable)e3);
                        }
                        catch (JAXBException e4) {
                            logger.error("Fail to parse web-fragment.xml files in jar " + url, (Throwable)e4);
                            throw new DeploymentException("Fail to scan web-fragment.xml files", (Throwable)e4);
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(in);
                        throw throwable;
                    }
                }
                IOUtils.close((Closeable)in);
                if (webFragment == null) {
                    webFragment = new WebFragment();
                }
                jarUrlWebFragmentDocumentMap.put(url, webFragment);
            }
            webFragmentEntries = MergeHelper.sortWebFragments(earContext, module, bundle, webApp, jarUrlWebFragmentDocumentMap);
        } else {
            webFragmentEntries = new WebFragmentEntry[]{};
        }
        MergeContext mergeContext = new MergeContext();
        mergeContext.setEarContext(earContext);
        mergeContext.setBundle(bundle);
        WEB_SERVLET_ANNOTATION_MERGE_HANDLER.preProcessWebXmlElement(webApp, mergeContext);
        WEB_FILTER_ANNOTATION_MERGE_HANDLER.preProcessWebXmlElement(webApp, mergeContext);
        WEB_LISTENER_ANNOTATION_MERGE_HANDLER.preProcessWebXmlElement(webApp, mergeContext);
        SERVLET_SECURITY_ANNOTATION_MERGE_HANDLER.preProcessWebXmlElement(webApp, mergeContext);
        for (WebFragmentMergeHandler webFragmentMergeHandler : WEB_FRAGMENT_MERGE_HANDLERS) {
            webFragmentMergeHandler.preProcessWebXmlElement(webApp, mergeContext);
        }
        for (WebFragmentEntry webFragmentEntry : webFragmentEntries) {
            mergeContext.setWebFragmentEntry(webFragmentEntry);
            WebFragment webFragment = webFragmentEntry.getWebFragment();
            for (WebFragmentMergeHandler webFragmentMergeHandler : WEB_FRAGMENT_MERGE_HANDLERS) {
                webFragmentMergeHandler.merge(webFragment, webApp, mergeContext);
            }
            if (webFragment.isMetadataComplete().booleanValue()) continue;
            MergeHelper.mergeAnnotations(bundle, webApp, mergeContext, webFragmentEntry.getJarURL());
        }
        mergeContext.setWebFragmentEntry(null);
        Object[] arr$ = WEB_FRAGMENT_MERGE_HANDLERS;
        int len$ = arr$.length;
        int i$ = 0;
        while (true) {
            if (i$ >= len$) {
                MergeHelper.mergeAnnotations(bundle, webApp, mergeContext, "/WEB-INF/classes");
                WEB_SERVLET_ANNOTATION_MERGE_HANDLER.postProcessWebXmlElement(webApp, mergeContext);
                WEB_FILTER_ANNOTATION_MERGE_HANDLER.postProcessWebXmlElement(webApp, mergeContext);
                WEB_LISTENER_ANNOTATION_MERGE_HANDLER.postProcessWebXmlElement(webApp, mergeContext);
                SERVLET_SECURITY_ANNOTATION_MERGE_HANDLER.postProcessWebXmlElement(webApp, mergeContext);
                mergeContext.clearup();
                return;
            }
            Object object = arr$[i$];
            object.postProcessWebXmlElement(webApp, mergeContext);
            ++i$;
        }
    }

    public static WebFragmentEntry[] relativeOrderWebFragments(EARContext earContext, Module module, Bundle bundle, WebApp webApp, Map<String, WebFragmentEntry> webFragmentEntryMap) throws DeploymentException {
        try {
            WebFragmentEntry[] webFragments = FragmentSortUtils.sort(webFragmentEntryMap.values(), (FragmentSortUtils.Visitor)new FragmentSortUtils.Visitor<WebFragmentEntry>(){

                public boolean afterOthers(WebFragmentEntry entry) {
                    OrderingOrdering after;
                    WebFragment webFragment = entry.getWebFragment();
                    if (webFragment.getOrdering() != null && (after = webFragment.getOrdering().getAfter()) != null) {
                        return after.getOthers() != null;
                    }
                    return false;
                }

                public boolean beforeOthers(WebFragmentEntry entry) {
                    OrderingOrdering before;
                    WebFragment webFragment = entry.getWebFragment();
                    if (webFragment.getOrdering() != null && (before = webFragment.getOrdering().getBefore()) != null) {
                        return before.getOthers() != null;
                    }
                    return false;
                }

                public List<String> getAfterNames(WebFragmentEntry entry) {
                    OrderingOrdering after;
                    WebFragment webFragment = entry.getWebFragment();
                    if (webFragment.getOrdering() != null && (after = webFragment.getOrdering().getAfter()) != null) {
                        return after.getName() == null ? Collections.emptyList() : after.getName();
                    }
                    return Collections.emptyList();
                }

                public List<String> getBeforeNames(WebFragmentEntry entry) {
                    OrderingOrdering before;
                    WebFragment webFragment = entry.getWebFragment();
                    if (webFragment.getOrdering() != null && (before = webFragment.getOrdering().getBefore()) != null) {
                        return before.getName() == null ? Collections.emptyList() : before.getName();
                    }
                    return Collections.emptyList();
                }

                public String getName(WebFragmentEntry entry) {
                    return entry.getName();
                }
            }).toArray(new WebFragmentEntry[webFragmentEntryMap.values().size()]);
            MergeHelper.saveOrderedLibAttribute(earContext, module, webFragments);
            return webFragments;
        }
        catch (IllegalConfigurationException e) {
            throw new DeploymentException("Jar file " + webFragmentEntryMap.get(e.getNodeName()).getJarURL() + " is not configured correctly for " + e.getMessage(), (Throwable)e);
        }
        catch (CircularReferencesException e) {
            StringBuilder circularReferenceInfo = new StringBuilder();
            int index = 1;
            JoinUtils.NameCallback<WebFragmentEntry> nameCallback = new JoinUtils.NameCallback<WebFragmentEntry>(){

                public String getName(WebFragmentEntry object) {
                    return object.getJarURL();
                }
            };
            for (List list : e.getCircuits()) {
                circularReferenceInfo.append(index++ + ". [" + JoinUtils.join((String)" -> ", (JoinUtils.NameCallback)nameCallback, (Collection)list) + "]");
            }
            throw new DeploymentException("Circular reference is dectected, " + circularReferenceInfo, (Throwable)e);
        }
    }

    public static WebFragmentEntry[] sortWebFragments(EARContext earContext, Module module, Bundle bundle, WebApp webApp, Map<String, WebFragment> jarURLDocumentMap) throws DeploymentException {
        LinkedHashMap<String, WebFragmentEntry> webFragmentEntryMap = new LinkedHashMap<String, WebFragmentEntry>(jarURLDocumentMap.size());
        boolean absoluteOrderingConfigured = webApp.getAbsoluteOrdering() != null;
        HashSet<String> usedWebFragmentNames = new HashSet<String>();
        HashMap<String, WebFragment> unnamedWebFragmentMap = new HashMap<String, WebFragment>();
        for (String jarURL : jarURLDocumentMap.keySet()) {
            WebFragment webFragment = jarURLDocumentMap.get(jarURL);
            String webFragmentName = webFragment.getName();
            if (webFragmentName != null) {
                if (webFragmentEntryMap.containsKey(webFragmentName)) {
                    if (!absoluteOrderingConfigured) {
                        throw new DeploymentException("Mutiple web-fragments with the same name [" + webFragmentName + "] are found in " + jarURL + " and " + ((WebFragmentEntry)webFragmentEntryMap.get(webFragmentName)).getJarURL() + ", you might make the name unique or use absolute ordering in web.xml");
                    }
                } else {
                    webFragmentEntryMap.put(webFragmentName, new WebFragmentEntry(webFragmentName, webFragmentName, webFragment, jarURL));
                }
                usedWebFragmentNames.add(webFragmentName);
            } else {
                unnamedWebFragmentMap.put(jarURL, webFragment);
            }
            if (webFragment.getOrdering() == null) continue;
            Ordering order = webFragment.getOrdering();
            if (order.getBefore() != null) {
                usedWebFragmentNames.addAll(order.getBefore().getName());
            }
            if (order.getAfter() == null) continue;
            usedWebFragmentNames.addAll(order.getAfter().getName());
        }
        String tempNamePrefix = "geronimo-deployment";
        int nameSubfix = 0;
        for (String webFragmentURL : unnamedWebFragmentMap.keySet()) {
            WebFragment webFragment = (WebFragment)unnamedWebFragmentMap.get(webFragmentURL);
            String tempWebFragmentName = tempNamePrefix + nameSubfix++;
            while (usedWebFragmentNames.contains(tempWebFragmentName)) {
                tempWebFragmentName = tempNamePrefix + nameSubfix++;
            }
            webFragmentEntryMap.put(tempWebFragmentName, new WebFragmentEntry(tempWebFragmentName, null, webFragment, webFragmentURL));
        }
        if (absoluteOrderingConfigured) {
            return MergeHelper.absoluteOrderWebFragments(earContext, module, bundle, webApp, webFragmentEntryMap);
        }
        return MergeHelper.relativeOrderWebFragments(earContext, module, bundle, webApp, webFragmentEntryMap);
    }

    private static void saveOrderedLibAttribute(EARContext earContext, Module module, WebFragmentEntry[] webFragmentEntries) {
        ArrayList<String> orderedLibs = new ArrayList<String>();
        for (WebFragmentEntry webFragmentEntry : webFragmentEntries) {
            int iBeginIndex;
            String jarURL = webFragmentEntry.getJarURL();
            if (jarURL == null || (iBeginIndex = jarURL.indexOf("WEB-INF/")) <= 0) continue;
            orderedLibs.add(jarURL.substring(iBeginIndex + 8));
        }
        module.getEarContext().getGeneralData().put(AbstractWebModuleBuilder.ORDERED_LIBS, orderedLibs);
    }
}

