/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import java.util.ArrayList;
import java.util.List;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.webfragment.ServletInitParamMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.ServletLoadOnStartupMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.SubMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.xbeans.javaee6.ServletType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebFragmentType;
import org.apache.xmlbeans.XmlObject;

public class ServletMergeHandler
implements WebFragmentMergeHandler<WebFragmentType, WebAppType> {
    private List<SubMergeHandler<ServletType, ServletType>> subMergeHandlers = new ArrayList<SubMergeHandler<ServletType, ServletType>>();

    public ServletMergeHandler() {
        this.subMergeHandlers.add(new ServletInitParamMergeHandler());
        this.subMergeHandlers.add(new ServletLoadOnStartupMergeHandler());
    }

    @Override
    public void merge(WebFragmentType webFragment, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (ServletType srcServlet : webFragment.getServletArray()) {
            String servletName = srcServlet.getServletName().getStringValue();
            ServletType targetServlet = (ServletType)mergeContext.getAttribute(ServletMergeHandler.createServletKey(servletName));
            if (targetServlet == null) {
                targetServlet = (ServletType)webApp.addNewServlet().set((XmlObject)srcServlet);
                mergeContext.setAttribute(ServletMergeHandler.createServletKey(servletName), targetServlet);
                for (SubMergeHandler<ServletType, ServletType> subMergeHandler : this.subMergeHandlers) {
                    subMergeHandler.add(targetServlet, mergeContext);
                }
                continue;
            }
            for (SubMergeHandler<ServletType, ServletType> subMergeHandler : this.subMergeHandlers) {
                subMergeHandler.merge(srcServlet, targetServlet, mergeContext);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (SubMergeHandler<ServletType, ServletType> subMergeHandler : this.subMergeHandlers) {
            subMergeHandler.postProcessWebXmlElement(webApp, mergeContext);
        }
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (ServletType servlet : webApp.getServletArray()) {
            mergeContext.setAttribute(ServletMergeHandler.createServletKey(servlet.getServletName().getStringValue()), servlet);
        }
        for (SubMergeHandler<ServletType, ServletType> subMergeHandler : this.subMergeHandlers) {
            subMergeHandler.preProcessWebXmlElement(webApp, mergeContext);
        }
    }

    public static String createServletKey(String servletName) {
        return "servlet.servlet-name." + servletName;
    }

    public static boolean isServletConfigured(String servletName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(ServletMergeHandler.createServletKey(servletName));
    }

    public static ServletType getServlet(String servletName, MergeContext mergeContext) {
        return (ServletType)mergeContext.getAttribute(ServletMergeHandler.createServletKey(servletName));
    }

    public static void addServlet(ServletType servlet, MergeContext mergeContext) {
        mergeContext.setAttribute(ServletMergeHandler.createServletKey(servlet.getServletName().getStringValue()), servlet);
    }
}

