/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import java.util.ArrayList;
import java.util.List;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.webfragment.ServletMappingUrlPatternMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.SubMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.xbeans.javaee6.ServletMappingType;
import org.apache.geronimo.xbeans.javaee6.UrlPatternType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebFragmentType;
import org.apache.xmlbeans.XmlObject;

public class ServletMappingMergeHandler
implements WebFragmentMergeHandler<WebFragmentType, WebAppType> {
    private List<SubMergeHandler<ServletMappingType, ServletMappingType>> subMergeHandlers = new ArrayList<SubMergeHandler<ServletMappingType, ServletMappingType>>();

    public ServletMappingMergeHandler() {
        this.subMergeHandlers.add(new ServletMappingUrlPatternMergeHandler());
    }

    @Override
    public void merge(WebFragmentType webFragment, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (ServletMappingType srcServletMapping : webFragment.getServletMappingArray()) {
            String servletName = srcServletMapping.getServletName().getStringValue();
            ServletMappingType targetServletMapping = (ServletMappingType)mergeContext.getAttribute(ServletMappingMergeHandler.createServletMappingKey(servletName));
            if (targetServletMapping == null) {
                targetServletMapping = (ServletMappingType)webApp.addNewServletMapping().set((XmlObject)srcServletMapping);
                mergeContext.setAttribute(ServletMappingMergeHandler.createServletMappingKey(servletName), targetServletMapping);
                for (SubMergeHandler<ServletMappingType, ServletMappingType> subMergeHandler : this.subMergeHandlers) {
                    subMergeHandler.add(targetServletMapping, mergeContext);
                }
                continue;
            }
            if (ServletMappingMergeHandler.isServletMappingFromAnnotation(servletName, mergeContext) && srcServletMapping.getUrlPatternArray().length > 0) {
                targetServletMapping.setUrlPatternArray(new UrlPatternType[0]);
                mergeContext.removeAttribute(ServletMappingMergeHandler.createServletMappingSourceKey(servletName));
            }
            for (SubMergeHandler<ServletMappingType, ServletMappingType> subMergeHandler : this.subMergeHandlers) {
                subMergeHandler.merge(srcServletMapping, targetServletMapping, mergeContext);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
        for (SubMergeHandler<ServletMappingType, ServletMappingType> subMergeHandler : this.subMergeHandlers) {
            subMergeHandler.postProcessWebXmlElement(webApp, context);
        }
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
        for (ServletMappingType servletMapping : webApp.getServletMappingArray()) {
            String filterName = servletMapping.getServletName().getStringValue();
            context.setAttribute(ServletMappingMergeHandler.createServletMappingKey(filterName), servletMapping);
        }
        for (SubMergeHandler<ServletMappingType, ServletMappingType> subMergeHandler : this.subMergeHandlers) {
            subMergeHandler.preProcessWebXmlElement(webApp, context);
        }
    }

    public static String createServletMappingKey(String servletName) {
        return "servlet-mapping.servlet-name" + servletName;
    }

    public static String createServletMappingSourceKey(String servletName) {
        return "servlet-mapping.servlet-name." + servletName + ".sources";
    }

    public static void addServletMapping(ServletMappingType servletMapping, MergeContext mergeContext) {
        mergeContext.setAttribute(ServletMappingMergeHandler.createServletMappingKey(servletMapping.getServletName().getStringValue()), servletMapping);
    }

    public static boolean isServletMappingConfigured(String servletName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(ServletMappingMergeHandler.createServletMappingKey(servletName));
    }

    public static boolean isServletMappingFromAnnotation(String servletName, MergeContext mergeContext) {
        ElementSource elementSource = (ElementSource)((Object)mergeContext.getAttribute(ServletMappingMergeHandler.createServletMappingSourceKey(servletName)));
        return elementSource != null && elementSource.equals((Object)ElementSource.ANNOTATION);
    }
}

