/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import java.math.BigInteger;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.SubMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.xbeans.javaee6.ServletType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;

public class ServletLoadOnStartupMergeHandler
implements SubMergeHandler<ServletType, ServletType> {
    @Override
    public void add(ServletType servlet, MergeContext mergeContext) throws DeploymentException {
        if (servlet.getLoadOnStartup() != null) {
            mergeContext.setAttribute(ServletLoadOnStartupMergeHandler.createServletLoadOnStartupKey(servlet.getServletName().getStringValue()), new MergeItem(servlet.getLoadOnStartup(), mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
        }
    }

    @Override
    public void merge(ServletType srcServlet, ServletType targetServlet, MergeContext mergeContext) throws DeploymentException {
        String servletName = srcServlet.getServletName().getStringValue();
        if (ServletLoadOnStartupMergeHandler.isServletLoadOnStartupConfiguredInWebXML(servletName, mergeContext)) {
            return;
        }
        if (srcServlet.getLoadOnStartup() != null) {
            BigInteger srcLoadOnStartupValue = (BigInteger)srcServlet.getLoadOnStartup();
            MergeItem existedLoadOnStartup = (MergeItem)mergeContext.getAttribute(ServletLoadOnStartupMergeHandler.createServletLoadOnStartupKey(servletName));
            if (existedLoadOnStartup == null) {
                targetServlet.setLoadOnStartup((Object)srcLoadOnStartupValue);
                mergeContext.setAttribute(ServletLoadOnStartupMergeHandler.createServletLoadOnStartupKey(servletName), new MergeItem(srcLoadOnStartupValue, mergeContext.getCurrentJarUrl(), ElementSource.WEB_XML));
            } else if (!existedLoadOnStartup.getValue().equals(srcLoadOnStartupValue)) {
                throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateValueMessage("servlet " + servletName, "load-on-startup", existedLoadOnStartup.getValue().toString(), existedLoadOnStartup.getBelongedURL(), srcLoadOnStartupValue.toString(), mergeContext.getCurrentJarUrl()));
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
        for (ServletType servlet : webApp.getServletArray()) {
            if (servlet.getLoadOnStartup() == null) continue;
            context.setAttribute(ServletLoadOnStartupMergeHandler.createServletLoadOnStartupConfiguredInWebXMLKey(servlet.getServletName().getStringValue()), Boolean.TRUE);
        }
    }

    public static String createServletLoadOnStartupConfiguredInWebXMLKey(String servletName) {
        return "servlet.servlet-name." + servletName + ".load-on-startup.configured_in_web_xml";
    }

    public static String createServletLoadOnStartupKey(String servletName) {
        return "servlet.servlet-name." + servletName + ".load-on-startup";
    }

    public static boolean isServletLoadOnStartupConfiguredInWebXML(String servletName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(ServletLoadOnStartupMergeHandler.createServletLoadOnStartupConfiguredInWebXMLKey(servletName));
    }
}

