/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.xbeans.javaee6.SecurityRoleType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebFragmentType;
import org.apache.xmlbeans.XmlObject;

public class SecurityRoleMergeHandler
implements WebFragmentMergeHandler<WebFragmentType, WebAppType> {
    @Override
    public void merge(WebFragmentType webFragment, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (SecurityRoleType securityRole : webFragment.getSecurityRoleArray()) {
            String securityRoleKey = SecurityRoleMergeHandler.createSecurityRoleKey(securityRole.getRoleName().getStringValue());
            if (mergeContext.containsAttribute(securityRoleKey)) continue;
            mergeContext.setAttribute(securityRoleKey, Boolean.TRUE);
            webApp.addNewSecurityRole().set((XmlObject)securityRole);
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
        for (SecurityRoleType securityRole : webApp.getSecurityRoleArray()) {
            context.setAttribute(SecurityRoleMergeHandler.createSecurityRoleKey(securityRole.getRoleName().getStringValue()), Boolean.TRUE);
        }
    }

    public static String createSecurityRoleKey(String roleName) {
        return "security-role.role-name." + roleName;
    }
}

