/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.xbeans.javaee6.InjectionTargetType;
import org.apache.geronimo.xbeans.javaee6.PersistenceUnitRefType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebFragmentType;
import org.apache.xmlbeans.XmlObject;

public class PersistenceUnitRefMergeHandler
implements WebFragmentMergeHandler<WebFragmentType, WebAppType> {
    public static final String PERSISTENCE_UNIT_REF_NAME_PREFIX = "persistence-unit-ref.persistence-unit-ref-name.";

    @Override
    public void merge(WebFragmentType webFragment, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (PersistenceUnitRefType srcPersistenceUnitRef : webFragment.getPersistenceUnitRefArray()) {
            String persistenceUnitRefName = srcPersistenceUnitRef.getPersistenceUnitRefName().getStringValue();
            String persistenceUnitRefKey = PersistenceUnitRefMergeHandler.createPersistenceUnitRefKey(persistenceUnitRefName);
            MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(persistenceUnitRefKey);
            if (mergeItem != null) {
                if (mergeItem.isFromWebFragment()) {
                    throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateJNDIRefMessage("persistence-unit-ref", persistenceUnitRefName, mergeItem.getBelongedURL(), mergeContext.getCurrentJarUrl()));
                }
                if (!mergeItem.isFromWebXml() || PersistenceUnitRefMergeHandler.isPersistenceUnitRefInjectTargetsConfiguredInInitialWebXML(persistenceUnitRefName, mergeContext)) continue;
                PersistenceUnitRefType persistenceUnitRef = (PersistenceUnitRefType)mergeItem.getValue();
                for (InjectionTargetType injectTarget : srcPersistenceUnitRef.getInjectionTargetArray()) {
                    String persistenceUnitRefInjectTargetKey = PersistenceUnitRefMergeHandler.createPersistenceUnitRefInjectTargetKey(persistenceUnitRefName, injectTarget.getInjectionTargetClass().getStringValue(), injectTarget.getInjectionTargetName().getStringValue());
                    if (mergeContext.containsAttribute(persistenceUnitRefInjectTargetKey)) continue;
                    persistenceUnitRef.addNewInjectionTarget().set((XmlObject)injectTarget);
                    mergeContext.setAttribute(persistenceUnitRefInjectTargetKey, Boolean.TRUE);
                }
                continue;
            }
            PersistenceUnitRefType targetPersistenceUnitRef = (PersistenceUnitRefType)webApp.addNewPersistenceUnitRef().set((XmlObject)srcPersistenceUnitRef);
            mergeContext.setAttribute(persistenceUnitRefKey, new MergeItem(targetPersistenceUnitRef, mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
            for (InjectionTargetType injectionTarget : targetPersistenceUnitRef.getInjectionTargetArray()) {
                mergeContext.setAttribute(PersistenceUnitRefMergeHandler.createPersistenceUnitRefInjectTargetKey(persistenceUnitRefName, injectionTarget.getInjectionTargetClass().getStringValue(), injectionTarget.getInjectionTargetName().getStringValue()), Boolean.TRUE);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (PersistenceUnitRefType persistenceUnitRef : webApp.getPersistenceUnitRefArray()) {
            String persistenceUnitRefName = persistenceUnitRef.getPersistenceUnitRefName().getStringValue();
            mergeContext.setAttribute(PersistenceUnitRefMergeHandler.createPersistenceUnitRefKey(persistenceUnitRefName), new MergeItem(persistenceUnitRef, null, ElementSource.WEB_XML));
            if (persistenceUnitRef.getInjectionTargetArray().length > 0) {
                mergeContext.setAttribute(PersistenceUnitRefMergeHandler.createPersistenceUnitRefInjectTargetConfiguredInWebXMLKey(persistenceUnitRefName), Boolean.TRUE);
            }
            for (InjectionTargetType injectionTarget : persistenceUnitRef.getInjectionTargetArray()) {
                mergeContext.setAttribute(PersistenceUnitRefMergeHandler.createPersistenceUnitRefInjectTargetKey(persistenceUnitRefName, injectionTarget.getInjectionTargetClass().getStringValue(), injectionTarget.getInjectionTargetName().getStringValue()), Boolean.TRUE);
            }
        }
    }

    public static String createPersistenceUnitRefInjectTargetConfiguredInWebXMLKey(String persistenceUnitRefName) {
        return PERSISTENCE_UNIT_REF_NAME_PREFIX + persistenceUnitRefName + ".inject_target_configured_in_web_xml";
    }

    public static String createPersistenceUnitRefInjectTargetKey(String persistenceUnitRefName, String injectTargetClassName, String injectTargetName) {
        return PERSISTENCE_UNIT_REF_NAME_PREFIX + persistenceUnitRefName + "." + injectTargetClassName + "." + injectTargetName;
    }

    public static String createPersistenceUnitRefKey(String persistenceUnitRefName) {
        return PERSISTENCE_UNIT_REF_NAME_PREFIX + persistenceUnitRefName;
    }

    public static boolean isPersistenceUnitRefInjectTargetConfigured(String persistenceUnitRefName, String injectTargetClassName, String injectTargetName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(PersistenceUnitRefMergeHandler.createPersistenceUnitRefInjectTargetKey(persistenceUnitRefName, injectTargetClassName, injectTargetName));
    }

    public static boolean isPersistenceUnitRefInjectTargetsConfiguredInInitialWebXML(String persistenceUnitRefName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(PersistenceUnitRefMergeHandler.createPersistenceUnitRefInjectTargetConfiguredInWebXMLKey(persistenceUnitRefName));
    }
}

