/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.xbeans.javaee6.InjectionTargetType;
import org.apache.geronimo.xbeans.javaee6.PersistenceContextRefType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebFragmentType;
import org.apache.xmlbeans.XmlObject;

public class PersistenceContextRefMergeHandler
implements WebFragmentMergeHandler<WebFragmentType, WebAppType> {
    public static final String PERSISTENCE_CONTEXT_REF_NAME_PREFIX = "persistence-context-ref.persistence-context-ref-name.";

    @Override
    public void merge(WebFragmentType webFragment, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (PersistenceContextRefType srcPersistenceContextRef : webFragment.getPersistenceContextRefArray()) {
            String persistenceContextRefName = srcPersistenceContextRef.getPersistenceContextRefName().getStringValue();
            String persistenceContextRefKey = PersistenceContextRefMergeHandler.createPersistenceContextRefKey(persistenceContextRefName);
            MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(persistenceContextRefKey);
            if (mergeItem != null) {
                if (mergeItem.isFromWebFragment()) {
                    throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateJNDIRefMessage("persistence-context-ref", persistenceContextRefName, mergeItem.getBelongedURL(), mergeContext.getCurrentJarUrl()));
                }
                if (!mergeItem.isFromWebXml() || PersistenceContextRefMergeHandler.isPersistenceContextRefInjectTargetsConfiguredInInitialWebXML(persistenceContextRefName, mergeContext)) continue;
                PersistenceContextRefType persistenceContextRef = (PersistenceContextRefType)mergeItem.getValue();
                for (InjectionTargetType injectTarget : srcPersistenceContextRef.getInjectionTargetArray()) {
                    String persistenceContextRefInjectTargetKey = PersistenceContextRefMergeHandler.createPersistenceContextRefInjectTargetKey(persistenceContextRefName, injectTarget.getInjectionTargetClass().getStringValue(), injectTarget.getInjectionTargetName().getStringValue());
                    if (mergeContext.containsAttribute(persistenceContextRefInjectTargetKey)) continue;
                    persistenceContextRef.addNewInjectionTarget().set((XmlObject)injectTarget);
                    mergeContext.setAttribute(persistenceContextRefInjectTargetKey, Boolean.TRUE);
                }
                continue;
            }
            PersistenceContextRefType targetPersistenceContextRef = (PersistenceContextRefType)webApp.addNewPersistenceContextRef().set((XmlObject)srcPersistenceContextRef);
            mergeContext.setAttribute(persistenceContextRefKey, new MergeItem(targetPersistenceContextRef, mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
            for (InjectionTargetType injectionTarget : targetPersistenceContextRef.getInjectionTargetArray()) {
                mergeContext.setAttribute(PersistenceContextRefMergeHandler.createPersistenceContextRefInjectTargetKey(persistenceContextRefName, injectionTarget.getInjectionTargetClass().getStringValue(), injectionTarget.getInjectionTargetName().getStringValue()), Boolean.TRUE);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (PersistenceContextRefType persistenceContextRef : webApp.getPersistenceContextRefArray()) {
            String persistenceContextRefName = persistenceContextRef.getPersistenceContextRefName().getStringValue();
            mergeContext.setAttribute(PersistenceContextRefMergeHandler.createPersistenceContextRefKey(persistenceContextRefName), new MergeItem(persistenceContextRef, null, ElementSource.WEB_XML));
            if (persistenceContextRef.getInjectionTargetArray().length > 0) {
                mergeContext.setAttribute(PersistenceContextRefMergeHandler.createPersistenceContextRefInjectTargetConfiguredInWebXMLKey(persistenceContextRefName), Boolean.TRUE);
            }
            for (InjectionTargetType injectionTarget : persistenceContextRef.getInjectionTargetArray()) {
                mergeContext.setAttribute(PersistenceContextRefMergeHandler.createPersistenceContextRefInjectTargetKey(persistenceContextRefName, injectionTarget.getInjectionTargetClass().getStringValue(), injectionTarget.getInjectionTargetName().getStringValue()), Boolean.TRUE);
            }
        }
    }

    public static String createPersistenceContextRefInjectTargetConfiguredInWebXMLKey(String persistenceContextRefName) {
        return PERSISTENCE_CONTEXT_REF_NAME_PREFIX + persistenceContextRefName + ".inject_target_configured_in_web_xml";
    }

    public static String createPersistenceContextRefInjectTargetKey(String persistenceContextRefName, String injectTargetClassName, String injectTargetName) {
        return PERSISTENCE_CONTEXT_REF_NAME_PREFIX + persistenceContextRefName + "." + injectTargetClassName + "." + injectTargetName;
    }

    public static String createPersistenceContextRefKey(String persistenceContextRefName) {
        return PERSISTENCE_CONTEXT_REF_NAME_PREFIX + persistenceContextRefName;
    }

    public static boolean isPersistenceContextRefInjectTargetConfigured(String persistenceContextRefName, String injectTargetClassName, String injectTargetName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(PersistenceContextRefMergeHandler.createPersistenceContextRefInjectTargetKey(persistenceContextRefName, injectTargetClassName, injectTargetName));
    }

    public static boolean isPersistenceContextRefInjectTargetsConfiguredInInitialWebXML(String persistenceContextRefName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(PersistenceContextRefMergeHandler.createPersistenceContextRefInjectTargetConfiguredInWebXMLKey(persistenceContextRefName));
    }
}

