/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.xbeans.javaee6.MessageDestinationType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebFragmentType;
import org.apache.xmlbeans.XmlObject;

public class MessageDestinationMergeHandler
implements WebFragmentMergeHandler<WebFragmentType, WebAppType> {
    @Override
    public void merge(WebFragmentType webFragment, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (MessageDestinationType messageDestination : webApp.getMessageDestinationArray()) {
            String messageDestinationName = messageDestination.getMessageDestinationName().getStringValue();
            if (mergeContext.containsAttribute(MessageDestinationMergeHandler.createMessageDestinationConfiguredInWebXMLKey(messageDestination.getMessageDestinationName().getStringValue()))) continue;
            if (mergeContext.containsAttribute(MessageDestinationMergeHandler.createMessageDestinationConfiguredInWebFragmentXMLKey(messageDestinationName))) {
                MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(MessageDestinationMergeHandler.createMessageDestinationConfiguredInWebFragmentXMLKey(messageDestinationName));
                throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateJNDIRefMessage("message-destination", messageDestinationName, mergeItem.getBelongedURL(), mergeContext.getCurrentJarUrl()));
            }
            MessageDestinationType newMessageDestination = (MessageDestinationType)webApp.addNewMessageDestination().set((XmlObject)messageDestination);
            mergeContext.setAttribute(MessageDestinationMergeHandler.createMessageDestinationConfiguredInWebFragmentXMLKey(messageDestinationName), new MergeItem(newMessageDestination, mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
        for (MessageDestinationType messageDestination : webApp.getMessageDestinationArray()) {
            context.setAttribute(MessageDestinationMergeHandler.createMessageDestinationConfiguredInWebXMLKey(messageDestination.getMessageDestinationName().getStringValue()), Boolean.TRUE);
        }
    }

    public static String createMessageDestinationConfiguredInWebFragmentXMLKey(String messageDestinationName) {
        return "message-destination.message-destination-name." + messageDestinationName + ".configured_in_web_fragment_xml";
    }

    public static String createMessageDestinationConfiguredInWebXMLKey(String messageDestinationName) {
        return "message-destination.message-destination-name." + messageDestinationName + ".configured_in_web_xml";
    }
}

