/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.xbeans.javaee6.LocaleEncodingMappingListType;
import org.apache.geronimo.xbeans.javaee6.LocaleEncodingMappingType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebFragmentType;
import org.apache.xmlbeans.XmlObject;

public class LocaleEncodingMappingListMergeHandler
implements WebFragmentMergeHandler<WebFragmentType, WebAppType> {
    @Override
    public void merge(WebFragmentType webFragment, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        LocaleEncodingMappingListType targetLocaleEncodingMappingList = null;
        for (LocaleEncodingMappingListType localeEncodingMappingList : webFragment.getLocaleEncodingMappingListArray()) {
            for (LocaleEncodingMappingType localeEncodingMapping : localeEncodingMappingList.getLocaleEncodingMappingArray()) {
                String localeEncodingMappingKey = LocaleEncodingMappingListMergeHandler.createLocaleEncodingMappingKey(localeEncodingMapping.getLocale());
                MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(localeEncodingMappingKey);
                if (mergeItem != null && mergeItem.isFromWebFragment() && !mergeItem.getValue().equals(localeEncodingMapping.getEncoding())) {
                    throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateKeyValueMessage("locale-encoding-mapping", "locale", localeEncodingMapping.getLocale(), "encoding", (String)mergeItem.getValue(), mergeItem.getBelongedURL(), localeEncodingMapping.getLocale(), mergeContext.getCurrentJarUrl()));
                }
                if (targetLocaleEncodingMappingList == null) {
                    targetLocaleEncodingMappingList = webApp.getLocaleEncodingMappingListArray().length > 0 ? webApp.getLocaleEncodingMappingListArray(0) : webApp.addNewLocaleEncodingMappingList();
                }
                targetLocaleEncodingMappingList.addNewLocaleEncodingMapping().set((XmlObject)localeEncodingMapping);
                mergeContext.setAttribute(localeEncodingMappingKey, new MergeItem(localeEncodingMapping.getEncoding(), mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
        LocaleEncodingMappingListType[] localeEncodingMappingLists = webApp.getLocaleEncodingMappingListArray();
        if (localeEncodingMappingLists.length == 0) {
            return;
        }
        if (localeEncodingMappingLists.length > 1) {
            int i;
            LocaleEncodingMappingListType targetLocaleEncodingMappingList = localeEncodingMappingLists[0];
            for (i = 1; i < localeEncodingMappingLists.length; ++i) {
                LocaleEncodingMappingListType localeEncodingMappingList = localeEncodingMappingLists[i];
                for (LocaleEncodingMappingType localeEncodingMapping : localeEncodingMappingList.getLocaleEncodingMappingArray()) {
                    targetLocaleEncodingMappingList.addNewLocaleEncodingMapping().set((XmlObject)localeEncodingMapping);
                }
            }
            int iLength = localeEncodingMappingLists.length;
            for (i = 1; i < iLength; ++i) {
                webApp.removeLocaleEncodingMappingList(1);
            }
        }
        for (LocaleEncodingMappingType localeEncodingMapping : webApp.getLocaleEncodingMappingListArray(0).getLocaleEncodingMappingArray()) {
            context.setAttribute(LocaleEncodingMappingListMergeHandler.createLocaleEncodingMappingKey(localeEncodingMapping.getLocale()), new MergeItem(localeEncodingMapping.getEncoding(), null, ElementSource.WEB_XML));
        }
    }

    public static String createLocaleEncodingMappingKey(String locale) {
        return "locale-encoding-mapping-list.locale-encoding-mapping.locale." + locale;
    }
}

