/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.xbeans.javaee6.ListenerType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebFragmentType;

public class ListenerMergeHandler
implements WebFragmentMergeHandler<WebFragmentType, WebAppType> {
    @Override
    public void merge(WebFragmentType webFragment, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (ListenerType listener : webFragment.getListenerArray()) {
            String listenerClassName = listener.getListenerClass().getStringValue();
            if (mergeContext.containsAttribute(ListenerMergeHandler.createListenerKey(listenerClassName))) continue;
            ListenerType targetListener = webApp.addNewListener();
            targetListener.addNewListenerClass().setStringValue(listenerClassName);
            mergeContext.setAttribute(ListenerMergeHandler.createListenerKey(listener.getListenerClass().getStringValue()), listener);
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
        for (ListenerType listener : webApp.getListenerArray()) {
            context.setAttribute(ListenerMergeHandler.createListenerKey(listener.getListenerClass().getStringValue()), listener);
        }
    }

    public static String createListenerKey(String listenerClassName) {
        return "listener.listener-class." + listenerClassName;
    }

    public static boolean isListenerConfigured(String listenerClassName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(ListenerMergeHandler.createListenerKey(listenerClassName));
    }

    public static void addListener(ListenerType listener, MergeContext mergeContext) {
        mergeContext.setAttribute(ListenerMergeHandler.createListenerKey(listener.getListenerClass().getStringValue()), listener);
    }
}

