/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge.webfragment;

import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.xbeans.javaee6.EnvEntryType;
import org.apache.geronimo.xbeans.javaee6.InjectionTargetType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebFragmentType;
import org.apache.xmlbeans.XmlObject;

public class EnvEntryMergeHandler
implements WebFragmentMergeHandler<WebFragmentType, WebAppType> {
    public static final String ENV_ENTRY_NAME_PREFIX = "env-entry.env-entry-name.";

    @Override
    public void merge(WebFragmentType webFragment, WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (EnvEntryType srcEnvEntry : webFragment.getEnvEntryArray()) {
            String envEntryName = srcEnvEntry.getEnvEntryName().getStringValue();
            String envEntryKey = EnvEntryMergeHandler.createEnvEntryKey(envEntryName);
            MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(envEntryKey);
            if (mergeItem != null) {
                if (mergeItem.isFromWebFragment()) {
                    throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateJNDIRefMessage("env-entry", envEntryName, mergeItem.getBelongedURL(), mergeContext.getCurrentJarUrl()));
                }
                if (!mergeItem.isFromWebXml() || EnvEntryMergeHandler.isEnvEntryInjectTargetsConfiguredInInitialWebXML(envEntryName, mergeContext)) continue;
                EnvEntryType envEntry = (EnvEntryType)mergeItem.getValue();
                for (InjectionTargetType injectTarget : srcEnvEntry.getInjectionTargetArray()) {
                    String envEntryInjectTargetKey = EnvEntryMergeHandler.createEnvEntryInjectTargetKey(envEntryName, injectTarget.getInjectionTargetClass().getStringValue(), injectTarget.getInjectionTargetName().getStringValue());
                    if (mergeContext.containsAttribute(envEntryInjectTargetKey)) continue;
                    envEntry.addNewInjectionTarget().set((XmlObject)injectTarget);
                    mergeContext.setAttribute(envEntryInjectTargetKey, Boolean.TRUE);
                }
                continue;
            }
            EnvEntryType targetEnvEntry = (EnvEntryType)webApp.addNewEnvEntry().set((XmlObject)srcEnvEntry);
            mergeContext.setAttribute(envEntryKey, new MergeItem(targetEnvEntry, mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
            for (InjectionTargetType injectionTarget : targetEnvEntry.getInjectionTargetArray()) {
                mergeContext.setAttribute(EnvEntryMergeHandler.createEnvEntryInjectTargetKey(envEntryName, injectionTarget.getInjectionTargetClass().getStringValue(), injectionTarget.getInjectionTargetName().getStringValue()), Boolean.TRUE);
            }
        }
    }

    @Override
    public void postProcessWebXmlElement(WebAppType webApp, MergeContext context) throws DeploymentException {
    }

    @Override
    public void preProcessWebXmlElement(WebAppType webApp, MergeContext mergeContext) throws DeploymentException {
        for (EnvEntryType envEntry : webApp.getEnvEntryArray()) {
            String envEntryName = envEntry.getEnvEntryName().getStringValue();
            mergeContext.setAttribute(EnvEntryMergeHandler.createEnvEntryKey(envEntryName), new MergeItem(envEntry, null, ElementSource.WEB_XML));
            if (envEntry.getInjectionTargetArray().length > 0) {
                mergeContext.setAttribute(EnvEntryMergeHandler.createEnvEntryInjectTargetConfiguredInWebXMLKey(envEntryName), Boolean.TRUE);
            }
            for (InjectionTargetType injectionTarget : envEntry.getInjectionTargetArray()) {
                mergeContext.setAttribute(EnvEntryMergeHandler.createEnvEntryInjectTargetKey(envEntryName, injectionTarget.getInjectionTargetClass().getStringValue(), injectionTarget.getInjectionTargetName().getStringValue()), Boolean.TRUE);
            }
        }
    }

    public static String createEnvEntryInjectTargetConfiguredInWebXMLKey(String envEntryName) {
        return ENV_ENTRY_NAME_PREFIX + envEntryName + ".inject_target_configured_in_web_xml";
    }

    public static String createEnvEntryInjectTargetKey(String envEntryName, String injectTargetClassName, String injectTargetName) {
        return ENV_ENTRY_NAME_PREFIX + envEntryName + "." + injectTargetClassName + "." + injectTargetName;
    }

    public static String createEnvEntryKey(String envEntryName) {
        return ENV_ENTRY_NAME_PREFIX + envEntryName;
    }

    public static boolean isEnvEntryInjectTargetConfigured(String envEntryName, String injectTargetClassName, String injectTargetName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(EnvEntryMergeHandler.createEnvEntryInjectTargetKey(envEntryName, injectTargetClassName, injectTargetName));
    }

    public static boolean isEnvEntryInjectTargetsConfiguredInInitialWebXML(String envEntryName, MergeContext mergeContext) {
        return mergeContext.containsAttribute(EnvEntryMergeHandler.createEnvEntryInjectTargetConfiguredInWebXMLKey(envEntryName));
    }
}

