/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.web25.deployment.merge;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.annotation.HandlesTypes;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.geronimo.web25.deployment.AbstractWebModuleBuilder;
import org.apache.geronimo.web25.deployment.merge.ElementSource;
import org.apache.geronimo.web25.deployment.merge.MergeContext;
import org.apache.geronimo.web25.deployment.merge.MergeItem;
import org.apache.geronimo.web25.deployment.merge.annotation.AnnotationMergeHandler;
import org.apache.geronimo.web25.deployment.merge.annotation.ServletSecurityAnnotationMergeHandler;
import org.apache.geronimo.web25.deployment.merge.annotation.WebFilterAnnotationMergeHandler;
import org.apache.geronimo.web25.deployment.merge.annotation.WebListenerAnnotationMergeHandler;
import org.apache.geronimo.web25.deployment.merge.annotation.WebServletAnnotationMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.DataSourceMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.EjbLocalRefMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.EjbRefMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.EnvEntryMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.ErrorPageMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.FilterMappingMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.FilterMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.JspConfigMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.ListenerMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.LocaleEncodingMappingListMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.LoginConfigMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.MessageDestinationMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.MessageDestinationRefMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.MimeMappingMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.PersistenceContextRefMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.PersistenceUnitRefMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.PostConstructMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.PreDestroyMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.ResourceEnvRefMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.ResourceRefMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.SecurityConstraintMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.SecurityRoleMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.ServiceRefMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.ServletMappingMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.ServletMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.SessionConfigMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentEntry;
import org.apache.geronimo.web25.deployment.merge.webfragment.WebFragmentMergeHandler;
import org.apache.geronimo.web25.deployment.merge.webfragment.WelcomeFileListMergeHandler;
import org.apache.geronimo.web25.deployment.utils.WebDeploymentMessageUtils;
import org.apache.geronimo.xbeans.javaee6.AbsoluteOrderingType;
import org.apache.geronimo.xbeans.javaee6.JavaIdentifierType;
import org.apache.geronimo.xbeans.javaee6.OrderingOrderingType;
import org.apache.geronimo.xbeans.javaee6.OrderingType;
import org.apache.geronimo.xbeans.javaee6.WebAppType;
import org.apache.geronimo.xbeans.javaee6.WebFragmentDocument;
import org.apache.geronimo.xbeans.javaee6.WebFragmentType;
import org.apache.xbean.finder.BundleAnnotationFinder;
import org.apache.xbean.finder.BundleAssignableClassFinder;
import org.apache.xbean.osgi.bundle.util.BundleResourceFinder;
import org.apache.xbean.osgi.bundle.util.ClassDiscoveryFilter;
import org.apache.xbean.osgi.bundle.util.DiscoveryRange;
import org.apache.xbean.osgi.bundle.util.ResourceDiscoveryFilter;
import org.apache.xmlbeans.XmlException;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MergeHelper {
    private static final Logger logger = LoggerFactory.getLogger(MergeHelper.class);
    private static final AnnotationMergeHandler WEB_FILTER_ANNOTATION_MERGE_HANDLER = new WebFilterAnnotationMergeHandler();
    private static final WebFragmentMergeHandler[] WEB_FRAGMENT_MERGE_HANDLERS = new WebFragmentMergeHandler[]{new FilterMergeHandler(), new FilterMappingMergeHandler(), new ListenerMergeHandler(), new ServletMergeHandler(), new ServletMappingMergeHandler(), new SessionConfigMergeHandler(), new MimeMappingMergeHandler(), new WelcomeFileListMergeHandler(), new ErrorPageMergeHandler(), new JspConfigMergeHandler(), new SecurityConstraintMergeHandler(), new LoginConfigMergeHandler(), new SecurityRoleMergeHandler(), new EnvEntryMergeHandler(), new EjbRefMergeHandler(), new EjbLocalRefMergeHandler(), new ResourceRefMergeHandler(), new ResourceEnvRefMergeHandler(), new MessageDestinationRefMergeHandler(), new PersistenceContextRefMergeHandler(), new PersistenceUnitRefMergeHandler(), new PostConstructMergeHandler(), new PreDestroyMergeHandler(), new DataSourceMergeHandler(), new ServiceRefMergeHandler(), new MessageDestinationMergeHandler(), new LocaleEncodingMappingListMergeHandler()};
    private static final AnnotationMergeHandler WEB_LISTENER_ANNOTATION_MERGE_HANDLER = new WebListenerAnnotationMergeHandler();
    private static final AnnotationMergeHandler WEB_SERVLET_ANNOTATION_MERGE_HANDLER = new WebServletAnnotationMergeHandler();
    private static final AnnotationMergeHandler SERVLET_SECURITY_ANNOTATION_MERGE_HANDLER = new ServletSecurityAnnotationMergeHandler();

    public static WebFragmentEntry[] absoluteOrderWebFragments(EARContext earContext, Module module, Bundle bundle, WebAppType webApp, Map<String, WebFragmentEntry> webFragmentEntryMap) throws DeploymentException {
        boolean othersConfigured;
        AbsoluteOrderingType absoluteOrdering = webApp.getAbsoluteOrderingArray()[0];
        LinkedHashSet<String> expliciteConfiguredWebFragmentNames = new LinkedHashSet<String>();
        LinkedList<WebFragmentEntry> orderedWebFragments = new LinkedList<WebFragmentEntry>();
        boolean bl = othersConfigured = absoluteOrdering.getOthersArray().length != 0;
        if (othersConfigured) {
            NodeList absoluteOrderingChildren = absoluteOrdering.getDomNode().getChildNodes();
            int iOthersIndex = -1;
            for (int i = 0; i < absoluteOrderingChildren.getLength(); ++i) {
                Node node = absoluteOrderingChildren.item(i);
                if (node.getNodeType() != 1) continue;
                if (node.getNodeName().equals("name")) {
                    String webFragmentName = node.getChildNodes().item(0).getNodeValue();
                    if (!webFragmentEntryMap.containsKey(webFragmentName) || expliciteConfiguredWebFragmentNames.contains(webFragmentName)) continue;
                    expliciteConfiguredWebFragmentNames.add(webFragmentName);
                    orderedWebFragments.add(webFragmentEntryMap.get(webFragmentName));
                    continue;
                }
                if (!node.getNodeName().equals("others")) continue;
                iOthersIndex = expliciteConfiguredWebFragmentNames.size();
            }
            for (String webFragmentName : webFragmentEntryMap.keySet()) {
                if (expliciteConfiguredWebFragmentNames.contains(webFragmentName)) continue;
                orderedWebFragments.add(iOthersIndex++, webFragmentEntryMap.get(webFragmentName));
            }
        } else {
            for (JavaIdentifierType javaIdentifier : absoluteOrdering.getNameArray()) {
                String webFragmentName = javaIdentifier.getStringValue();
                if (!webFragmentEntryMap.containsKey(webFragmentName) || expliciteConfiguredWebFragmentNames.contains(webFragmentName)) continue;
                expliciteConfiguredWebFragmentNames.add(webFragmentName);
                orderedWebFragments.add(webFragmentEntryMap.get(webFragmentName));
            }
            Set excludedURLs = (Set)AbstractWebModuleBuilder.EXCLUDED_JAR_URLS.get(earContext.getGeneralData());
            for (String foundedWebFragementName : webFragmentEntryMap.keySet()) {
                if (expliciteConfiguredWebFragmentNames.contains(foundedWebFragementName)) continue;
                excludedURLs.add(webFragmentEntryMap.get(foundedWebFragementName).getJarURL());
            }
        }
        WebFragmentEntry[] webFragmentEntries = orderedWebFragments.toArray(new WebFragmentEntry[0]);
        MergeHelper.saveOrderedLibAttribute(earContext, webFragmentEntries);
        return webFragmentEntries;
    }

    public static void mergeAnnotations(Bundle bundle, WebAppType webApp, MergeContext mergeContext, final String prefix) throws DeploymentException {
        final boolean isJarFile = prefix.endsWith(".jar");
        try {
            BundleAnnotationFinder bundleAnnotationFinder = new BundleAnnotationFinder(null, bundle, new ResourceDiscoveryFilter(){

                public boolean directoryDiscoveryRequired(String url) {
                    return !isJarFile;
                }

                public boolean rangeDiscoveryRequired(DiscoveryRange discoveryRange) {
                    return discoveryRange.equals((Object)DiscoveryRange.BUNDLE_CLASSPATH);
                }

                public boolean zipFileDiscoveryRequired(String url) {
                    return isJarFile ? url.equals(prefix) : false;
                }
            });
            List webServlets = bundleAnnotationFinder.findAnnotatedClasses(WebServlet.class);
            WEB_SERVLET_ANNOTATION_MERGE_HANDLER.merge(webServlets.toArray(new Class[0]), webApp, mergeContext);
            List webFilters = bundleAnnotationFinder.findAnnotatedClasses(WebFilter.class);
            WEB_FILTER_ANNOTATION_MERGE_HANDLER.merge(webFilters.toArray(new Class[0]), webApp, mergeContext);
            List webListeners = bundleAnnotationFinder.findAnnotatedClasses(WebListener.class);
            WEB_LISTENER_ANNOTATION_MERGE_HANDLER.merge(webListeners.toArray(new Class[0]), webApp, mergeContext);
        }
        catch (Exception e) {
            throw new DeploymentException("Fail to merge annotations in " + prefix, (Throwable)e);
        }
    }

    public static boolean mergeRequired(String attributeName, String parentElementName, String elementName, String value, MergeContext mergeContext) throws DeploymentException {
        MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(attributeName);
        if (mergeItem == null) {
            mergeContext.setAttribute(attributeName, new MergeItem(value, mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
            return true;
        }
        if (mergeItem.isFromWebFragment() && !mergeItem.getValue().equals(value)) {
            throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateValueMessage(parentElementName, elementName, (String)mergeItem.getValue(), mergeItem.getBelongedURL(), value, mergeContext.getCurrentJarUrl()));
        }
        return false;
    }

    public static boolean mergeRequired(String attributeName, String parentElementName, String KeyElementName, String keyName, String valueElementName, String value, MergeContext mergeContext) throws DeploymentException {
        if (value == null) {
            return false;
        }
        MergeItem mergeItem = (MergeItem)mergeContext.getAttribute(attributeName);
        if (mergeItem == null) {
            mergeContext.setAttribute(attributeName, new MergeItem(value, mergeContext.getCurrentJarUrl(), ElementSource.WEB_FRAGMENT));
            return true;
        }
        if (mergeItem.isFromWebFragment() && !mergeItem.getValue().equals(value)) {
            throw new DeploymentException(WebDeploymentMessageUtils.createDuplicateKeyValueMessage(parentElementName, KeyElementName, keyName, valueElementName, (String)mergeItem.getValue(), mergeItem.getBelongedURL(), value, mergeContext.getCurrentJarUrl()));
        }
        return false;
    }

    public static void processServletContainerInitializer(EARContext earContext, Module module, Bundle bundle) throws DeploymentException {
        ServiceReference reference = bundle.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        final Set excludedJarNames = (Set)AbstractWebModuleBuilder.EXCLUDED_JAR_URLS.get(earContext.getGeneralData());
        final HashSet servletContainerInitializers = new HashSet();
        try {
            PackageAdmin packageAdmin = (PackageAdmin)bundle.getBundleContext().getService(reference);
            BundleResourceFinder resourceFinder = new BundleResourceFinder(packageAdmin, bundle, "META-INF/services", "javax.servlet.ServletContainerInitializer");
            resourceFinder.find(new BundleResourceFinder.ResourceFinderCallback(){

                public void foundInDirectory(Bundle bundle, String basePath, URL url) throws Exception {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void foundInJar(Bundle bundle, String jarName, ZipEntry entry, InputStream in) throws Exception {
                    if (!excludedJarNames.contains(jarName)) {
                        BufferedReader bufferedReader = null;
                        try {
                            bufferedReader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                            String servletContainerInitializer = null;
                            while ((servletContainerInitializer = bufferedReader.readLine()) != null) {
                                if ((servletContainerInitializer = servletContainerInitializer.trim()).isEmpty()) continue;
                                servletContainerInitializers.add(servletContainerInitializer);
                            }
                        }
                        catch (IOException e) {
                            try {
                                logger.warn("Fail to scan META-INF/services/javax.servlet.ServletContainerInitializer", (Throwable)e);
                            }
                            catch (Throwable throwable) {
                                IOUtils.close(bufferedReader);
                                throw throwable;
                            }
                            IOUtils.close((Closeable)bufferedReader);
                        }
                        IOUtils.close((Closeable)bufferedReader);
                    }
                }
            });
            HashMap<String, Set> servletContainerInitializerClassNamesMap = new HashMap<String, Set>();
            for (String servletContainerInitializer : servletContainerInitializers) {
                Class servletContainerInitializerClass = null;
                try {
                    servletContainerInitializerClass = bundle.loadClass(servletContainerInitializer);
                }
                catch (Exception e) {
                    logger.warn("Fail to load ServletContainerInitializer class " + servletContainerInitializer, (Throwable)e);
                    continue;
                }
                if (!ServletContainerInitializer.class.isAssignableFrom(servletContainerInitializerClass)) {
                    logger.warn("Class " + servletContainerInitializer + " does not implement ServletContainerInitializer interface, ignored");
                    continue;
                }
                HandlesTypes handlesTypes = servletContainerInitializerClass.getAnnotation(HandlesTypes.class);
                if (handlesTypes == null || handlesTypes.value().length == 0) {
                    servletContainerInitializerClassNamesMap.put(servletContainerInitializer, null);
                    continue;
                }
                BundleAssignableClassFinder bundleClassFinder = new BundleAssignableClassFinder(packageAdmin, bundle, handlesTypes.value(), new ClassDiscoveryFilter(){

                    public boolean directoryDiscoveryRequired(String directory) {
                        return true;
                    }

                    public boolean jarFileDiscoveryRequired(String jarUrl) {
                        return !excludedJarNames.contains(jarUrl);
                    }

                    public boolean packageDiscoveryRequired(String packageName) {
                        return true;
                    }

                    public boolean rangeDiscoveryRequired(DiscoveryRange discoveryRange) {
                        return discoveryRange.equals((Object)DiscoveryRange.BUNDLE_CLASSPATH);
                    }
                });
                Set acceptedClassNames = bundleClassFinder.find();
                servletContainerInitializerClassNamesMap.put(servletContainerInitializer, acceptedClassNames.size() > 0 ? acceptedClassNames : null);
            }
            earContext.getGeneralData().put(AbstractWebModuleBuilder.SERVLET_CONTAINER_INITIALIZERS, servletContainerInitializerClassNamesMap);
        }
        catch (Exception e) {
            throw new DeploymentException("Fail to scan javax.servlet.ServletContainerInitializer", (Throwable)e);
        }
        finally {
            bundle.getBundleContext().ungetService(reference);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void processWebFragmentsAndAnnotations(EARContext earContext, Module module, Bundle bundle, WebAppType webApp) throws DeploymentException {
        LinkedHashMap<String, WebFragmentDocument> jarUrlWebFragmentDocumentMap = new LinkedHashMap<String, WebFragmentDocument>();
        String validJarNamePrefix = module.isStandAlone() ? "WEB-INF/lib" : module.getTargetPath() + "/WEB-INF/lib";
        WebFragmentEntry[] webFragmentEntries = null;
        Enumeration enumeration = bundle.getEntryPaths(validJarNamePrefix);
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String url = (String)enumeration.nextElement();
                if (!url.endsWith(".jar")) continue;
                WebFragmentDocument webFragmentDocument = null;
                ZipInputStream in = null;
                try {
                    ZipEntry entry;
                    in = new ZipInputStream(bundle.getEntry(url).openStream());
                    while ((entry = in.getNextEntry()) != null) {
                        if (!entry.getName().equals("META-INF/web-fragment.xml")) continue;
                        webFragmentDocument = (WebFragmentDocument)XmlBeansUtil.parse((InputStream)in);
                        break;
                    }
                }
                catch (IOException e) {
                    try {
                        logger.error("Fail to parse web-fragment.xml files in jar " + url, (Throwable)e);
                        throw new DeploymentException("Fail to scan web-fragment.xml files", (Throwable)e);
                        catch (XmlException e2) {
                            logger.error("Fail to parse web-fragment.xml files in jar " + url, (Throwable)e2);
                            throw new DeploymentException("Fail to scan web-fragment.xml files", (Throwable)e2);
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(in);
                        throw throwable;
                    }
                }
                IOUtils.close((Closeable)in);
                if (webFragmentDocument == null) {
                    webFragmentDocument = WebFragmentDocument.Factory.newInstance();
                    webFragmentDocument.setWebFragment(WebFragmentType.Factory.newInstance());
                }
                jarUrlWebFragmentDocumentMap.put(url, webFragmentDocument);
            }
            webFragmentEntries = MergeHelper.sortWebFragments(earContext, module, bundle, webApp, jarUrlWebFragmentDocumentMap);
        } else {
            webFragmentEntries = new WebFragmentEntry[]{};
        }
        MergeContext mergeContext = new MergeContext();
        mergeContext.setEarContext(earContext);
        mergeContext.setBundle(bundle);
        WEB_SERVLET_ANNOTATION_MERGE_HANDLER.preProcessWebXmlElement(webApp, mergeContext);
        WEB_FILTER_ANNOTATION_MERGE_HANDLER.preProcessWebXmlElement(webApp, mergeContext);
        WEB_LISTENER_ANNOTATION_MERGE_HANDLER.preProcessWebXmlElement(webApp, mergeContext);
        SERVLET_SECURITY_ANNOTATION_MERGE_HANDLER.preProcessWebXmlElement(webApp, mergeContext);
        for (WebFragmentMergeHandler webFragmentMergeHandler : WEB_FRAGMENT_MERGE_HANDLERS) {
            webFragmentMergeHandler.preProcessWebXmlElement(webApp, mergeContext);
        }
        for (WebFragmentEntry webFragmentEntry : webFragmentEntries) {
            mergeContext.setWebFragmentEntry(webFragmentEntry);
            WebFragmentType webFragment = webFragmentEntry.getWebFragment();
            for (WebFragmentMergeHandler webFragmentMergeHandler : WEB_FRAGMENT_MERGE_HANDLERS) {
                webFragmentMergeHandler.merge(webFragment, webApp, mergeContext);
            }
            if (webFragment.getMetadataComplete()) continue;
            MergeHelper.mergeAnnotations(bundle, webApp, mergeContext, webFragmentEntry.getJarURL());
        }
        mergeContext.setWebFragmentEntry(null);
        Object[] arr$ = WEB_FRAGMENT_MERGE_HANDLERS;
        int len$ = arr$.length;
        int i$ = 0;
        while (true) {
            if (i$ >= len$) {
                MergeHelper.mergeAnnotations(bundle, webApp, mergeContext, "/WEB-INF/classes");
                WEB_SERVLET_ANNOTATION_MERGE_HANDLER.postProcessWebXmlElement(webApp, mergeContext);
                WEB_FILTER_ANNOTATION_MERGE_HANDLER.postProcessWebXmlElement(webApp, mergeContext);
                WEB_LISTENER_ANNOTATION_MERGE_HANDLER.postProcessWebXmlElement(webApp, mergeContext);
                SERVLET_SECURITY_ANNOTATION_MERGE_HANDLER.postProcessWebXmlElement(webApp, mergeContext);
                mergeContext.clearup();
                return;
            }
            Object object = arr$[i$];
            object.postProcessWebXmlElement(webApp, mergeContext);
            ++i$;
        }
    }

    public static WebFragmentEntry[] relativeOrderWebFragments(EARContext earContext, Module module, Bundle bundle, WebAppType webApp, Map<String, WebFragmentEntry> webFragmentEntryMap) throws DeploymentException {
        LinkedHashMap<String, WebFragmentOrderEntry> webFragmentOrderEntryMap = new LinkedHashMap<String, WebFragmentOrderEntry>();
        boolean relativeSortRequired = false;
        for (String webFragmentName : webFragmentEntryMap.keySet()) {
            WebFragmentEntry webFragmentEntry = webFragmentEntryMap.get(webFragmentName);
            if (!relativeSortRequired) {
                relativeSortRequired = webFragmentEntry.getWebFragment().getOrderingArray().length > 0;
            }
            webFragmentOrderEntryMap.put(webFragmentName, WebFragmentOrderEntry.create(webFragmentEntry));
        }
        if (!relativeSortRequired) {
            WebFragmentEntry[] webFragmentTypes = new WebFragmentEntry[webFragmentOrderEntryMap.size()];
            int iIndex = 0;
            for (WebFragmentOrderEntry webFragmentOrderEntry : webFragmentOrderEntryMap.values()) {
                webFragmentTypes[iIndex++] = webFragmentOrderEntry.webFragmentEntry;
            }
            return webFragmentTypes;
        }
        LinkedList<WebFragmentOrderEntry> webFragmentOrderEntryList = null;
        if (relativeSortRequired) {
            webFragmentOrderEntryList = new LinkedList<WebFragmentOrderEntry>();
            for (WebFragmentOrderEntry webFragmentOrderEntry : webFragmentOrderEntryMap.values()) {
                for (String beforeEntryName : webFragmentOrderEntry.beforeEntryNames) {
                    ((WebFragmentOrderEntry)webFragmentOrderEntryMap.get((Object)beforeEntryName)).afterEntryNames.add(webFragmentOrderEntry.name);
                }
                if (webFragmentOrderEntry.afterDefined && webFragmentOrderEntry.afterOthers) {
                    webFragmentOrderEntryList.addLast(webFragmentOrderEntry);
                    continue;
                }
                webFragmentOrderEntryList.addFirst(webFragmentOrderEntry);
            }
            for (WebFragmentOrderEntry webFragmentOrderEntry : webFragmentOrderEntryList) {
                MergeHelper.detectCircusAfterDependency(webFragmentOrderEntry, webFragmentOrderEntry, webFragmentOrderEntryMap, new HashSet<String>());
            }
            for (WebFragmentOrderEntry webFragmentOrderEntry : webFragmentOrderEntryMap.values()) {
                for (String afterEntryName : webFragmentOrderEntry.afterEntryNames) {
                    MergeHelper.swap(webFragmentOrderEntry.name, afterEntryName, webFragmentOrderEntryList);
                }
            }
        }
        WebFragmentEntry[] webFragmentTypes = new WebFragmentEntry[webFragmentOrderEntryList.size()];
        int iIndex = 0;
        for (WebFragmentOrderEntry webFragmentOrderEntry : webFragmentOrderEntryList) {
            webFragmentTypes[iIndex++] = webFragmentOrderEntry.webFragmentEntry;
        }
        MergeHelper.saveOrderedLibAttribute(earContext, webFragmentTypes);
        return webFragmentTypes;
    }

    public static WebFragmentEntry[] sortWebFragments(EARContext earContext, Module module, Bundle bundle, WebAppType webApp, Map<String, WebFragmentDocument> jarURLDocumentMap) throws DeploymentException {
        HashMap<String, WebFragmentEntry> webFragmentEntryMap = new HashMap<String, WebFragmentEntry>(jarURLDocumentMap.size());
        boolean absoluteOrderingConfigured = webApp.getAbsoluteOrderingArray().length != 0;
        HashSet<String> usedWebFragmentNames = new HashSet<String>();
        HashMap<String, WebFragmentType> unnamedWebFragmentMap = new HashMap<String, WebFragmentType>();
        for (String jarURL : jarURLDocumentMap.keySet()) {
            String webFragmentName;
            WebFragmentType webFragment = jarURLDocumentMap.get(jarURL).getWebFragment();
            JavaIdentifierType[] names = webFragment.getNameArray();
            String string = webFragmentName = names.length == 0 ? null : names[0].getStringValue();
            if (webFragmentName != null) {
                if (webFragmentEntryMap.containsKey(webFragmentName)) {
                    if (!absoluteOrderingConfigured) {
                        throw new DeploymentException("Mutiple web-fragments with the same name [" + webFragmentName + "] are found in " + jarURL + " and " + ((WebFragmentEntry)webFragmentEntryMap.get(webFragmentName)).getJarURL() + ", you might make the name unique or use absolute ordering in web.xml");
                    }
                } else {
                    webFragmentEntryMap.put(webFragmentName, new WebFragmentEntry(webFragmentName, webFragmentName, webFragment, jarURL));
                }
                usedWebFragmentNames.add(webFragmentName);
            } else {
                unnamedWebFragmentMap.put(jarURL, webFragment);
            }
            if (webFragment.getOrderingArray().length <= 0) continue;
            OrderingType order = webFragment.getOrderingArray()[0];
            if (order.getBefore() != null) {
                for (JavaIdentifierType name : order.getBefore().getNameArray()) {
                    usedWebFragmentNames.add(name.getStringValue());
                }
            }
            if (order.getAfter() == null) continue;
            for (JavaIdentifierType name : order.getAfter().getNameArray()) {
                usedWebFragmentNames.add(name.getStringValue());
            }
        }
        String tempNamePrefix = "geronimo-deployment";
        int nameSubfix = 0;
        for (String webFragmentURL : unnamedWebFragmentMap.keySet()) {
            WebFragmentType webFragment = (WebFragmentType)unnamedWebFragmentMap.get(webFragmentURL);
            String tempWebFragmentName = tempNamePrefix + nameSubfix++;
            while (usedWebFragmentNames.contains(tempWebFragmentName)) {
                tempWebFragmentName = tempNamePrefix + nameSubfix++;
            }
            webFragmentEntryMap.put(tempWebFragmentName, new WebFragmentEntry(tempNamePrefix, null, webFragment, webFragmentURL));
        }
        if (absoluteOrderingConfigured) {
            return MergeHelper.absoluteOrderWebFragments(earContext, module, bundle, webApp, webFragmentEntryMap);
        }
        return MergeHelper.relativeOrderWebFragments(earContext, module, bundle, webApp, webFragmentEntryMap);
    }

    private static void detectCircusAfterDependency(WebFragmentOrderEntry rootWebFragmentOrderEntry, WebFragmentOrderEntry dependentWebFragmentOrderEntry, Map<String, WebFragmentOrderEntry> webFragmentOrderEntryMap, Set<String> visitedWebFragmentNames) throws DeploymentException {
        if (dependentWebFragmentOrderEntry.afterEntryNames.contains(rootWebFragmentOrderEntry.name)) {
            throw new DeploymentException("Circus references are founded for " + rootWebFragmentOrderEntry.webFragmentEntry.getWebFragmentName() + " in the jar " + rootWebFragmentOrderEntry.webFragmentEntry.getJarURL() + ", it must be corrected or change to use absolute-ordering in web.xml file");
        }
        for (String subDependentWebFragmentName : dependentWebFragmentOrderEntry.afterEntryNames) {
            if (visitedWebFragmentNames.contains(subDependentWebFragmentName)) continue;
            visitedWebFragmentNames.add(subDependentWebFragmentName);
            MergeHelper.detectCircusAfterDependency(rootWebFragmentOrderEntry, webFragmentOrderEntryMap.get(subDependentWebFragmentName), webFragmentOrderEntryMap, visitedWebFragmentNames);
        }
    }

    private static void swap(String shouldAfter, String shouldBefore, List<WebFragmentOrderEntry> webFragmentOrderEntries) {
        int iShouldAfterIndex = -1;
        int iShouldBeforeIndex = -1;
        int iIndex = 0;
        for (WebFragmentOrderEntry webFragmentOrderEntry : webFragmentOrderEntries) {
            if (iShouldAfterIndex != -1 && iShouldBeforeIndex != -1) break;
            String currentWebFragmentName = webFragmentOrderEntry.name;
            if (shouldAfter.equals(currentWebFragmentName)) {
                iShouldAfterIndex = iIndex;
            } else if (shouldBefore.equals(currentWebFragmentName)) {
                iShouldBeforeIndex = iIndex;
            }
            ++iIndex;
        }
        if (iShouldAfterIndex < iShouldBeforeIndex) {
            WebFragmentOrderEntry webFragmentOrderEntry = webFragmentOrderEntries.remove(iShouldAfterIndex);
            webFragmentOrderEntries.add(iShouldBeforeIndex + 1, webFragmentOrderEntry);
        }
    }

    private static void saveOrderedLibAttribute(EARContext earContext, WebFragmentEntry[] webFragmentEntries) {
        ArrayList<String> orderedLibs = new ArrayList<String>();
        for (WebFragmentEntry webFragmentEntry : webFragmentEntries) {
            String jarURL = webFragmentEntry.getJarURL();
            int iBeginIndex = jarURL.indexOf("WEB-INF/");
            if (iBeginIndex <= 0) continue;
            orderedLibs.add(jarURL.substring(iBeginIndex + 8));
        }
        earContext.getGeneralData().put(AbstractWebModuleBuilder.ORDERED_LIBS, orderedLibs);
    }

    private static class WebFragmentOrderEntry {
        public boolean afterDefined;
        public Set<String> afterEntryNames = new HashSet<String>();
        public boolean afterOthers;
        public boolean beforeDefined;
        public Set<String> beforeEntryNames = new HashSet<String>();
        public boolean beforeOthers;
        public String name;
        public WebFragmentEntry webFragmentEntry;

        private WebFragmentOrderEntry() {
        }

        public static WebFragmentOrderEntry create(WebFragmentEntry webFragmentEntry) throws DeploymentException {
            WebFragmentOrderEntry webFragmentOrderEntry = new WebFragmentOrderEntry();
            WebFragmentType webFragment = webFragmentEntry.getWebFragment();
            if (webFragment.getOrderingArray().length > 0) {
                OrderingType ordering = webFragment.getOrderingArray()[0];
                OrderingOrderingType after = ordering.getAfter();
                if (after == null) {
                    webFragmentOrderEntry.afterDefined = false;
                } else {
                    webFragmentOrderEntry.afterDefined = true;
                    webFragmentOrderEntry.afterOthers = after.getOthers() != null;
                    for (JavaIdentifierType afterEntryName : after.getNameArray()) {
                        if (afterEntryName.getStringValue().length() <= 0) continue;
                        webFragmentOrderEntry.afterEntryNames.add(afterEntryName.getStringValue());
                    }
                }
                OrderingOrderingType before = ordering.getBefore();
                if (before == null) {
                    webFragmentOrderEntry.beforeDefined = false;
                } else {
                    webFragmentOrderEntry.beforeDefined = true;
                    webFragmentOrderEntry.beforeOthers = before.getOthers() != null;
                    for (JavaIdentifierType beforeEntryName : before.getNameArray()) {
                        if (beforeEntryName.getStringValue().length() <= 0) continue;
                        webFragmentOrderEntry.beforeEntryNames.add(beforeEntryName.getStringValue());
                    }
                }
            }
            if (webFragmentOrderEntry.beforeOthers && webFragmentOrderEntry.afterOthers) {
                throw new DeploymentException("It is not allowed to define before and after others at the same time in jar " + webFragmentEntry.getJarURL());
            }
            webFragmentOrderEntry.webFragmentEntry = webFragmentEntry;
            webFragmentOrderEntry.name = webFragmentEntry.getName();
            return webFragmentOrderEntry;
        }
    }
}

