/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.osgi.web;

import java.util.Hashtable;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class WebApplicationUtils {
    public static boolean isWebApplicationBundle(Bundle bundle) {
        return bundle != null && bundle.getHeaders().get("Web-ContextPath") != null;
    }

    public static ServiceRegistration registerServletContext(BundleContext bundleContext, ServletContext context) {
        return WebApplicationUtils.registerServletContext(bundleContext.getBundle(), context);
    }

    public static ServiceRegistration registerServletContext(Bundle bundle, ServletContext context) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("osgi.web.symbolicname", bundle.getSymbolicName());
        String version = (String)bundle.getHeaders().get("Bundle-Version");
        if (version != null) {
            properties.put("osgi.web.version", version);
        }
        properties.put("osgi.web.contextpath", context.getContextPath());
        return bundle.getBundleContext().registerService(ServletContext.class.getName(), (Object)context, properties);
    }
}

