/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.upgrade;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.xbeans.EnvironmentType;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.ImportType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

public class Upgrade1_0To1_1 {
    private static final Map NAMESPACE_UPDATES = new HashMap();
    private static final QName ENVIRONMENT_QNAME;
    private static final String DEFAULT_GROUPID = "default";
    private static final String DEFAULT_VERSION = "1-default";
    private static final QName CLIENT_ENVIRONMENT_QNAME;
    private static final QName SERVER_ENVIRONMENT_QNAME;
    private static final QName PATTERN_QNAME;
    private static final QName GROUP_QNAME;
    private static final QName ARTIFACT_QNAME;
    private static final QName MODULE_QNAME;
    private static final QName NAME_QNAME;
    private static final QName NAME_QNAME2;
    private static final QName GBEAN_NAME_QNAME;

    public void upgrade(InputStream source, Writer target) throws IOException, XmlException {
        XmlObject xmlObject = Upgrade1_0To1_1.parse(source);
        xmlObject = this.upgrade(xmlObject);
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setSavePrettyPrint();
        xmlObject.save(target, xmlOptions);
    }

    public XmlObject upgrade(XmlObject xmlObject) throws XmlException {
        XmlCursor.TokenType token;
        XmlCursor cursor = xmlObject.newCursor();
        while ((token = cursor.toNextToken()) != XmlCursor.TokenType.ENDDOC) {
            if (token != XmlCursor.TokenType.START) continue;
            Artifact configId = Upgrade1_0To1_1.extractArtifact("configId", cursor);
            Artifact parentId = Upgrade1_0To1_1.extractArtifact("parentId", cursor);
            Artifact clientConfigId = Upgrade1_0To1_1.extractArtifact("clientConfigId", cursor);
            Artifact clientParentId = Upgrade1_0To1_1.extractArtifact("clientParentId", cursor);
            boolean suppressDefaultEnvironment = Upgrade1_0To1_1.extractSuppressDefaultEnvironment(cursor);
            if (clientConfigId != null) {
                Upgrade1_0To1_1.insertEnvironment(clientConfigId, clientParentId, cursor, CLIENT_ENVIRONMENT_QNAME, suppressDefaultEnvironment);
                Upgrade1_0To1_1.insertEnvironment(configId, parentId, cursor, SERVER_ENVIRONMENT_QNAME, false);
            } else if (configId != null) {
                Upgrade1_0To1_1.insertEnvironment(configId, parentId, cursor, ENVIRONMENT_QNAME, suppressDefaultEnvironment);
            } else {
                this.cleanContextPriorityClassLoader(cursor);
                Upgrade1_0To1_1.cleanRef(cursor);
            }
            Upgrade1_0To1_1.checkInvalid(cursor);
        }
        return xmlObject;
    }

    private void cleanContextPriorityClassLoader(XmlCursor cursor) {
        String localName = Upgrade1_0To1_1.getLocalName(cursor);
        if ("context-priority-classloader".equals(localName)) {
            String value = cursor.getTextValue();
            if ("false".equals(value)) {
                cursor.removeXml();
            } else if ("true".equals("true")) {
                cursor.removeXml();
                cursor.insertComment("YOU MUST INSERT THE ELEMENT <inverse-classloading/> INTO THE ENVIRONMENT ELEMENT FOR THIS MODULE");
            }
        }
    }

    private static void checkInvalid(XmlCursor cursor) throws XmlException {
        String localName = Upgrade1_0To1_1.getLocalName(cursor);
        if ("gbean".equals(localName) && cursor.getAttributeText(GBEAN_NAME_QNAME) != null) {
            throw new XmlException("You must replace the gbeanName attribute manually: " + cursor.getAttributeText(GBEAN_NAME_QNAME));
        }
    }

    private static void cleanRef(XmlCursor cursor) throws XmlException {
        String localName = Upgrade1_0To1_1.getLocalName(cursor);
        if ("ejb-ref".equals(localName)) {
            cursor.toFirstChild();
            String application = null;
            String module = null;
            String name = null;
            while (cursor.getName() != null) {
                localName = cursor.getName().getLocalPart();
                if (!"ref-name".equals(localName)) {
                    if ("domain".equals(localName)) {
                        cursor.removeXml();
                    } else if ("server".equals(localName)) {
                        cursor.removeXml();
                    } else if ("application".equals(localName)) {
                        application = cursor.getTextValue();
                        if ("null".equals(application)) {
                            application = null;
                        }
                        cursor.removeXml();
                    } else if ("module".equals(localName)) {
                        if (application == null) {
                            application = cursor.getTextValue();
                        } else {
                            module = cursor.getTextValue();
                        }
                        cursor.removeXml();
                    } else if ("type".equals(localName)) {
                        cursor.removeXml();
                    } else if ("name".equals(localName)) {
                        name = cursor.getTextValue();
                        cursor.removeXml();
                    } else {
                        if ("ejb-link".equals(localName)) break;
                        if ("target-name".equals(localName)) {
                            ObjectName targetName = Upgrade1_0To1_1.extractObjectName(cursor);
                            name = targetName.getKeyProperty("name");
                            application = targetName.getKeyProperty("J2EEApplication");
                            if ("null".equals(application)) {
                                application = targetName.getKeyProperty("EJBModule");
                            } else {
                                module = targetName.getKeyProperty("EJBModule");
                            }
                        } else if ("ns-corbaloc".equals(localName)) {
                            cursor.toNextSibling();
                        } else if (!("css".equals(localName) || "css-link".equals(localName) || "css-name".equals(localName))) {
                            throw new IllegalStateException("unrecognized element: " + cursor.getTextValue());
                        }
                    }
                }
                if (cursor.toNextSibling()) continue;
            }
            if (name != null) {
                cursor.beginElement(PATTERN_QNAME);
                if (application != null) {
                    try {
                        Artifact artifact = Artifact.create(application);
                        cursor.insertElementWithText(GROUP_QNAME, artifact.getGroupId());
                        cursor.insertElementWithText(ARTIFACT_QNAME, artifact.getArtifactId());
                    }
                    catch (Exception e) {
                        cursor.insertElementWithText(ARTIFACT_QNAME, application.replace('/', '_'));
                    }
                }
                if (module != null) {
                    cursor.insertElementWithText(MODULE_QNAME, module);
                }
                cursor.insertElementWithText(NAME_QNAME, name);
                cursor.toNextToken();
            }
        } else if ("gbean-name".equals(localName)) {
            ObjectName targetName = Upgrade1_0To1_1.extractObjectName(cursor);
            String name = targetName.getKeyProperty("name");
            cursor.insertComment("CHECK THAT THE TARGET GBEAN IS IN THE ANCESTOR SET OF THIS MODULE AND THAT THE NAME UNIQUELY IDENTIFIES IT");
            cursor.insertElementWithText(NAME_QNAME2, name);
        }
    }

    private static ObjectName extractObjectName(XmlCursor cursor) throws XmlException {
        ObjectName targetName;
        String targetNameString = cursor.getTextValue();
        cursor.removeXml();
        try {
            targetName = ObjectName.getInstance(targetNameString);
        }
        catch (MalformedObjectNameException e) {
            throw new XmlException("Invalid object name: " + targetNameString);
        }
        return targetName;
    }

    private static String getLocalName(XmlCursor cursor) {
        QName name = cursor.getName();
        return name == null ? null : name.getLocalPart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertEnvironment(Artifact configId, Artifact parentId, XmlCursor cursor, QName environmentQname, boolean suppressDefaultEnvironment) {
        Upgrade1_0To1_1.positionEnvironment(cursor);
        Environment environment = new Environment();
        environment.setConfigId(configId);
        if (parentId != null) {
            environment.addDependency(parentId, ImportType.ALL);
        }
        environment.setSuppressDefaultEnvironment(suppressDefaultEnvironment);
        Upgrade1_0To1_1.extractDependencies(cursor, environment);
        EnvironmentType environmentType = EnvironmentBuilder.buildEnvironmentType((Environment)environment);
        cursor.beginElement(environmentQname);
        XmlCursor element = environmentType.newCursor();
        try {
            element.copyXmlContents(cursor);
        }
        finally {
            element.dispose();
        }
    }

    private static void extractDependencies(XmlCursor cursor, Environment environment) {
        String localPart;
        if (cursor.getName() == null) {
            return;
        }
        while ((localPart = Upgrade1_0To1_1.getLocalName(cursor)).equals("dependency") || localPart.equals("import")) {
            Upgrade1_0To1_1.extractDependency(cursor, environment);
            if (cursor.toNextSibling()) continue;
        }
    }

    private static void extractDependency(XmlCursor cursor, Environment environment) {
        Artifact artifact;
        cursor.push();
        cursor.toFirstChild();
        if (cursor.getName().getLocalPart().equals("uri")) {
            String uri = cursor.getTextValue();
            artifact = Upgrade1_0To1_1.toArtifact(uri);
        } else {
            Upgrade1_0To1_1.checkName(cursor, "groupId");
            String groupId = cursor.getTextValue();
            cursor.toNextSibling();
            String type = "jar";
            if (cursor.getName().getLocalPart().equals("type")) {
                type = cursor.getTextValue();
                cursor.toNextSibling();
            }
            Upgrade1_0To1_1.checkName(cursor, "artifactId");
            String artifactId = cursor.getTextValue();
            cursor.toNextSibling();
            Upgrade1_0To1_1.checkName(cursor, "version");
            String version = cursor.getTextValue();
            artifact = new Artifact(groupId, artifactId, version, type);
        }
        environment.addDependency(artifact, ImportType.ALL);
        cursor.pop();
        cursor.removeXml();
    }

    private static void checkName(XmlCursor cursor, String localName) {
        if (!cursor.getName().getLocalPart().equals(localName)) {
            throw new IllegalArgumentException("Expected element: " + localName + " but actually: " + cursor.getName().getLocalPart());
        }
    }

    private static void positionEnvironment(XmlCursor cursor) {
        XmlCursor.TokenType token;
        while ((token = cursor.toNextToken()) != XmlCursor.TokenType.START && token != XmlCursor.TokenType.END) {
        }
    }

    private static Artifact extractArtifact(String attrName, XmlCursor cursor) {
        QName attrQName = new QName(null, attrName);
        String attrValue = cursor.getAttributeText(attrQName);
        if (attrValue != null) {
            cursor.removeAttribute(attrQName);
            return Upgrade1_0To1_1.toArtifact(attrValue);
        }
        return null;
    }

    private static Artifact toArtifact(String attrValue) {
        try {
            return Artifact.create((String)attrValue);
        }
        catch (Exception e) {
            return new Artifact(DEFAULT_GROUPID, attrValue.replace('/', '_'), DEFAULT_VERSION, "car");
        }
    }

    private static boolean extractSuppressDefaultEnvironment(XmlCursor cursor) {
        QName attrQName = new QName(null, "suppressDefaultParentId");
        String attrValue = cursor.getAttributeText(attrQName);
        if (attrValue != null) {
            cursor.removeAttribute(attrQName);
            return Boolean.valueOf(attrValue);
        }
        return false;
    }

    public static XmlObject parse(InputStream is) throws IOException, XmlException {
        ArrayList errors = new ArrayList();
        XmlObject parsed = XmlObject.Factory.parse((InputStream)is, (XmlOptions)Upgrade1_0To1_1.createXmlOptions(errors));
        if (errors.size() != 0) {
            throw new XmlException(errors.toArray().toString());
        }
        return parsed;
    }

    public static XmlOptions createXmlOptions(Collection errors) {
        XmlOptions options = new XmlOptions();
        options.setLoadLineNumbers();
        options.setErrorListener(errors);
        options.setLoadSubstituteNamespaces(NAMESPACE_UPDATES);
        return options;
    }

    static {
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/application-client", "http://geronimo.apache.org/xml/ns/j2ee/application-client-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/application-client-1.0", "http://geronimo.apache.org/xml/ns/j2ee/application-client-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/application-client-1.1", "http://geronimo.apache.org/xml/ns/j2ee/application-client-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/application", "http://geronimo.apache.org/xml/ns/j2ee/application-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/application-1.0", "http://geronimo.apache.org/xml/ns/j2ee/application-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/application-1.1", "http://geronimo.apache.org/xml/ns/j2ee/application-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/deployment", "http://geronimo.apache.org/xml/ns/deployment-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/deployment-1.0", "http://geronimo.apache.org/xml/ns/deployment-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/deployment-1.1", "http://geronimo.apache.org/xml/ns/deployment-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/connector", "http://geronimo.apache.org/xml/ns/j2ee/connector-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/connector-1.0", "http://geronimo.apache.org/xml/ns/j2ee/connector-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/connector-1.1", "http://geronimo.apache.org/xml/ns/j2ee/connector-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/deployment/javabean", "http://geronimo.apache.org/xml/ns/deployment/javabean-1.0");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/loginconfig", "http://geronimo.apache.org/xml/ns/loginconfig-1.0");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/loginconfig-1.0", "http://geronimo.apache.org/xml/ns/loginconfig-1.0");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/loginconfig-1.1", "http://geronimo.apache.org/xml/ns/loginconfig-1.0");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/naming", "http://geronimo.apache.org/xml/ns/naming-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/naming-1.0", "http://geronimo.apache.org/xml/ns/naming-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/naming-1.1", "http://geronimo.apache.org/xml/ns/naming-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/security", "http://geronimo.apache.org/xml/ns/security-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/security-1.0", "http://geronimo.apache.org/xml/ns/security-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/security-1.1", "http://geronimo.apache.org/xml/ns/security-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/web", "http://geronimo.apache.org/xml/ns/j2ee/web-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/web-1.0", "http://geronimo.apache.org/xml/ns/j2ee/web-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/web-1.1", "http://geronimo.apache.org/xml/ns/j2ee/web-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/web-1.0", "http://geronimo.apache.org/xml/ns/j2ee/web-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/web/jetty", "http://geronimo.apache.org/xml/ns/j2ee/web/jetty-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/web/jetty-1.0", "http://geronimo.apache.org/xml/ns/j2ee/web/jetty-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/web/jetty-1.0", "http://geronimo.apache.org/xml/ns/j2ee/web/jetty-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/web/jetty-1.1", "http://geronimo.apache.org/xml/ns/j2ee/web/jetty-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/web/jetty/config", "http://geronimo.apache.org/xml/ns/j2ee/web/jetty/config-1.0");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/web/tomcat", "http://geronimo.apache.org/xml/ns/j2ee/web/tomcat-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/web/tomcat-1.0", "http://geronimo.apache.org/xml/ns/j2ee/web/tomcat-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/web/tomcat-1.0", "http://geronimo.apache.org/xml/ns/j2ee/web/tomcat-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/web/tomcat-1.1", "http://geronimo.apache.org/xml/ns/j2ee/web/tomcat-1.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/web/tomcat/config", "http://geronimo.apache.org/xml/ns/j2ee/web/tomcat/config-1.0");
        NAMESPACE_UPDATES.put("http://www.openejb.org/xml/ns/openejb-jar", "http://www.openejb.org/xml/ns/openejb-jar-2.2");
        NAMESPACE_UPDATES.put("http://www.openejb.org/xml/ns/openejb-jar-2.0", "http://www.openejb.org/xml/ns/openejb-jar-2.2");
        NAMESPACE_UPDATES.put("http://www.openejb.org/xml/ns/openejb-jar-2.1", "http://www.openejb.org/xml/ns/openejb-jar-2.2");
        NAMESPACE_UPDATES.put("http://www.openejb.org/xml/ns/pkgen", "http://www.openejb.org/xml/ns/pkgen-2.0");
        NAMESPACE_UPDATES.put("http://www.openejb.org/xml/ns/corba-css-config_1_0", "http://www.openejb.org/xml/ns/corba-css-config-2.0");
        NAMESPACE_UPDATES.put("http://www.openejb.org/xml/ns/corba-tss-config_1_0", "http://www.openejb.org/xml/ns/corba-tss-config-2.0");
        ENVIRONMENT_QNAME = new QName("http://geronimo.apache.org/xml/ns/deployment-1.2", "environment");
        CLIENT_ENVIRONMENT_QNAME = new QName("http://geronimo.apache.org/xml/ns/deployment-1.2", "client-environment");
        SERVER_ENVIRONMENT_QNAME = new QName("http://geronimo.apache.org/xml/ns/deployment-1.2", "server-environment");
        PATTERN_QNAME = new QName("http://geronimo.apache.org/xml/ns/naming-1.2", "pattern");
        GROUP_QNAME = new QName("http://geronimo.apache.org/xml/ns/naming-1.2", "groupId");
        ARTIFACT_QNAME = new QName("http://geronimo.apache.org/xml/ns/naming-1.2", "artifactId");
        MODULE_QNAME = new QName("http://geronimo.apache.org/xml/ns/naming-1.2", "module");
        NAME_QNAME = new QName("http://geronimo.apache.org/xml/ns/naming-1.2", "name");
        NAME_QNAME2 = new QName("http://geronimo.apache.org/xml/ns/deployment-1.2", "name");
        GBEAN_NAME_QNAME = new QName(null, "gbeanName");
    }
}

