/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.apache.catalina.Cluster;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.Valve;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.ha.ClusterListener;
import org.apache.catalina.ha.tcp.SimpleTcpCluster;
import org.apache.geronimo.tomcat.model.ChannelType;
import org.apache.geronimo.tomcat.model.ClusterListenerType;
import org.apache.geronimo.tomcat.model.ListenerType;
import org.apache.geronimo.tomcat.model.ManagerType;
import org.apache.geronimo.tomcat.model.ValveType;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ClusterType", propOrder={"manager", "channel", "valve", "listener", "clusterListener"})
public class ClusterType {
    @XmlAttribute
    protected String className = SimpleTcpCluster.class.getName();
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();
    @XmlElement(name="Manager")
    protected List<ManagerType> manager;
    @XmlElement(name="Channel")
    protected ChannelType channel;
    @XmlElement(name="Valve")
    protected List<ValveType> valve;
    @XmlElement(name="Listener")
    protected List<ListenerType> listener;
    @XmlElement(name="ClusterListener")
    protected List<ClusterListenerType> clusterListener;

    public ChannelType getChannel() {
        return this.channel;
    }

    public String getClassName() {
        return this.className;
    }

    public Cluster getCluster(ClassLoader cl) throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<QName, String> entry : this.otherAttributes.entrySet()) {
            String name = entry.getKey().getLocalPart();
            properties.put(name, entry.getValue());
        }
        ObjectRecipe recipe = new ObjectRecipe(this.className, properties);
        recipe.allow(Option.IGNORE_MISSING_PROPERTIES);
        Cluster cluster = (Cluster)recipe.create(cl);
        for (ManagerType managerType : this.getManager()) {
            cluster.registerManager(managerType.getManager(cl));
        }
        if (cluster instanceof CatalinaCluster) {
            CatalinaCluster catalinaCluster = (CatalinaCluster)cluster;
            if (this.getChannel() != null) {
                catalinaCluster.setChannel(this.getChannel().getChannel(cl));
            }
            for (ValveType valveType : this.getValve()) {
                Valve valve = valveType.getValve(cl);
                catalinaCluster.addValve(valve);
            }
            for (ClusterListenerType clusterListenerType : this.getClusterListener()) {
                ClusterListener clusterListener = clusterListenerType.getLifecycleListener(cl);
                catalinaCluster.addClusterListener(clusterListener);
            }
        }
        if (cluster instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)cluster;
            for (ListenerType listenerType : this.getListener()) {
                lifecycle.addLifecycleListener(listenerType.getLifecycleListener(cl));
            }
        }
        return cluster;
    }

    public List<ClusterListenerType> getClusterListener() {
        return this.clusterListener;
    }

    public List<ListenerType> getListener() {
        if (this.listener == null) {
            this.listener = new ArrayList<ListenerType>();
        }
        return this.listener;
    }

    public List<ManagerType> getManager() {
        if (this.manager == null) {
            this.manager = new ArrayList<ManagerType>();
        }
        return this.manager;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public List<ValveType> getValve() {
        if (this.valve == null) {
            this.valve = new ArrayList<ValveType>();
        }
        return this.valve;
    }

    public void setClassName(String className) {
        this.className = className;
    }
}

