/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.connector;

import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import org.apache.catalina.connector.Connector;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.Persistent;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.tomcat.TomcatContainer;
import org.apache.geronimo.tomcat.connector.Http11NIOConnectorGBean;
import org.apache.geronimo.tomcat.connector.Https11Protocol;

@GBean(name="Tomcat Connector HTTPS NIO")
public class Https11NIOConnectorGBean
extends Http11NIOConnectorGBean
implements Https11Protocol {
    private String keystoreFileName;
    private String truststoreFileName;
    private String algorithm;

    public Https11NIOConnectorGBean(@ParamAttribute(manageable=false, name="name") String name, @ParamAttribute(manageable=false, name="initParams") Map<String, String> initParams, @ParamAttribute(manageable=false, name="host") String host, @ParamAttribute(manageable=false, name="port") int port, @ParamReference(name="TomcatContainer") TomcatContainer container, @ParamReference(name="ServerInfo") ServerInfo serverInfo, @ParamAttribute(manageable=false, name="connector") Connector conn) throws Exception {
        super(name, initParams, host, port, container, serverInfo, conn);
        this.setSslEnabled(true);
        this.setScheme("https");
        this.setSecure(true);
    }

    @Override
    public int getDefaultPort() {
        return 443;
    }

    @Override
    public String getGeronimoProtocol() {
        return "HTTPS";
    }

    @Override
    public String getAlgorithm() {
        if ("default".equalsIgnoreCase(this.algorithm)) {
            return KeyManagerFactory.getDefaultAlgorithm();
        }
        return this.algorithm;
    }

    @Override
    public String getCiphers() {
        return (String)this.connector.getAttribute("ciphers");
    }

    @Override
    public String getClientAuth() {
        Object value = this.connector.getAttribute("clientAuth");
        return value == null ? "false" : value.toString();
    }

    @Override
    public String getKeyAlias() {
        return (String)this.connector.getAttribute("keyAlias");
    }

    @Override
    public String getKeystoreFile() {
        String keystore = (String)this.connector.getAttribute("keystoreFile");
        return this.getRelatedPathtoCatalinaHome(keystore);
    }

    @Override
    public String getKeystoreType() {
        return (String)this.connector.getAttribute("keystoreType");
    }

    @Override
    public String getSslProtocol() {
        return (String)this.connector.getAttribute("sslProtocol");
    }

    @Override
    public String getTruststoreFile() {
        String truststoreFile = (String)this.connector.getAttribute("truststoreFile");
        return this.getRelatedPathtoCatalinaHome(truststoreFile);
    }

    @Override
    public String getTruststoreType() {
        return (String)this.connector.getAttribute("truststoreType");
    }

    @Override
    public String getTruststorePass() {
        return (String)this.connector.getAttribute("truststorePass");
    }

    @Override
    public String getKeystorePass() {
        return (String)this.connector.getAttribute("keystorePass");
    }

    @Override
    @Persistent(manageable=false)
    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        if ("default".equalsIgnoreCase(algorithm)) {
            algorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        this.connector.setAttribute("algorithm", (Object)algorithm);
    }

    @Override
    @Persistent(manageable=false)
    public void setCiphers(String ciphers) {
        this.connector.setAttribute("ciphers", (Object)ciphers);
    }

    @Override
    @Persistent(manageable=false)
    public void setClientAuth(String clientAuth) {
        this.connector.setAttribute("clientAuth", (Object)clientAuth);
    }

    @Override
    @Persistent(manageable=false)
    public void setKeyAlias(String keyAlias) {
        if (keyAlias.equals("")) {
            keyAlias = null;
        }
        this.connector.setAttribute("keyAlias", (Object)keyAlias);
    }

    @Override
    @Persistent(manageable=false)
    public void setKeystoreFile(String keystoreFile) {
        if (keystoreFile != null && keystoreFile.equals("")) {
            keystoreFile = null;
        }
        this.keystoreFileName = keystoreFile;
        if (this.keystoreFileName == null) {
            this.connector.setAttribute("keystoreFile", (Object)this.keystoreFileName);
        } else {
            String resovledAbsolutePath = this.getAbsolutePathBasedOnCatalinaHome(this.keystoreFileName);
            if (resovledAbsolutePath != null) {
                this.connector.setAttribute("keystoreFile", (Object)resovledAbsolutePath);
            }
        }
    }

    @Override
    @Persistent(manageable=false)
    public void setKeystorePass(String keystorePass) {
        if (keystorePass != null && keystorePass.equals("")) {
            keystorePass = null;
        }
        this.connector.setAttribute("keystorePass", (Object)keystorePass);
    }

    @Override
    @Persistent(manageable=false)
    public void setKeystoreType(String keystoreType) {
        if (keystoreType != null && keystoreType.equals("")) {
            keystoreType = null;
        }
        this.connector.setAttribute("keystoreType", (Object)keystoreType);
    }

    @Override
    @Persistent(manageable=false)
    public void setSslProtocol(String sslProtocol) {
        if (sslProtocol != null && sslProtocol.equals("")) {
            sslProtocol = null;
        }
        this.connector.setAttribute("sslProtocol", (Object)sslProtocol);
    }

    @Override
    @Persistent(manageable=false)
    public void setTruststoreFile(String truststoreFile) {
        if (truststoreFile != null && truststoreFile.equals("")) {
            truststoreFile = null;
        }
        this.truststoreFileName = truststoreFile;
        if (this.truststoreFileName == null) {
            this.connector.setAttribute("truststoreFile", null);
        } else {
            String resovledAbsolutePath = this.getAbsolutePathBasedOnCatalinaHome(truststoreFile);
            if (resovledAbsolutePath != null) {
                this.connector.setAttribute("truststoreFile", (Object)resovledAbsolutePath);
            }
        }
    }

    @Override
    @Persistent(manageable=false)
    public void setTruststorePass(String truststorePass) {
        if (truststorePass != null && truststorePass.equals("")) {
            truststorePass = null;
        }
        this.connector.setAttribute("truststorePass", (Object)truststorePass);
    }

    @Override
    @Persistent(manageable=false)
    public void setTruststoreType(String truststoreType) {
        if (truststoreType != null && truststoreType.equals("")) {
            truststoreType = null;
        }
        this.connector.setAttribute("truststoreType", (Object)truststoreType);
    }
}

