/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.connector;

import java.util.Map;
import org.apache.catalina.connector.Connector;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.Persistent;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.tomcat.TomcatContainer;
import org.apache.geronimo.tomcat.connector.BaseHttp11ConnectorGBean;
import org.apache.geronimo.tomcat.connector.Http11APRProtocol;

@GBean(name="Tomcat Connector HTTP APR")
public class Http11APRConnectorGBean
extends BaseHttp11ConnectorGBean
implements Http11APRProtocol {
    public Http11APRConnectorGBean(@ParamAttribute(manageable=false, name="name") String name, @ParamAttribute(manageable=false, name="initParams") Map<String, String> initParams, @ParamAttribute(manageable=false, name="host") String host, @ParamAttribute(manageable=false, name="port") int port, @ParamReference(name="TomcatContainer") TomcatContainer container, @ParamReference(name="ServerInfo") ServerInfo serverInfo, @ParamAttribute(manageable=false, name="connector") Connector conn) throws Exception {
        super(name, initParams, "org.apache.coyote.http11.Http11AprProtocol", host, port, container, serverInfo, conn);
    }

    @Override
    public int getDefaultPort() {
        return 80;
    }

    @Override
    public String getGeronimoProtocol() {
        return "HTTP";
    }

    @Override
    public int getPollTime() {
        Object value = this.connector.getAttribute("pollTime");
        return value == null ? 2000 : new Integer(value.toString());
    }

    @Override
    public int getPollerSize() {
        Object value = this.connector.getAttribute("pollerSize");
        return value == null ? 8192 : new Integer(value.toString());
    }

    @Override
    public int getSendfileSize() {
        Object value = this.connector.getAttribute("sendfileSize");
        return value == null ? 8192 : new Integer(value.toString());
    }

    public String getSslCACertificateFile() {
        String path = (String)this.connector.getAttribute("SSLCACertificateFile");
        return this.getRelatedPathtoCatalinaHome(path);
    }

    public String getSslCACertificatePath() {
        String path = (String)this.connector.getAttribute("SSLCACertificatePath");
        return this.getRelatedPathtoCatalinaHome(path);
    }

    public String getSslCertificateChainFile() {
        String path = (String)this.connector.getAttribute("truststoreFile");
        return this.getRelatedPathtoCatalinaHome(path);
    }

    public String getSslCertificateFile() {
        String path = (String)this.connector.getAttribute("SSLCertificateFile");
        return this.getRelatedPathtoCatalinaHome(path);
    }

    public String getSslCertificateKeyFile() {
        String path = (String)this.connector.getAttribute("SSLCertificateKeyFile");
        return this.getRelatedPathtoCatalinaHome(path);
    }

    public String getSslCipherSuite() {
        return (String)this.connector.getAttribute("SSLCipherSuite");
    }

    public String getSslProtocol() {
        return (String)this.connector.getAttribute("SSLProtocol");
    }

    public String getSslCARevocationFile() {
        String path = (String)this.connector.getAttribute("SSLCARevocationFile");
        return this.getRelatedPathtoCatalinaHome(path);
    }

    public String getSslCARevocationPath() {
        String path = (String)this.connector.getAttribute("SSLCARevocationPath");
        return this.getRelatedPathtoCatalinaHome(path);
    }

    public String getSslVerifyClient() {
        return (String)this.connector.getAttribute("SSLVerifyClient");
    }

    public int getSslVerifyDepth() {
        Object value = this.connector.getAttribute("SSLVerifyDepth");
        return value == null ? 10 : new Integer(value.toString());
    }

    @Override
    public boolean getUseSendfile() {
        Object value = this.connector.getAttribute("useSendfile");
        return value == null ? true : Boolean.valueOf(value.toString());
    }

    public String getSslPassword() {
        return (String)this.connector.getAttribute("SSLPassword");
    }

    @Override
    @Persistent(manageable=false)
    public void setPollTime(int pollTime) {
        this.connector.setAttribute("pollTime", (Object)pollTime);
    }

    @Override
    @Persistent(manageable=false)
    public void setPollerSize(int pollerSize) {
        this.connector.setAttribute("pollerSize", (Object)pollerSize);
    }

    @Override
    @Persistent(manageable=false)
    public void setSendfileSize(int sendfileSize) {
        this.connector.setAttribute("sendfileSize", (Object)sendfileSize);
    }

    @Override
    @Persistent(manageable=false)
    public void setUseSendfile(boolean useSendfile) {
        this.connector.setAttribute("useSendfile", (Object)useSendfile);
    }
}

