/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.security.authentication;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.Base64;
import org.apache.geronimo.tomcat.security.AuthResult;
import org.apache.geronimo.tomcat.security.Authenticator;
import org.apache.geronimo.tomcat.security.LoginService;
import org.apache.geronimo.tomcat.security.ServerAuthException;
import org.apache.geronimo.tomcat.security.TomcatAuthStatus;
import org.apache.geronimo.tomcat.security.UserIdentity;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;

public class BasicAuthenticator
implements Authenticator {
    private static final byte[] AUTHENTICATE_BYTES = new byte[]{87, 87, 87, 45, 65, 117, 116, 104, 101, 110, 116, 105, 99, 97, 116, 101};
    private final LoginService loginService;
    private final String realmName;
    private final UserIdentity unauthenticatedIdentity;

    public BasicAuthenticator(LoginService loginService, String realmName, UserIdentity unauthenticatedIdentity) {
        this.loginService = loginService;
        this.realmName = realmName;
        this.unauthenticatedIdentity = unauthenticatedIdentity;
    }

    @Override
    public AuthResult validateRequest(Request request, HttpServletResponse response, boolean isAuthMandatory, UserIdentity cachedIdentity) throws ServerAuthException {
        String username = null;
        String password = null;
        MessageBytes authorization = request.getCoyoteRequest().getMimeHeaders().getValue("authorization");
        if (authorization != null) {
            UserIdentity userIdentity;
            authorization.toBytes();
            ByteChunk authorizationBC = authorization.getByteChunk();
            if (authorizationBC.startsWithIgnoreCase("basic ", 0)) {
                authorizationBC.setOffset(authorizationBC.getOffset() + 6);
                CharChunk authorizationCC = authorization.getCharChunk();
                Base64.decode((ByteChunk)authorizationBC, (CharChunk)authorizationCC);
                int colon = authorizationCC.indexOf(':');
                if (colon < 0) {
                    username = authorizationCC.toString();
                } else {
                    char[] buf = authorizationCC.getBuffer();
                    username = new String(buf, 0, colon);
                    password = new String(buf, colon + 1, authorizationCC.getEnd() - colon - 1);
                }
                authorizationBC.setOffset(authorizationBC.getOffset() - 6);
            }
            if ((userIdentity = this.loginService.login(username, password)) != null) {
                return new AuthResult(TomcatAuthStatus.SUCCESS, userIdentity, false);
            }
        }
        if (isAuthMandatory) {
            try {
                StringBuilder authenticateCC = new StringBuilder();
                authenticateCC.append("Basic realm=\"");
                authenticateCC.append(this.realmName == null ? "<unspecified>" : this.realmName);
                authenticateCC.append('\"');
                response.addHeader(new String(AUTHENTICATE_BYTES), authenticateCC.toString());
                response.sendError(401);
                return new AuthResult(TomcatAuthStatus.SEND_CONTINUE, null, false);
            }
            catch (IOException e) {
                throw new ServerAuthException(e);
            }
        }
        return new AuthResult(TomcatAuthStatus.SUCCESS, this.unauthenticatedIdentity, false);
    }

    @Override
    public boolean secureResponse(Request request, Response response, AuthResult authResult) {
        return true;
    }

    @Override
    public String getAuthType() {
        return "BASIC";
    }

    @Override
    public AuthResult login(String username, String password, Request request) throws ServletException {
        UserIdentity userIdentity = this.loginService.login(username, password);
        if (userIdentity != null) {
            return new AuthResult(TomcatAuthStatus.SUCCESS, userIdentity, false);
        }
        return new AuthResult(TomcatAuthStatus.FAILURE, null, false);
    }

    @Override
    public void logout(Request request) {
    }
}

