/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.interceptor;

import java.util.Set;
import javax.resource.ResourceException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectorInstanceContext;
import org.apache.geronimo.connector.outbound.connectiontracking.SharedConnectorInstanceContext;
import org.apache.geronimo.connector.outbound.connectiontracking.TrackedConnectionAssociator;
import org.apache.geronimo.tomcat.interceptor.BeforeAfter;
import org.apache.geronimo.tomcat.interceptor.BeforeAfterContext;

public class InstanceContextBeforeAfter
implements BeforeAfter {
    private final BeforeAfter next;
    private final int oldIndex;
    private final int newIndex;
    private final Set unshareableResources;
    private final Set applicationManagedSecurityResources;
    private final TrackedConnectionAssociator trackedConnectionAssociator;

    public InstanceContextBeforeAfter(BeforeAfter next, int oldIndex, int newIndex, Set unshareableResources, Set applicationManagedSecurityResources, TrackedConnectionAssociator trackedConnectionAssociator) {
        this.next = next;
        this.oldIndex = oldIndex;
        this.newIndex = newIndex;
        this.unshareableResources = unshareableResources;
        this.applicationManagedSecurityResources = applicationManagedSecurityResources;
        this.trackedConnectionAssociator = trackedConnectionAssociator;
    }

    @Override
    public void before(BeforeAfterContext beforeAfterContext, ServletRequest httpRequest, ServletResponse httpResponse, int dispatch) {
        try {
            SharedConnectorInstanceContext newConnectorInstanceContext = new SharedConnectorInstanceContext(this.unshareableResources, this.applicationManagedSecurityResources, false);
            ConnectorInstanceContext oldContext = this.trackedConnectionAssociator.enter((ConnectorInstanceContext)newConnectorInstanceContext);
            if (oldContext != null) {
                newConnectorInstanceContext.share(oldContext);
            }
            beforeAfterContext.contexts[this.oldIndex] = oldContext;
            beforeAfterContext.clearRequiredFlags[this.oldIndex] = true;
            beforeAfterContext.contexts[this.newIndex] = newConnectorInstanceContext;
            beforeAfterContext.clearRequiredFlags[this.newIndex] = true;
        }
        catch (ResourceException e) {
            throw new RuntimeException(e);
        }
        try {
            if (this.next != null) {
                this.next.before(beforeAfterContext, httpRequest, httpResponse, dispatch);
            }
        }
        catch (RuntimeException e) {
            this.cleanUp(beforeAfterContext);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void after(BeforeAfterContext beforeAfterContext, ServletRequest httpRequest, ServletResponse httpResponse, int dispatch) {
        try {
            if (this.next != null) {
                this.next.after(beforeAfterContext, httpRequest, httpResponse, dispatch);
            }
        }
        finally {
            this.cleanUp(beforeAfterContext);
        }
    }

    private void cleanUp(BeforeAfterContext beforeAfterContext) {
        if (beforeAfterContext.clearRequiredFlags[this.oldIndex]) {
            try {
                ConnectorInstanceContext oldConnectorInstanceContext = (ConnectorInstanceContext)beforeAfterContext.contexts[this.oldIndex];
                if (beforeAfterContext.clearRequiredFlags[this.newIndex]) {
                    SharedConnectorInstanceContext newConnectorInstanceContext = (SharedConnectorInstanceContext)beforeAfterContext.contexts[this.newIndex];
                    if (oldConnectorInstanceContext != null) {
                        newConnectorInstanceContext.hide();
                    }
                    beforeAfterContext.clearRequiredFlags[this.newIndex] = false;
                }
                this.trackedConnectionAssociator.exit(oldConnectorInstanceContext);
                beforeAfterContext.clearRequiredFlags[this.oldIndex] = false;
            }
            catch (ResourceException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

