/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.security.jacc;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebUserDataPermission;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.connector.Request;
import org.apache.geronimo.tomcat.security.AuthResult;
import org.apache.geronimo.tomcat.security.Authorizer;
import org.apache.geronimo.tomcat.security.UserIdentity;
import org.apache.geronimo.tomcat.security.jacc.JACCUserIdentity;

public class JACCAuthorizer
implements Authorizer {
    private final AccessControlContext defaultACC;

    public JACCAuthorizer(AccessControlContext defaultACC) {
        this.defaultACC = defaultACC;
    }

    @Override
    public Object getConstraints(Request request) {
        return null;
    }

    @Override
    public boolean hasUserDataPermissions(Request request, Object constraints) {
        try {
            this.defaultACC.checkPermission((Permission)new WebUserDataPermission((HttpServletRequest)request));
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    @Override
    public boolean isAuthMandatory(Request request, Object constraints) {
        try {
            this.defaultACC.checkPermission((Permission)new WebResourcePermission((HttpServletRequest)request));
            return false;
        }
        catch (AccessControlException e) {
            return true;
        }
    }

    @Override
    public boolean hasResourcePermissions(Request request, AuthResult authResult, Object constraints, UserIdentity userIdentity) {
        if (!(userIdentity instanceof JACCUserIdentity)) {
            return false;
        }
        AccessControlContext acc = ((JACCUserIdentity)userIdentity).getAccessControlContext();
        try {
            acc.checkPermission((Permission)new WebResourcePermission((HttpServletRequest)request));
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }
}

