/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.listener;

import java.util.HashMap;
import javax.security.auth.login.LoginException;
import javax.security.jacc.PolicyContextException;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.geronimo.security.jacc.ApplicationPolicyConfigurationManager;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.geronimo.tomcat.GeronimoStandardContext;
import org.apache.geronimo.tomcat.core.GeronimoApplicationContext;
import org.apache.geronimo.web.security.SpecSecurityBuilder;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JACCSecurityLifecycleListener
implements LifecycleListener {
    private static final Logger logger = LoggerFactory.getLogger(JACCSecurityLifecycleListener.class);
    private Bundle bundle;
    private boolean annotationScanRequired;
    private String contextId;
    private ApplicationPolicyConfigurationManager applicationPolicyConfigurationManager;
    private String deploymentDescriptor;

    public JACCSecurityLifecycleListener(Bundle bundle, String deploymentDescriptor, boolean annotationScanRequired, ApplicationPolicyConfigurationManager applicationPolicyConfigurationManager, String contextId) {
        this.bundle = bundle;
        this.contextId = contextId;
        this.annotationScanRequired = annotationScanRequired;
        this.applicationPolicyConfigurationManager = applicationPolicyConfigurationManager;
        this.deploymentDescriptor = deploymentDescriptor;
    }

    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        String lifecycleEventType = lifecycleEvent.getType();
        if (lifecycleEventType.equals("before_start")) {
            SpecSecurityBuilder specSecurityBuilder = new SpecSecurityBuilder(this.bundle, this.deploymentDescriptor, this.annotationScanRequired);
            GeronimoStandardContext standardContext = (GeronimoStandardContext)((Object)lifecycleEvent.getSource());
            GeronimoApplicationContext applicationContext = (GeronimoApplicationContext)standardContext.getInternalServletContext();
            applicationContext.setSpecSecurityBuilder(specSecurityBuilder);
        } else if (lifecycleEventType.equals("start")) {
            GeronimoStandardContext standardContext = (GeronimoStandardContext)((Object)lifecycleEvent.getSource());
            GeronimoApplicationContext applicationContext = (GeronimoApplicationContext)standardContext.getInternalServletContext();
            SpecSecurityBuilder specSecurityBuilder = applicationContext.getSpecSecurityBuilder();
            HashMap<String, ComponentPermissions> contextIdPermissionsMap = new HashMap<String, ComponentPermissions>();
            contextIdPermissionsMap.put(this.contextId, specSecurityBuilder.buildSpecSecurityConfig());
            try {
                this.applicationPolicyConfigurationManager.updateApplicationPolicyConfiguration(contextIdPermissionsMap);
            }
            catch (LoginException e) {
                logger.error("Fail to set application policy configurations", (Throwable)e);
                throw new RuntimeException("Fail to set application policy configurations", e);
            }
            catch (PolicyContextException e) {
                logger.error("Fail to set application policy configurations", (Throwable)e);
                throw new RuntimeException("Fail to set application policy configurations", e);
            }
            catch (ClassNotFoundException e) {
                logger.error("Fail to set application policy configurations", (Throwable)e);
                throw new RuntimeException("Fail to set application policy configurations", e);
            }
            finally {
                specSecurityBuilder.clear();
                applicationContext.setSpecSecurityBuilder(null);
            }
        }
    }
}

