/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.io.StringReader;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.geronimo.tomcat.BaseGeronimoContextConfig;
import org.apache.geronimo.tomcat.GeronimoStandardContext;
import org.xml.sax.InputSource;

public class WebContextConfig
extends BaseGeronimoContextConfig {
    private String deploymentDescriptor;

    public WebContextConfig(String deploymentDescriptor) {
        this.deploymentDescriptor = deploymentDescriptor;
    }

    protected InputSource getContextWebXmlSource() {
        if (this.deploymentDescriptor == null) {
            return super.getContextWebXmlSource();
        }
        return new InputSource(new StringReader(this.deploymentDescriptor));
    }

    protected void authenticatorConfig() {
        if (!(this.context instanceof GeronimoStandardContext)) {
            throw new IllegalStateException("Unexpected context type");
        }
        GeronimoStandardContext geronimoContext = (GeronimoStandardContext)this.context;
        if (geronimoContext.isAuthenticatorInstalled()) {
            return;
        }
        if (geronimoContext.getDefaultSubject() == null) {
            return;
        }
        LoginConfig loginConfig = this.context.getLoginConfig();
        if (loginConfig == null) {
            loginConfig = new LoginConfig();
        }
        String authMethod = loginConfig.getAuthMethod();
        String realmName = loginConfig.getRealmName();
        String loginPage = loginConfig.getLoginPage();
        String errorPage = loginConfig.getErrorPage();
        this.configureSecurity(geronimoContext, geronimoContext.getPolicyContextId(), geronimoContext.getConfigurationFactory(), geronimoContext.getDefaultSubject(), authMethod, realmName, loginPage, errorPage);
    }
}

