/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.valves.ValveBase;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatEJBWebServiceContext
extends StandardContext {
    private static final Logger log = LoggerFactory.getLogger(TomcatEJBWebServiceContext.class);
    private final WebServiceContainer webServiceContainer;
    private final ClassLoader classLoader;

    public TomcatEJBWebServiceContext(String contextPath, WebServiceContainer webServiceContainer, ClassLoader classLoader) {
        this.webServiceContainer = webServiceContainer;
        this.setPath(contextPath);
        this.setDocBase("");
        this.setParentClassLoader(classLoader);
        this.setDelegate(true);
        log.debug("EJB Webservice Context = " + contextPath);
        this.classLoader = classLoader;
        Wrapper wrapper = this.createWrapper();
        String name = System.currentTimeMillis() + "";
        wrapper.setName(name);
        this.addChild((Container)wrapper);
        this.addServletMapping("/*", name);
        this.setProcessTlds(false);
    }

    protected void startInternal() throws LifecycleException {
        super.startInternal();
        this.addValve((Valve)new EJBWebServiceValve());
    }

    public static class ResponseAdapter
    implements WebServiceContainer.Response {
        private final Response response;

        public ResponseAdapter(Response response) {
            this.response = response;
        }

        public void setHeader(String name, String value) {
            this.response.setHeader(name, value);
        }

        public String getHeader(String name) {
            return this.response.getHeader(name);
        }

        public OutputStream getOutputStream() {
            return this.response.getStream();
        }

        public void setStatusCode(int code) {
            this.response.setStatus(code);
        }

        public int getStatusCode() {
            return this.response.getStatus();
        }

        public void setContentType(String type) {
            this.response.setContentType(type);
        }

        public String getContentType() {
            return this.response.getContentType();
        }

        public void setStatusMessage(String responseString) {
            this.response.setStatus(this.response.getStatus(), responseString);
        }

        public void flushBuffer() throws IOException {
            this.response.flushBuffer();
        }
    }

    public static class RequestAdapter
    implements WebServiceContainer.Request {
        private final Request request;
        private URI uri;
        private static final Map methods = new HashMap();

        public RequestAdapter(Request request) {
            this.request = request;
        }

        public String getHeader(String name) {
            return this.request.getHeader(name);
        }

        public URI getURI() {
            if (this.uri == null) {
                try {
                    this.uri = new URI(this.request.getScheme(), null, this.request.getServerName(), this.request.getServerPort(), this.request.getRequestURI(), this.request.getQueryString(), null);
                }
                catch (URISyntaxException e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
            return this.uri;
        }

        public int getContentLength() {
            return this.request.getContentLength();
        }

        public String getContentType() {
            return this.request.getContentType();
        }

        public InputStream getInputStream() throws IOException {
            return this.request.getInputStream();
        }

        public int getMethod() {
            Integer method = (Integer)methods.get(this.request.getMethod());
            return method == null ? 8 : method;
        }

        public String getParameter(String name) {
            return this.request.getParameter(name);
        }

        public Map getParameters() {
            return this.request.getParameterMap();
        }

        public Object getAttribute(String name) {
            return this.request.getAttribute(name);
        }

        public void setAttribute(String name, Object value) {
            this.request.setAttribute(name, value);
        }

        public String getRemoteAddr() {
            return this.request.getRemoteAddr();
        }

        public String getContextPath() {
            return this.request.getContextPath();
        }

        static {
            methods.put("OPTIONS", new Integer(0));
            methods.put("GET", new Integer(1));
            methods.put("HEAD", new Integer(2));
            methods.put("POST", new Integer(3));
            methods.put("PUT", new Integer(4));
            methods.put("DELETE", new Integer(5));
            methods.put("TRACE", new Integer(6));
            methods.put("CONNECT", new Integer(7));
        }
    }

    public class EJBWebServiceValve
    extends ValveBase {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invoke(Request req, Response res) throws IOException, ServletException {
            Thread currentThread = Thread.currentThread();
            ClassLoader oldClassLoader = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(TomcatEJBWebServiceContext.this.classLoader);
            try {
                this.handle(req, res);
            }
            finally {
                currentThread.setContextClassLoader(oldClassLoader);
            }
        }

        private void handle(Request req, Response res) throws IOException, ServletException {
            res.setContentType("text/xml");
            RequestAdapter request = new RequestAdapter(req);
            ResponseAdapter response = new ResponseAdapter(res);
            request.setAttribute(WebServiceContainer.SERVLET_REQUEST, req);
            request.setAttribute(WebServiceContainer.SERVLET_RESPONSE, res);
            request.setAttribute(WebServiceContainer.SERVLET_CONTEXT, null);
            req.finishRequest();
            if (this.isWSDLRequest(req)) {
                try {
                    TomcatEJBWebServiceContext.this.webServiceContainer.getWsdl((WebServiceContainer.Request)request, (WebServiceContainer.Response)response);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    res.sendError(500, "Could not fetch wsdl!");
                    return;
                }
            }
            try {
                TomcatEJBWebServiceContext.this.webServiceContainer.invoke((WebServiceContainer.Request)request, (WebServiceContainer.Response)response);
                req.finishRequest();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                res.sendError(500, "Could not process message!");
            }
        }

        private boolean isWSDLRequest(Request req) {
            return "GET".equals(req.getMethod()) && (req.getParameter("wsdl") != null || req.getParameter("xsd") != null);
        }
    }
}

