/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tomcat.connector;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Map;
import javax.management.j2ee.statistics.Stats;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.management.StatisticsProvider;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.tomcat.TomcatContainer;
import org.apache.geronimo.tomcat.connector.Ajp13Protocol;
import org.apache.geronimo.tomcat.connector.ConnectorGBean;
import org.apache.geronimo.tomcat.stats.ConnectorStats;

public class AJP13ConnectorGBean
extends ConnectorGBean
implements Ajp13Protocol,
StatisticsProvider {
    private ConnectorStats connStatsProvider = new ConnectorStats();
    private boolean reset = true;
    protected String connectHost;
    public static final GBeanInfo GBEAN_INFO;

    public AJP13ConnectorGBean(String name, Map initParams, String host, int port, TomcatContainer container, ServerInfo serverInfo) throws Exception {
        super(name, initParams, "AJP/1.3", container, serverInfo);
        if (host == null) {
            host = "0.0.0.0";
        }
        if (port == 0) {
            throw new IllegalArgumentException("Must declare a port.");
        }
        this.connector.setAttribute("address", (Object)host);
        this.connector.setPort(port);
    }

    public String getGeronimoProtocol() {
        return "AJP";
    }

    public String getConnectUrl() {
        if (this.connectHost == null) {
            String host = this.getAddress();
            if (host == null || host.equals("0.0.0.0") || host.equals("0:0:0:0:0:0:0:1")) {
                InetAddress address = null;
                try {
                    address = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    host = "unknown-host";
                }
                if (address != null && ((host = address.getCanonicalHostName()) == null || host.equals(""))) {
                    host = address.getHostAddress();
                }
            }
            if (host.indexOf(":") >= 0) {
                host = "[" + host + "]";
            }
            this.connectHost = host;
        }
        return this.getScheme().toLowerCase() + "://" + this.connectHost + (this.getPort() == this.getDefaultPort() ? "" : ":" + this.getPort());
    }

    public int getDefaultPort() {
        return -1;
    }

    public InetSocketAddress getListenAddress() {
        return new InetSocketAddress(this.getHost(), this.getPort());
    }

    public String getAddress() {
        Object value = this.connector.getAttribute("address");
        if (value == null) {
            return "0.0.0.0";
        }
        if (value instanceof InetAddress) {
            return ((InetAddress)value).getHostAddress();
        }
        return value.toString();
    }

    public int getBacklog() {
        Object value = this.connector.getAttribute("backlog");
        return value == null ? 10 : Integer.parseInt(value.toString());
    }

    public int getBufferSize() {
        Object value = this.connector.getAttribute("bufferSize");
        return value == null ? 2048 : Integer.parseInt(value.toString());
    }

    public int getConnectionTimeout() {
        Object value = this.connector.getAttribute("connectionTimeout");
        return value == null ? -1 : Integer.parseInt(value.toString());
    }

    public String getExecutor() {
        return (String)this.connector.getAttribute("Executor");
    }

    public String getHost() {
        return this.getAddress();
    }

    public int getKeepAliveTimeout() {
        Object value = this.connector.getAttribute("keepAliveTimeout");
        return value == null ? this.getConnectionTimeout() : Integer.parseInt(value.toString());
    }

    public int getMaxThreads() {
        Object value = this.connector.getAttribute("maxThreads");
        return value == null ? 200 : Integer.parseInt(value.toString());
    }

    public int getMaxSpareThreads() {
        Object value = this.connector.getAttribute("maxSpareThreads");
        return value == null ? 100 : Integer.parseInt(value.toString());
    }

    public int getMinSpareThreads() {
        Object value = this.connector.getAttribute("minSpareThreads");
        return value == null ? 10 : Integer.parseInt(value.toString());
    }

    public int getPort() {
        return this.connector.getPort();
    }

    public boolean getTcpNoDelay() {
        Object value = this.connector.getAttribute("tcpNoDelay");
        return value == null ? true : new Boolean(value.toString());
    }

    public boolean getTomcatAuthentication() {
        Object value = this.connector.getAttribute("tomcatAuthentication");
        return value == null ? true : new Boolean(value.toString());
    }

    public void setAddress(String address) {
        this.connector.setAttribute("address", (Object)address);
    }

    public void setBacklog(int backlog) {
        this.connector.setAttribute("backlog", (Object)new Integer(backlog));
    }

    public void setBufferSize(int bufferSize) {
        this.connector.setAttribute("bufferSize", (Object)new Integer(bufferSize));
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connector.setAttribute("connectionTimeout", (Object)new Integer(connectionTimeout));
    }

    public void setExecutor(String executor) {
        this.connector.setAttribute("executor", (Object)executor);
    }

    public void setHost(String host) {
        this.setAddress(host);
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.connector.setAttribute("keepAliveTimeout", (Object)keepAliveTimeout);
    }

    public void setMaxThreads(int maxThreads) {
        this.connector.setAttribute("maxThreads", (Object)maxThreads);
    }

    public void setMaxSpareThreads(int maxSpareThreads) {
        this.connector.setAttribute("maxSpareThreads", (Object)new Integer(maxSpareThreads));
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.connector.setAttribute("minSpareThreads", (Object)new Integer(minSpareThreads));
    }

    public void setNoCompressionUserAgents(String noCompressionUserAgents) {
        this.connector.setAttribute("noCompressionUserAgents", (Object)noCompressionUserAgents);
    }

    public void setPort(int port) {
        this.connector.setPort(port);
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.connector.setAttribute("tcpNoDelay", (Object)new Boolean(tcpNoDelay));
    }

    public void setTomcatAuthentication(boolean tomcatAuthentication) {
        this.connector.setAttribute("tomcatAuthentication", (Object)new Boolean(tomcatAuthentication));
    }

    public boolean isStatisticsProvider() {
        return true;
    }

    public Stats getStats() {
        String port = String.valueOf(this.getPort());
        if (this.reset) {
            this.reset = false;
            return this.connStatsProvider.getStats(port);
        }
        return this.connStatsProvider.updateStats(port);
    }

    public void resetStats() {
        this.reset = true;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((String)"Tomcat Connector AJP", AJP13ConnectorGBean.class, (GBeanInfo)ConnectorGBean.GBEAN_INFO);
        infoFactory.addInterface(Ajp13Protocol.class, new String[]{"address", "backlog", "bufferSize", "connectionTimeout", "executor", "host", "keepAliveTimeout", "maxThreads", "maxSpareThreads", "minSpareThreads", "port", "tcpNoDelay", "tomcatAuthentication"}, new String[]{"address", "backlog", "bufferSize", "connectionTimeout", "executor", "host", "keepAliveTimeout", "maxThreads", "maxSpareThreads", "minSpareThreads", "port", "tcpNoDelay", "tomcatAuthentication"});
        infoFactory.setConstructor(new String[]{"name", "initParams", "host", "port", "TomcatContainer", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

