/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.tools.loader;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.exceptions.DDBeanCreateException;
import javax.enterprise.deploy.shared.ModuleType;
import org.apache.geronimo.deployment.tools.DDBeanRootImpl;
import org.apache.geronimo.kernel.classloader.UrlResourceFinder;

public abstract class AbstractDeployable
implements DeployableObject {
    private final URL moduleURL;
    private final ModuleType type;
    private final DDBeanRoot root;
    private final ClassLoader rootCL;
    private final List entries;

    protected AbstractDeployable(ModuleType type, URL moduleURL, String rootDD) throws DDBeanCreateException {
        this.type = type;
        this.moduleURL = moduleURL;
        this.rootCL = new URLClassLoader(new URL[]{moduleURL}, Thread.currentThread().getContextClassLoader());
        UrlResourceFinder resourceFinder = new UrlResourceFinder(new URL[]{moduleURL});
        this.root = new DDBeanRootImpl(this, resourceFinder.findResource(rootDD));
        this.entries = new ArrayList();
        InputStream is = null;
        try {
            ZipEntry entry;
            is = moduleURL.openStream();
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(is));
            while ((entry = zis.getNextEntry()) != null) {
                this.entries.add(entry.getName());
            }
        }
        catch (IOException e) {
            throw (DDBeanCreateException)new DDBeanCreateException("Unable to create list of entries").initCause((Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e1) {}
            }
        }
    }

    public ModuleType getType() {
        return this.type;
    }

    public DDBeanRoot getDDBeanRoot() {
        return this.root;
    }

    public DDBeanRoot getDDBeanRoot(String filename) throws FileNotFoundException, DDBeanCreateException {
        try {
            return new DDBeanRootImpl(null, new URL(this.moduleURL, filename));
        }
        catch (MalformedURLException e) {
            throw (DDBeanCreateException)new DDBeanCreateException("Unable to construct URL for " + filename).initCause((Throwable)e);
        }
    }

    public DDBean[] getChildBean(String xpath) {
        return this.root.getChildBean(xpath);
    }

    public String[] getText(String xpath) {
        return this.root.getText(xpath);
    }

    public Enumeration entries() {
        return Collections.enumeration(this.entries);
    }

    public InputStream getEntry(String name) {
        return this.rootCL.getResourceAsStream(name);
    }

    protected ClassLoader getModuleLoader() {
        return this.rootCL;
    }

    public Class getClassFromScope(String className) {
        try {
            return this.getModuleLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public String getModuleDTDVersion() {
        throw new UnsupportedOperationException();
    }
}

