/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.geronimo.system.configuration.ElementState;
import org.apache.geronimo.system.configuration.EncodingInfo;
import org.apache.geronimo.system.configuration.IndentPrinter;
import org.apache.geronimo.system.configuration.OutputFormat;
import org.apache.geronimo.system.configuration.Printer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class BaseMarkupSerializer {
    private EncodingInfo encodingInfo;
    private ElementState[] elementStates = new ElementState[10];
    private int elementStateCount;
    private Vector preRoot;
    protected boolean started;
    private boolean prepared;
    protected Hashtable prefixes;
    protected String docTypePublicId;
    protected String docTypeSystemId;
    protected OutputFormat format;
    protected Printer printer;
    protected boolean indenting;
    private Writer writer;
    private OutputStream output;

    protected BaseMarkupSerializer(OutputFormat format) {
        for (int i = 0; i < this.elementStates.length; ++i) {
            this.elementStates[i] = new ElementState();
        }
        this.format = format;
    }

    public void setOutputByteStream(OutputStream output) {
        if (output == null) {
            throw new NullPointerException("SER001 Argument 'output' is null.");
        }
        this.output = output;
        this.writer = null;
        this.reset();
    }

    public void setOutputCharStream(Writer writer) {
        if (writer == null) {
            throw new NullPointerException("SER001 Argument 'writer' is null.");
        }
        this.writer = writer;
        this.output = null;
        this.reset();
    }

    public void setOutputFormat(OutputFormat format) {
        if (format == null) {
            throw new NullPointerException("SER001 Argument 'format' is null.");
        }
        this.format = format;
        this.reset();
    }

    public boolean reset() {
        if (this.elementStateCount > 1) {
            throw new IllegalStateException("Serializer reset in the middle of serialization");
        }
        this.prepared = false;
        return true;
    }

    protected void prepare() throws IOException {
        if (this.prepared) {
            return;
        }
        if (this.writer == null && this.output == null) {
            throw new IOException("SER002 No writer supplied for serializer");
        }
        this.encodingInfo = this.format.getEncodingInfo();
        if (this.output != null) {
            this.writer = this.encodingInfo.getWriter(this.output);
        }
        if (this.format.getIndenting()) {
            this.indenting = true;
            this.printer = new IndentPrinter(this.writer, this.format);
        } else {
            this.indenting = false;
            this.printer = new Printer(this.writer, this.format);
        }
        this.elementStateCount = 0;
        ElementState state = this.elementStates[0];
        state.namespaceURI = null;
        state.localName = null;
        state.rawName = null;
        state.preserveSpace = this.format.getPreserveSpace();
        state.empty = true;
        state.afterElement = false;
        state.afterComment = false;
        state.inCData = false;
        state.doCData = false;
        state.prefixes = null;
        this.docTypePublicId = this.format.getDoctypePublic();
        this.docTypeSystemId = this.format.getDoctypeSystem();
        this.started = false;
        this.prepared = true;
    }

    public void serialize(Element elem) throws IOException {
        this.prepare();
        this.serializeNode(elem);
        this.printer.flush();
        if (this.printer.getException() != null) {
            throw this.printer.getException();
        }
    }

    public void serialize(DocumentFragment frag) throws IOException {
        this.prepare();
        this.serializeNode(frag);
        this.printer.flush();
        if (this.printer.getException() != null) {
            throw this.printer.getException();
        }
    }

    public void serialize(Document doc) throws IOException {
        this.prepare();
        this.serializeNode(doc);
        this.serializePreRoot();
        this.printer.flush();
        if (this.printer.getException() != null) {
            throw this.printer.getException();
        }
    }

    public void startDocument() throws SAXException {
        try {
            this.prepare();
        }
        catch (IOException except) {
            throw (SAXException)new SAXException(except.toString()).initCause(except);
        }
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        try {
            ElementState state = this.content();
            if (state.inCData || state.doCData) {
                if (!state.inCData) {
                    this.printer.printText("<![CDATA[");
                    state.inCData = true;
                }
                int saveIndent = this.printer.getNextIndent();
                this.printer.setNextIndent(0);
                for (int index = 0; index < length; ++index) {
                    if (index + 2 >= length || chars[index] != ']' || chars[index + 1] != ']' || chars[index + 2] != '>') continue;
                    this.printText(chars, start, index + 2, true, true);
                    this.printer.printText("]]><![CDATA[");
                    start += index + 2;
                    length -= index + 2;
                    index = 0;
                }
                if (length > 0) {
                    this.printText(chars, start, length, true, true);
                }
                this.printer.setNextIndent(saveIndent);
            } else if (state.preserveSpace) {
                int saveIndent = this.printer.getNextIndent();
                this.printer.setNextIndent(0);
                this.printText(chars, start, length, true, state.unescaped);
                this.printer.setNextIndent(saveIndent);
            } else {
                this.printText(chars, start, length, false, state.unescaped);
            }
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void ignorableWhitespace(char[] chars, int start, int length) throws SAXException {
        try {
            this.content();
            if (this.indenting) {
                this.printer.setThisIndent(0);
                int i = start;
                while (length-- > 0) {
                    this.printer.printText(chars[i]);
                    ++i;
                }
            }
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public final void processingInstruction(String target, String code) throws SAXException {
        try {
            this.processingInstructionIO(target, code);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void processingInstructionIO(String target, String code) throws IOException {
        ElementState state = this.content();
        StringBuffer buffer = new StringBuffer(40);
        int index = target.indexOf("?>");
        if (index >= 0) {
            buffer.append("<?").append(target.substring(0, index));
        } else {
            buffer.append("<?").append(target);
        }
        if (code != null) {
            buffer.append(' ');
            index = code.indexOf("?>");
            if (index >= 0) {
                buffer.append(code.substring(0, index));
            } else {
                buffer.append(code);
            }
        }
        buffer.append("?>");
        if (this.isDocumentState()) {
            if (this.preRoot == null) {
                this.preRoot = new Vector();
            }
            this.preRoot.addElement(buffer.toString());
        } else {
            this.printer.indent();
            this.printText(buffer.toString(), true, true);
            this.printer.unindent();
            if (this.indenting) {
                state.afterElement = true;
            }
        }
    }

    public void comment(char[] chars, int start, int length) throws SAXException {
        try {
            this.comment(new String(chars, start, length));
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void comment(String text) throws IOException {
        if (this.format.getOmitComments()) {
            return;
        }
        ElementState state = this.content();
        StringBuffer buffer = new StringBuffer(40);
        int index = text.indexOf("-->");
        if (index >= 0) {
            buffer.append("<!--").append(text.substring(0, index)).append("-->");
        } else {
            buffer.append("<!--").append(text).append("-->");
        }
        if (this.isDocumentState()) {
            if (this.preRoot == null) {
                this.preRoot = new Vector();
            }
            this.preRoot.addElement(buffer.toString());
        } else {
            if (this.indenting && !state.preserveSpace) {
                this.printer.breakLine();
            }
            this.printer.indent();
            this.printText(buffer.toString(), true, true);
            this.printer.unindent();
            if (this.indenting) {
                state.afterElement = true;
            }
        }
        state.afterComment = true;
        state.afterElement = false;
    }

    public void startCDATA() {
        ElementState state = this.getElementState();
        state.doCData = true;
    }

    public void endCDATA() {
        ElementState state = this.getElementState();
        state.doCData = false;
    }

    public void startNonEscaping() {
        ElementState state = this.getElementState();
        state.unescaped = true;
    }

    public void endNonEscaping() {
        ElementState state = this.getElementState();
        state.unescaped = false;
    }

    public void startPreserving() {
        ElementState state = this.getElementState();
        state.preserveSpace = true;
    }

    public void endPreserving() {
        ElementState state = this.getElementState();
        state.preserveSpace = false;
    }

    public void endDocument() throws SAXException {
        try {
            this.serializePreRoot();
            this.printer.flush();
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void startEntity(String name) {
    }

    public void endEntity(String name) {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
        try {
            this.endCDATA();
            this.content();
            this.printer.printText('&');
            this.printer.printText(name);
            this.printer.printText(';');
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.prefixes == null) {
            this.prefixes = new Hashtable();
        }
        this.prefixes.put(uri, prefix == null ? "" : prefix);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public final void startDTD(String name, String publicId, String systemId) throws SAXException {
        try {
            this.printer.enterDTD();
            this.docTypePublicId = publicId;
            this.docTypeSystemId = systemId;
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void endDTD() {
    }

    public void elementDecl(String name, String model) throws SAXException {
        try {
            this.printer.enterDTD();
            this.printer.printText("<!ELEMENT ");
            this.printer.printText(name);
            this.printer.printText(' ');
            this.printer.printText(model);
            this.printer.printText('>');
            if (this.indenting) {
                this.printer.breakLine();
            }
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
        try {
            this.printer.enterDTD();
            this.printer.printText("<!ATTLIST ");
            this.printer.printText(eName);
            this.printer.printText(' ');
            this.printer.printText(aName);
            this.printer.printText(' ');
            this.printer.printText(type);
            if (valueDefault != null) {
                this.printer.printText(' ');
                this.printer.printText(valueDefault);
            }
            if (value != null) {
                this.printer.printText(" \"");
                this.printEscaped(value);
                this.printer.printText('\"');
            }
            this.printer.printText('>');
            if (this.indenting) {
                this.printer.breakLine();
            }
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
        try {
            this.printer.enterDTD();
            this.printer.printText("<!ENTITY ");
            this.printer.printText(name);
            this.printer.printText(" \"");
            this.printEscaped(value);
            this.printer.printText("\">");
            if (this.indenting) {
                this.printer.breakLine();
            }
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        try {
            this.printer.enterDTD();
            this.unparsedEntityDecl(name, publicId, systemId, null);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        try {
            this.printer.enterDTD();
            if (publicId == null) {
                this.printer.printText("<!ENTITY ");
                this.printer.printText(name);
                this.printer.printText(" SYSTEM ");
                this.printDoctypeURL(systemId);
            } else {
                this.printer.printText("<!ENTITY ");
                this.printer.printText(name);
                this.printer.printText(" PUBLIC ");
                this.printDoctypeURL(publicId);
                this.printer.printText(' ');
                this.printDoctypeURL(systemId);
            }
            if (notationName != null) {
                this.printer.printText(" NDATA ");
                this.printer.printText(notationName);
            }
            this.printer.printText('>');
            if (this.indenting) {
                this.printer.breakLine();
            }
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        try {
            this.printer.enterDTD();
            if (publicId != null) {
                this.printer.printText("<!NOTATION ");
                this.printer.printText(name);
                this.printer.printText(" PUBLIC ");
                this.printDoctypeURL(publicId);
                if (systemId != null) {
                    this.printer.printText(' ');
                    this.printDoctypeURL(systemId);
                }
            } else {
                this.printer.printText("<!NOTATION ");
                this.printer.printText(name);
                this.printer.printText(" SYSTEM ");
                this.printDoctypeURL(systemId);
            }
            this.printer.printText('>');
            if (this.indenting) {
                this.printer.breakLine();
            }
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    protected void serializeNode(Node node) throws IOException {
        switch (node.getNodeType()) {
            case 3: {
                String text = node.getNodeValue();
                if (text == null || this.indenting && !this.getElementState().preserveSpace && text.replace('\n', ' ').trim().length() == 0) break;
                this.characters(text);
                break;
            }
            case 4: {
                String text = node.getNodeValue();
                if (text == null) break;
                this.startCDATA();
                this.characters(text);
                this.endCDATA();
                break;
            }
            case 8: {
                String text;
                if (this.format.getOmitComments() || (text = node.getNodeValue()) == null) break;
                this.comment(text);
                break;
            }
            case 5: {
                this.endCDATA();
                this.content();
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.serializeNode(child);
                }
                break;
            }
            case 7: {
                this.processingInstructionIO(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 1: {
                this.serializeElement((Element)node);
                break;
            }
            case 9: {
                DocumentType docType = ((Document)node).getDoctype();
                if (docType != null) {
                    ((Document)node).getImplementation();
                    try {
                        this.printer.enterDTD();
                        this.docTypePublicId = docType.getPublicId();
                        this.docTypeSystemId = docType.getSystemId();
                        String internal = docType.getInternalSubset();
                        if (internal != null && internal.length() > 0) {
                            this.printer.printText(internal);
                        }
                        this.endDTD();
                    }
                    catch (NoSuchMethodError nsme) {
                        Class<?> docTypeClass = docType.getClass();
                        String docTypePublicId = null;
                        String docTypeSystemId = null;
                        try {
                            Method getPublicId = docTypeClass.getMethod("getPublicId", null);
                            if (getPublicId.getReturnType().equals(String.class)) {
                                docTypePublicId = (String)getPublicId.invoke((Object)docType, null);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            Method getSystemId = docTypeClass.getMethod("getSystemId", null);
                            if (getSystemId.getReturnType().equals(String.class)) {
                                docTypeSystemId = (String)getSystemId.invoke((Object)docType, null);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        this.printer.enterDTD();
                        this.docTypePublicId = docTypePublicId;
                        this.docTypeSystemId = docTypeSystemId;
                        this.endDTD();
                    }
                }
            }
            case 11: {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.serializeNode(child);
                }
                break;
            }
        }
    }

    protected ElementState content() throws IOException {
        ElementState state = this.getElementState();
        if (!this.isDocumentState()) {
            if (state.inCData && !state.doCData) {
                this.printer.printText("]]>");
                state.inCData = false;
            }
            if (state.empty) {
                this.printer.printText('>');
                state.empty = false;
            }
            state.afterElement = false;
            state.afterComment = false;
        }
        return state;
    }

    protected void characters(String text) throws IOException {
        ElementState state = this.content();
        if (state.inCData || state.doCData) {
            StringBuffer buffer = new StringBuffer(text.length());
            if (!state.inCData) {
                buffer.append("<![CDATA[");
                state.inCData = true;
            }
            int index = text.indexOf("]]>");
            while (index >= 0) {
                buffer.append(text.substring(0, index + 2)).append("]]><![CDATA[");
                text = text.substring(index + 2);
                index = text.indexOf("]]>");
            }
            buffer.append(text);
            int saveIndent = this.printer.getNextIndent();
            this.printer.setNextIndent(0);
            this.printText(buffer.toString(), true, true);
            this.printer.setNextIndent(saveIndent);
        } else if (state.preserveSpace) {
            int saveIndent = this.printer.getNextIndent();
            this.printer.setNextIndent(0);
            this.printText(text, true, state.unescaped);
            this.printer.setNextIndent(saveIndent);
        } else {
            this.printText(text, false, state.unescaped);
        }
    }

    protected abstract String getEntityRef(int var1);

    protected abstract void serializeElement(Element var1) throws IOException;

    protected void serializePreRoot() throws IOException {
        if (this.preRoot != null) {
            for (int i = 0; i < this.preRoot.size(); ++i) {
                this.printText((String)this.preRoot.elementAt(i), true, true);
                if (!this.indenting) continue;
                this.printer.breakLine();
            }
            this.preRoot.removeAllElements();
        }
    }

    protected final void printText(char[] chars, int start, int length, boolean preserveSpace, boolean unescaped) throws IOException {
        if (preserveSpace) {
            while (length-- > 0) {
                char ch = chars[start];
                ++start;
                if (ch == '\n' || ch == '\r' || unescaped) {
                    this.printer.printText(ch);
                    continue;
                }
                this.printEscaped(ch);
            }
        } else {
            while (length-- > 0) {
                char ch = chars[start];
                ++start;
                if (ch == ' ' || ch == '\f' || ch == '\t' || ch == '\n' || ch == '\r') {
                    this.printer.printSpace();
                    continue;
                }
                if (unescaped) {
                    this.printer.printText(ch);
                    continue;
                }
                this.printEscaped(ch);
            }
        }
    }

    protected final void printText(String text, boolean preserveSpace, boolean unescaped) throws IOException {
        if (preserveSpace) {
            for (int index = 0; index < text.length(); ++index) {
                char ch = text.charAt(index);
                if (ch == '\n' || ch == '\r' || unescaped) {
                    this.printer.printText(ch);
                    continue;
                }
                this.printEscaped(ch);
            }
        } else {
            for (int index = 0; index < text.length(); ++index) {
                char ch = text.charAt(index);
                if (ch == ' ' || ch == '\f' || ch == '\t' || ch == '\n' || ch == '\r') {
                    this.printer.printSpace();
                    continue;
                }
                if (unescaped) {
                    this.printer.printText(ch);
                    continue;
                }
                this.printEscaped(ch);
            }
        }
    }

    protected void printDoctypeURL(String url) throws IOException {
        this.printer.printText('\"');
        for (int i = 0; i < url.length(); ++i) {
            if (url.charAt(i) == '\"' || url.charAt(i) < ' ' || url.charAt(i) > '\u007f') {
                this.printer.printText('%');
                this.printer.printText(Integer.toHexString(url.charAt(i)));
                continue;
            }
            this.printer.printText(url.charAt(i));
        }
        this.printer.printText('\"');
    }

    protected void printEscaped(int ch) throws IOException {
        String charRef = this.getEntityRef(ch);
        if (charRef != null) {
            this.printer.printText('&');
            this.printer.printText(charRef);
            this.printer.printText(';');
        } else if (ch >= 32 && this.encodingInfo.isPrintable(ch) && ch != 247 || ch == 10 || ch == 13 || ch == 9) {
            if (ch < 65536) {
                this.printer.printText((char)ch);
            } else {
                this.printer.printText((char)((ch - 65536 >> 10) + 55296));
                this.printer.printText((char)((ch - 65536 & 0x3FF) + 56320));
            }
        } else {
            this.printer.printText("&#x");
            this.printer.printText(Integer.toHexString(ch));
            this.printer.printText(';');
        }
    }

    protected void printEscaped(String source) throws IOException {
        for (int i = 0; i < source.length(); ++i) {
            char lowch;
            int ch = source.charAt(i);
            if ((ch & 0xFC00) == 55296 && i + 1 < source.length() && ((lowch = source.charAt(i + 1)) & 0xFC00) == 56320) {
                ch = 65536 + (ch - 55296 << 10) + lowch - 56320;
                ++i;
            }
            this.printEscaped(ch);
        }
    }

    protected ElementState getElementState() {
        return this.elementStates[this.elementStateCount];
    }

    protected ElementState enterElementState(String namespaceURI, String localName, String rawName, boolean preserveSpace) {
        if (this.elementStateCount + 1 == this.elementStates.length) {
            int i;
            ElementState[] newStates = new ElementState[this.elementStates.length + 10];
            for (i = 0; i < this.elementStates.length; ++i) {
                newStates[i] = this.elementStates[i];
            }
            for (i = this.elementStates.length; i < newStates.length; ++i) {
                newStates[i] = new ElementState();
            }
            this.elementStates = newStates;
        }
        ++this.elementStateCount;
        ElementState state = this.elementStates[this.elementStateCount];
        state.namespaceURI = namespaceURI;
        state.localName = localName;
        state.rawName = rawName;
        state.preserveSpace = preserveSpace;
        state.empty = true;
        state.afterElement = false;
        state.afterComment = false;
        state.inCData = false;
        state.doCData = false;
        state.unescaped = false;
        state.prefixes = this.prefixes;
        this.prefixes = null;
        return state;
    }

    protected ElementState leaveElementState() {
        if (this.elementStateCount > 0) {
            this.prefixes = null;
            --this.elementStateCount;
            return this.elementStates[this.elementStateCount];
        }
        throw new IllegalStateException("Internal error: element state is zero");
    }

    protected boolean isDocumentState() {
        return this.elementStateCount == 0;
    }

    protected String getPrefix(String namespaceURI) {
        String prefix;
        if (this.prefixes != null && (prefix = (String)this.prefixes.get(namespaceURI)) != null) {
            return prefix;
        }
        if (this.elementStateCount == 0) {
            return null;
        }
        for (int i = this.elementStateCount; i > 0; --i) {
            if (this.elementStates[i].prefixes == null || (prefix = (String)this.elementStates[i].prefixes.get(namespaceURI)) == null) continue;
            return prefix;
        }
        return null;
    }
}

