/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactTypeHandler;
import org.apache.geronimo.kernel.repository.FileWriteMonitor;
import org.apache.geronimo.kernel.repository.WriteableRepository;
import org.apache.geronimo.kernel.util.XmlUtil;
import org.apache.geronimo.system.repository.CopyArtifactTypeHandler;
import org.apache.geronimo.system.repository.UnpackArtifactTypeHandler;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractRepository
implements WriteableRepository {
    protected static final Log log = LogFactory.getLog((Class)AbstractRepository.class);
    private static final ArtifactTypeHandler DEFAULT_TYPE_HANDLER = new CopyArtifactTypeHandler();
    protected final File rootFile;
    private final Map typeHandlers = new HashMap();
    private static final String NAMESPACE = "http://geronimo.apache.org/xml/ns/deployment-1.2";

    public AbstractRepository(URI root, ServerInfo serverInfo) {
        this(AbstractRepository.resolveRoot(root, serverInfo));
    }

    public AbstractRepository(File rootFile) {
        if (rootFile == null) {
            throw new NullPointerException("root is null");
        }
        if (!(rootFile.exists() && rootFile.isDirectory() && rootFile.canRead())) {
            throw new IllegalStateException("Maven2Repository must have a root that's a valid readable directory (not " + rootFile.getAbsolutePath() + ")");
        }
        this.rootFile = rootFile;
        log.debug((Object)("Repository root is " + rootFile.getAbsolutePath()));
        this.typeHandlers.put("car", new UnpackArtifactTypeHandler());
    }

    private static File resolveRoot(URI root, ServerInfo serverInfo) {
        URI resolvedUri;
        if (root == null) {
            throw new NullPointerException("root is null");
        }
        if (!root.toString().endsWith("/")) {
            try {
                root = new URI(root.toString() + "/");
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Invalid repository root (does not end with / ) and can't add myself", e);
            }
        }
        if (!(resolvedUri = serverInfo != null ? serverInfo.resolve(root) : root).getScheme().equals("file")) {
            throw new IllegalStateException("FileSystemRepository must have a root that's a local directory (not " + resolvedUri + ")");
        }
        File rootFile = new File(resolvedUri);
        return rootFile;
    }

    public boolean contains(Artifact artifact) {
        File location = this.getLocation(artifact);
        return location.canRead() && (location.isFile() || new File(location, "META-INF").isDirectory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashSet getDependencies(Artifact artifact) {
        LinkedHashSet<Artifact> dependencies;
        block17: {
            URL url;
            if (!artifact.isResolved()) {
                throw new IllegalArgumentException("Artifact " + artifact + " is not fully resolved");
            }
            dependencies = new LinkedHashSet<Artifact>();
            try {
                File location = this.getLocation(artifact);
                url = location.toURL();
            }
            catch (MalformedURLException e) {
                throw (IllegalStateException)new IllegalStateException("Unable to get URL for dependency " + artifact).initCause(e);
            }
            URLClassLoader depCL = new URLClassLoader(new URL[]{url}, ClassLoader.getSystemClassLoader());
            InputStream is = ((ClassLoader)depCL).getResourceAsStream("META-INF/geronimo-dependency.xml");
            try {
                if (is == null) break block17;
                InputSource in = new InputSource(is);
                DocumentBuilderFactory dfactory = XmlUtil.newDocumentBuilderFactory();
                dfactory.setNamespaceAware(true);
                try {
                    Document doc = dfactory.newDocumentBuilder().parse(in);
                    Element root = doc.getDocumentElement();
                    NodeList configs = root.getElementsByTagNameNS(NAMESPACE, "dependency");
                    for (int i = 0; i < configs.getLength(); ++i) {
                        Element dependencyElement = (Element)configs.item(i);
                        String groupId = this.getString(dependencyElement, "groupId");
                        String artifactId = this.getString(dependencyElement, "artifactId");
                        String version = this.getString(dependencyElement, "version");
                        String type = this.getString(dependencyElement, "type");
                        if (type == null) {
                            type = "jar";
                        }
                        dependencies.add(new Artifact(groupId, artifactId, version, type));
                    }
                }
                catch (IOException e) {
                    throw (IllegalStateException)new IllegalStateException("Unable to parse geronimo-dependency.xml file in " + url).initCause(e);
                }
                catch (ParserConfigurationException e) {
                    throw (IllegalStateException)new IllegalStateException("Unable to parse geronimo-dependency.xml file in " + url).initCause(e);
                }
                catch (SAXException e) {
                    throw (IllegalStateException)new IllegalStateException("Unable to parse geronimo-dependency.xml file in " + url).initCause(e);
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        return dependencies;
    }

    private String getString(Element dependencyElement, String childName) {
        NodeList children = dependencyElement.getElementsByTagNameNS(NAMESPACE, childName);
        if (children == null || children.getLength() == 0) {
            return null;
        }
        String value = "";
        NodeList text = children.item(0).getChildNodes();
        for (int t = 0; t < text.getLength(); ++t) {
            Node n = text.item(t);
            if (n.getNodeType() != 3) continue;
            value = value + n.getNodeValue();
        }
        return value.trim();
    }

    public void setTypeHandler(String type, ArtifactTypeHandler handler) {
        this.typeHandlers.put(type, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyToRepository(File source, Artifact destination, FileWriteMonitor monitor) throws IOException {
        if (!destination.isResolved()) {
            throw new IllegalArgumentException("Artifact " + destination + " is not fully resolved");
        }
        if (!source.exists() || !source.canRead() || source.isDirectory()) {
            throw new IllegalArgumentException("Cannot read source file at " + source.getAbsolutePath());
        }
        int size = 0;
        try {
            ZipFile zip = new ZipFile(source);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                size = (int)((long)size + entry.getSize());
            }
        }
        catch (ZipException ze) {
            size = (int)source.length();
        }
        FileInputStream is = new FileInputStream(source);
        try {
            this.copyToRepository(is, size, destination, monitor);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ignored) {}
        }
    }

    public void copyToRepository(InputStream source, int size, Artifact destination, FileWriteMonitor monitor) throws IOException {
        if (!destination.isResolved()) {
            throw new IllegalArgumentException("Artifact " + destination + " is not fully resolved");
        }
        if (!this.rootFile.canWrite()) {
            throw new IllegalStateException("This repository is not writable: " + this.rootFile.getAbsolutePath() + ")");
        }
        File location = this.getLocation(destination);
        if (location.exists()) {
            throw new IllegalArgumentException("Destination " + location.getAbsolutePath() + " already exists!");
        }
        ArtifactTypeHandler typeHandler = (ArtifactTypeHandler)this.typeHandlers.get(destination.getType());
        if (typeHandler == null) {
            typeHandler = DEFAULT_TYPE_HANDLER;
        }
        typeHandler.install(source, size, destination, monitor, location);
        if (destination.getType().equalsIgnoreCase("car")) {
            log.debug((Object)("Installed module configuration; id=" + destination + "; location=" + location));
        }
    }
}

