/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.geronimo.kernel.InvalidGBeanException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.configuration.ConfigurationOverride;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class ServerOverride {
    private final Map configurations = new LinkedHashMap();

    public ServerOverride() {
    }

    public ServerOverride(Element element) throws InvalidGBeanException {
        ConfigurationOverride configuration;
        Element configurationElement;
        int i;
        NodeList configs = element.getElementsByTagName("module");
        for (i = 0; i < configs.getLength(); ++i) {
            configurationElement = (Element)configs.item(i);
            configuration = new ConfigurationOverride(configurationElement);
            this.addConfiguration(configuration);
        }
        configs = element.getElementsByTagName("configuration");
        for (i = 0; i < configs.getLength(); ++i) {
            configurationElement = (Element)configs.item(i);
            configuration = new ConfigurationOverride(configurationElement);
            this.addConfiguration(configuration);
        }
    }

    public ConfigurationOverride getConfiguration(Artifact configurationName) {
        return this.getConfiguration(configurationName, false);
    }

    public ConfigurationOverride getConfiguration(Artifact configurationName, boolean create) {
        ConfigurationOverride configuration = (ConfigurationOverride)this.configurations.get(configurationName);
        if (create && configuration == null) {
            configuration = new ConfigurationOverride(configurationName, true);
            this.configurations.put(configurationName, configuration);
        }
        return configuration;
    }

    public void addConfiguration(ConfigurationOverride configuration) {
        this.configurations.put(configuration.getName(), configuration);
    }

    public void removeConfiguration(Artifact configurationName) {
        this.configurations.remove(configurationName);
    }

    public Map getConfigurations() {
        return this.configurations;
    }

    public Artifact[] queryConfigurations(Artifact query) {
        ArrayList<Artifact> list = new ArrayList<Artifact>();
        Iterator it = this.configurations.keySet().iterator();
        while (it.hasNext()) {
            Artifact test = (Artifact)it.next();
            if (!query.matches(test)) continue;
            list.add(test);
        }
        return list.toArray(new Artifact[list.size()]);
    }

    public Element writeXml(Document doc) {
        Element root = doc.createElement("attributes");
        root.setAttribute("xmlns", "http://geronimo.apache.org/xml/ns/attributes-1.1");
        doc.appendChild(doc.createComment(" ======================================================== "));
        doc.appendChild(doc.createComment(" Warning - This XML file is re-generated by Geronimo when "));
        doc.appendChild(doc.createComment(" changes are made to Geronimo's configuration, therefore  "));
        doc.appendChild(doc.createComment(" any comments added to this file will be lost.            "));
        doc.appendChild(doc.createComment(" Do not edit this file while Geronimo is running.         "));
        doc.appendChild(doc.createComment(" ======================================================== "));
        doc.appendChild(root);
        Iterator it = this.configurations.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ConfigurationOverride configurationOverride = (ConfigurationOverride)entry.getValue();
            configurationOverride.writeXml(doc, root);
        }
        return root;
    }
}

