/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.configuration;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.geronimo.system.configuration.OutputFormat;
import org.apache.geronimo.system.configuration.Printer;

public class IndentPrinter
extends Printer {
    private StringBuffer _line = new StringBuffer(80);
    private StringBuffer _text = new StringBuffer(20);
    private int _spaces = 0;
    private int _thisIndent = 0;
    private int _nextIndent = 0;

    IndentPrinter(Writer writer, OutputFormat format) {
        super(writer, format);
    }

    public void enterDTD() {
        if (this.dtdWriter == null) {
            this._line.append(this._text);
            this._text = new StringBuffer(20);
            this.flushLine(false);
            this.dtdWriter = new StringWriter();
            this.docWriter = this.writer;
            this.writer = this.dtdWriter;
        }
    }

    public String leaveDTD() {
        if (this.writer == this.dtdWriter) {
            this._line.append(this._text);
            this._text = new StringBuffer(20);
            this.flushLine(false);
            this.writer = this.docWriter;
            return this.dtdWriter.toString();
        }
        return null;
    }

    public void printText(String text) {
        this._text.append(text);
    }

    public void printText(StringBuffer text) {
        this._text.append(text);
    }

    public void printText(char ch) {
        this._text.append(ch);
    }

    public void printText(char[] chars, int start, int length) {
        this._text.append(chars, start, length);
    }

    public void printSpace() {
        if (this._text.length() > 0) {
            block5: {
                if (this.format.getLineWidth() > 0 && this._thisIndent + this._line.length() + this._spaces + this._text.length() > this.format.getLineWidth()) {
                    this.flushLine(false);
                    try {
                        this.writer.write(this.format.getLineSeparator());
                    }
                    catch (IOException except) {
                        if (this.exception != null) break block5;
                        this.exception = except;
                    }
                }
            }
            while (this._spaces > 0) {
                this._line.append(' ');
                --this._spaces;
            }
            this._line.append(this._text);
            this._text = new StringBuffer(20);
        }
        ++this._spaces;
    }

    public void breakLine() {
        this.breakLine(false);
    }

    public void breakLine(boolean preserveSpace) {
        block4: {
            if (this._text.length() > 0) {
                while (this._spaces > 0) {
                    this._line.append(' ');
                    --this._spaces;
                }
                this._line.append(this._text);
                this._text = new StringBuffer(20);
            }
            this.flushLine(preserveSpace);
            try {
                this.writer.write(this.format.getLineSeparator());
            }
            catch (IOException except) {
                if (this.exception != null) break block4;
                this.exception = except;
            }
        }
    }

    public void flushLine(boolean preserveSpace) {
        block6: {
            if (this._line.length() > 0) {
                try {
                    if (this.format.getIndenting() && !preserveSpace) {
                        int indent = this._thisIndent;
                        if (2 * indent > this.format.getLineWidth() && this.format.getLineWidth() > 0) {
                            indent = this.format.getLineWidth() / 2;
                        }
                        while (indent > 0) {
                            this.writer.write(32);
                            --indent;
                        }
                    }
                    this._thisIndent = this._nextIndent;
                    this._spaces = 0;
                    this.writer.write(this._line.toString());
                    this._line = new StringBuffer(40);
                }
                catch (IOException except) {
                    if (this.exception != null) break block6;
                    this.exception = except;
                }
            }
        }
    }

    public void flush() {
        block3: {
            if (this._line.length() > 0 || this._text.length() > 0) {
                this.breakLine();
            }
            try {
                this.writer.flush();
            }
            catch (IOException except) {
                if (this.exception != null) break block3;
                this.exception = except;
            }
        }
    }

    public void indent() {
        this._nextIndent += this.format.getIndent();
    }

    public void unindent() {
        this._nextIndent -= this.format.getIndent();
        if (this._nextIndent < 0) {
            this._nextIndent = 0;
        }
        if (this._line.length() + this._spaces + this._text.length() == 0) {
            this._thisIndent = this._nextIndent;
        }
    }

    public int getNextIndent() {
        return this._nextIndent;
    }

    public void setNextIndent(int indent) {
        this._nextIndent = indent;
    }

    public void setThisIndent(int indent) {
        this._thisIndent = indent;
    }
}

