/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.sharedlib;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.config.Manifest;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.system.sharedlib.SharedLibExtender;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.apache.xbean.osgi.bundle.util.DelegatingBundle;
import org.apache.xbean.osgi.bundle.util.HeaderBuilder;
import org.apache.xbean.osgi.bundle.util.HeaderParser;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
public class SharedLib
implements GBeanLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(SharedLib.class);
    private File baseFolder;
    private String[] libDirs;
    private String[] classesDirs;
    private ServerInfo serverInfo;
    private BundleContext bundleContext;
    private AbstractName name;
    private Bundle sharedLibBundle;

    public SharedLib(@ParamAttribute(name="baseDir") String baseDir, @ParamAttribute(name="classesDirs") String[] classesDirs, @ParamAttribute(name="libDirs") String[] libDirs, @ParamReference(name="ServerInfo") ServerInfo serverInfo, @ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext, @ParamSpecial(type=SpecialAttributeType.abstractName) AbstractName name) {
        if (baseDir == null) {
            throw new IllegalArgumentException("baseDir is required to configured for the sharedLib, and the values of classesDirs and libDirs should be relative to the baseDir");
        }
        this.baseFolder = serverInfo.resolveServer(baseDir);
        if (!this.baseFolder.exists() && !this.baseFolder.mkdirs()) {
            throw new IllegalArgumentException("Failed to create classes dir: " + baseDir);
        }
        if (classesDirs == null && libDirs == null) {
            throw new IllegalArgumentException("At least, one of the attributes classesDirs and libDirs is required to configured.");
        }
        this.classesDirs = classesDirs;
        this.libDirs = libDirs;
        this.serverInfo = serverInfo;
        this.bundleContext = bundleContext;
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() throws Exception {
        String requiredBundles;
        String dynamicImportPackages;
        String importPackages;
        String bundleLocation = "reference:" + this.baseFolder.toURI().toURL();
        for (Bundle b : this.bundleContext.getBundles()) {
            if (!b.getLocation().equals(bundleLocation)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug(" Share library bundle is found installed, it might be caused by the server was not shutdown correctly last time, it will be reinstalled");
            }
            b.uninstall();
            break;
        }
        Manifest manifest = new Manifest();
        manifest.addConfiguredAttribute(new Manifest.Attribute("Bundle-ManifestVersion", "2"));
        Artifact configId = this.name.getArtifact();
        manifest.addConfiguredAttribute(new Manifest.Attribute("Bundle-SymbolicName", configId.getGroupId() + "." + configId.getArtifactId() + "." + this.name.getNameProperty("name")));
        String versionString = "" + configId.getVersion().getMajorVersion() + "." + configId.getVersion().getMinorVersion() + "." + configId.getVersion().getIncrementalVersion();
        if (configId.getVersion().getQualifier() != null) {
            versionString = versionString + "." + configId.getVersion().getQualifier().replaceAll("[^-_\\w]{1}", "_");
        }
        manifest.addConfiguredAttribute(new Manifest.Attribute("Bundle-Version", versionString));
        Set<String> bundleClassPaths = this.generateBundleClassPath();
        if (bundleClassPaths.size() > 0) {
            Manifest.Attribute bundleClassPath = new Manifest.Attribute(Manifest.Attribute.Separator.COMMA, "Bundle-ClassPath", bundleClassPaths);
            manifest.addConfiguredAttribute(bundleClassPath);
        }
        if ((importPackages = (String)this.bundleContext.getBundle().getHeaders().get("Import-Package")) != null) {
            manifest.addConfiguredAttribute(new Manifest.Attribute(Manifest.Attribute.Separator.COMMA, "Import-Package", importPackages));
        }
        if ((dynamicImportPackages = (String)this.bundleContext.getBundle().getHeaders().get("DynamicImport-Package")) != null) {
            List headerElements = HeaderParser.parseHeader((String)dynamicImportPackages);
            Iterator it = headerElements.iterator();
            while (it.hasNext()) {
                if (!((HeaderParser.HeaderElement)it.next()).getName().equals("*")) continue;
                it.remove();
            }
            if (headerElements.size() > 0) {
                manifest.addConfiguredAttribute(new Manifest.Attribute(Manifest.Attribute.Separator.COMMA, "DynamicImport-Package", HeaderBuilder.build((List)headerElements)));
            }
        }
        if ((requiredBundles = (String)this.bundleContext.getBundle().getHeaders().get("Require-Bundle")) != null) {
            manifest.addConfiguredAttribute(new Manifest.Attribute(Manifest.Attribute.Separator.COMMA, "Require-Bundle", requiredBundles));
        }
        File metaInf = new File(this.baseFolder, "META-INF");
        metaInf.mkdirs();
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(new File(metaInf, "MANIFEST.MF")));
            manifest.write(pw);
        }
        catch (Throwable throwable) {
            IOUtils.close(pw);
            throw throwable;
        }
        IOUtils.close((Closeable)pw);
        this.sharedLibBundle = this.bundleContext.installBundle(bundleLocation);
        if (BundleUtils.isResolved((Bundle)this.sharedLibBundle)) {
            BundleUtils.resolve((Bundle)this.sharedLibBundle);
        }
        ServiceReference sharedLibExtenderReference = null;
        try {
            sharedLibExtenderReference = this.bundleContext.getServiceReference(SharedLibExtender.class.getName());
            if (sharedLibExtenderReference != null) {
                SharedLibExtender shareLibExtender = (SharedLibExtender)this.bundleContext.getService(sharedLibExtenderReference);
                shareLibExtender.registerSharedLibBundle(this.name.getArtifact(), this.sharedLibBundle);
            } else if (logger.isDebugEnabled()) {
                logger.debug("Unable to register the share lib bundle " + this.sharedLibBundle.getSymbolicName() + " in the ShareLibExtender");
            }
        }
        finally {
            if (sharedLibExtenderReference != null) {
                try {
                    this.bundleContext.ungetService(sharedLibExtenderReference);
                }
                catch (Exception e) {}
            }
        }
    }

    protected Set<String> generateBundleClassPath() {
        File dir;
        int i;
        LinkedHashSet<String> bundleClassPaths = new LinkedHashSet<String>();
        if (this.classesDirs != null) {
            for (i = 0; i < this.classesDirs.length; ++i) {
                String classesDir = this.classesDirs[i];
                dir = new File(this.baseFolder, classesDir);
                if (!dir.exists() && !dir.mkdirs()) {
                    throw new IllegalArgumentException("Failed to create classes dir: " + dir);
                }
                if (!dir.isDirectory()) {
                    throw new IllegalArgumentException("Shared classes dir is not a directory: " + dir);
                }
                if (classesDir.startsWith("/")) {
                    classesDir = classesDir.length() == 1 ? "." : classesDir.substring(1);
                }
                bundleClassPaths.add(classesDir);
            }
        }
        if (this.libDirs != null) {
            for (i = 0; i < this.libDirs.length; ++i) {
                String libDir = this.libDirs[i];
                dir = new File(this.baseFolder, libDir);
                if (!dir.exists()) {
                    logger.warn("share library directory " + libDir + " is not found, it will be ingored");
                    break;
                }
                if (!dir.isDirectory()) {
                    throw new IllegalArgumentException("Shared lib dir is not a directory: " + dir);
                }
                File[] files = dir.listFiles();
                for (int j = 0; j < files.length; ++j) {
                    File file = files[j];
                    if (!file.canRead() || !file.getName().endsWith(".jar") && !file.getName().endsWith(".zip")) continue;
                    if (libDir.startsWith("/")) {
                        String string = libDir = libDir.length() == 1 ? "" : libDir.substring(1);
                    }
                    if (!libDir.endsWith("/")) {
                        libDir = libDir + "/";
                    }
                    bundleClassPaths.add(libDir + file.getName());
                }
            }
        }
        return bundleClassPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop() throws Exception {
        if (this.sharedLibBundle == null) {
            return;
        }
        Bundle configurationBundle = this.bundleContext.getBundle();
        if (configurationBundle instanceof DelegatingBundle) {
            DelegatingBundle delegatingBundle = (DelegatingBundle)configurationBundle;
            delegatingBundle.removeBundle(this.sharedLibBundle);
        }
        ServiceReference sharedLibExtenderReference = null;
        try {
            sharedLibExtenderReference = this.bundleContext.getServiceReference(SharedLibExtender.class.getName());
            if (sharedLibExtenderReference != null) {
                SharedLibExtender sharedLibExtender = (SharedLibExtender)this.bundleContext.getService(sharedLibExtenderReference);
                sharedLibExtender.unregisterSharedLibBundle(this.name.getArtifact(), this.sharedLibBundle);
            }
        }
        finally {
            if (sharedLibExtenderReference != null) {
                try {
                    this.bundleContext.ungetService(sharedLibExtenderReference);
                }
                catch (Exception e) {}
            }
        }
        if (this.sharedLibBundle != null) {
            try {
                this.sharedLibBundle.uninstall();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

