/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.GeronimoSecurityException;
import org.apache.geronimo.security.jaas.NamedUsernamePasswordCredential;
import org.apache.geronimo.system.serverinfo.ServerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeronimoPropertiesFileMappedPasswordCredentialLoginModule
implements LoginModule {
    private static final Log log = LogFactory.getLog(GeronimoPropertiesFileMappedPasswordCredentialLoginModule.class);
    public static final String CREDENTIALS_URI = "credentialsURI";
    private static final Pattern pattern = Pattern.compile("([^:,=]*):([^:,=]*)=([^:,=]*)");
    private final Set<NamedUsernamePasswordCredential> passwordCredentials = new HashSet<NamedUsernamePasswordCredential>();
    private final Properties credentials = new Properties();
    private Subject subject;
    private CallbackHandler callbackHandler;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        try {
            ServerInfo serverInfo = (ServerInfo)options.get("org.apache.geronimo.security.realm.GenericSecurityRealm.SERVERINFO");
            String credentials = (String)options.get(CREDENTIALS_URI);
            if (credentials == null) {
                throw new IllegalArgumentException("credentialsURI must be provided!");
            }
            URI usersURI = new URI(credentials);
            this.loadProperties(serverInfo, usersURI);
        }
        catch (Exception e) {
            log.error((Object)"Initialization failed", (Throwable)e);
            throw new IllegalArgumentException("Unable to configure properties file login module: " + e.getMessage(), e);
        }
    }

    private void loadProperties(ServerInfo serverInfo, URI credentialsURI) throws GeronimoSecurityException {
        try {
            URI userFile = serverInfo.resolveServer(credentialsURI);
            InputStream stream = userFile.toURL().openStream();
            this.credentials.load(stream);
            stream.close();
        }
        catch (Exception e) {
            log.error((Object)"Properties File Login Module - data load failed", (Throwable)e);
            throw new GeronimoSecurityException((Throwable)e);
        }
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("User name")};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            throw (LoginException)new LoginException("Unlikely IOException").initCause(e);
        }
        catch (UnsupportedCallbackException e) {
            throw (LoginException)new LoginException("Unlikely UnsupportedCallbackException").initCause(e);
        }
        String userName = ((NameCallback)callbacks[0]).getName();
        String unparsedCredentials = this.credentials.getProperty(userName);
        if (unparsedCredentials != null) {
            this.parseCredentials(unparsedCredentials, this.passwordCredentials);
        }
        return false;
    }

    void parseCredentials(String unparsedCredentials, Set<NamedUsernamePasswordCredential> passwordCredentials) {
        Matcher matcher = pattern.matcher(unparsedCredentials);
        while (matcher.find()) {
            String credentialName = matcher.group(1);
            String credentialUser = matcher.group(2);
            String credentialPassword = matcher.group(3);
            NamedUsernamePasswordCredential credential = new NamedUsernamePasswordCredential(credentialUser, credentialPassword.toCharArray(), credentialName);
            passwordCredentials.add(credential);
        }
    }

    @Override
    public boolean commit() throws LoginException {
        this.subject.getPrivateCredentials().addAll(this.passwordCredentials);
        return false;
    }

    @Override
    public boolean abort() throws LoginException {
        this.passwordCredentials.clear();
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        this.passwordCredentials.clear();
        return false;
    }
}

