/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.realm.providers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.GeronimoSecurityException;
import org.apache.geronimo.security.realm.providers.GeronimoGroupPrincipal;
import org.apache.geronimo.security.realm.providers.GeronimoUserPrincipal;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.util.encoders.HexTranslator;

public class PropertiesFileLoginModule
implements LoginModule {
    public static final String USERS_URI = "usersURI";
    public static final String GROUPS_URI = "groupsURI";
    public static final String DIGEST = "digest";
    private static Log log;
    final Properties users = new Properties();
    final Map groups = new HashMap();
    private String digest;
    Subject subject;
    CallbackHandler handler;
    String username;
    String password;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.handler = callbackHandler;
        try {
            ServerInfo serverInfo = (ServerInfo)options.get("org.apache.geronimo.security.realm.GenericSecurityRealm.SERVERINFO");
            String users = (String)options.get(USERS_URI);
            String groups = (String)options.get(GROUPS_URI);
            this.digest = (String)options.get(DIGEST);
            if (this.digest != null && !this.digest.equals("")) {
                try {
                    MessageDigest.getInstance(this.digest);
                }
                catch (NoSuchAlgorithmException e) {
                    log.error((Object)("Initialization failed. Digest algorithm " + this.digest + " is not available."), (Throwable)e);
                    throw new IllegalArgumentException("Unable to configure properties file login module: " + e.getMessage());
                }
            }
            if (users == null || groups == null) {
                throw new IllegalArgumentException("Both usersURI and groupsURI must be provided!");
            }
            URI usersURI = new URI(users);
            URI groupsURI = new URI(groups);
            this.loadProperties(serverInfo, usersURI, groupsURI);
        }
        catch (Exception e) {
            log.error((Object)"Initialization failed", (Throwable)e);
            throw new IllegalArgumentException("Unable to configure properties file login module: " + e.getMessage());
        }
    }

    public void loadProperties(ServerInfo serverInfo, URI userURI, URI groupURI) throws GeronimoSecurityException {
        try {
            URI userFile = serverInfo.resolveServer(userURI);
            URI groupFile = serverInfo.resolveServer(groupURI);
            InputStream stream = userFile.toURL().openStream();
            this.users.load(stream);
            stream.close();
            Properties temp = new Properties();
            stream = groupFile.toURL().openStream();
            temp.load(stream);
            stream.close();
            Enumeration<Object> e = temp.keys();
            while (e.hasMoreElements()) {
                String groupName = (String)e.nextElement();
                String[] userList = ((String)temp.get(groupName)).split(",");
                HashSet<String> userset = (HashSet<String>)this.groups.get(groupName);
                if (userset == null) {
                    userset = new HashSet<String>();
                    this.groups.put(groupName, userset);
                }
                for (int i = 0; i < userList.length; ++i) {
                    userset.add(userList[i]);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Properties File Login Module - data load failed", (Throwable)e);
            throw new GeronimoSecurityException((Throwable)e);
        }
    }

    public boolean login() throws LoginException {
        boolean result;
        Callback[] callbacks = new Callback[]{new NameCallback("User name"), new PasswordCallback("Password", false)};
        try {
            this.handler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw (LoginException)new LoginException().initCause(ioe);
        }
        catch (UnsupportedCallbackException uce) {
            throw (LoginException)new LoginException().initCause(uce);
        }
        if (!$assertionsDisabled && callbacks.length != 2) {
            throw new AssertionError();
        }
        this.username = ((NameCallback)callbacks[0]).getName();
        if (this.username == null || this.username.equals("")) {
            return false;
        }
        String realPassword = this.users.getProperty(this.username);
        char[] entered = ((PasswordCallback)callbacks[1]).getPassword();
        this.password = entered == null ? null : new String(entered);
        boolean bl = result = realPassword == null && this.password == null || realPassword != null && this.password != null && this.checkPassword(realPassword, this.password);
        if (!result) {
            throw new FailedLoginException();
        }
        return true;
    }

    public boolean commit() throws LoginException {
        Set<Principal> principals = this.subject.getPrincipals();
        principals.add(new GeronimoUserPrincipal(this.username));
        Iterator e = this.groups.keySet().iterator();
        block0: while (e.hasNext()) {
            String groupName = (String)e.next();
            Set users = (Set)this.groups.get(groupName);
            Iterator iter = users.iterator();
            while (iter.hasNext()) {
                String user = (String)iter.next();
                if (!this.username.equals(user)) continue;
                principals.add(new GeronimoGroupPrincipal(groupName));
                continue block0;
            }
        }
        return true;
    }

    public boolean abort() throws LoginException {
        this.username = null;
        this.password = null;
        return true;
    }

    public boolean logout() throws LoginException {
        this.username = null;
        this.password = null;
        return true;
    }

    public String[] getPrincipalClassNames() {
        return new String[]{GeronimoUserPrincipal.class.getName(), GeronimoGroupPrincipal.class.getName()};
    }

    public String[] getPrincipalsOfClass(String className) {
        Set<Object> s;
        if (className.equals(GeronimoGroupPrincipal.class.getName())) {
            s = this.groups.keySet();
        } else if (className.equals(GeronimoUserPrincipal.class.getName())) {
            s = this.users.keySet();
        } else {
            throw new IllegalArgumentException("No such principal class " + className);
        }
        return s.toArray(new String[s.size()]);
    }

    private boolean checkPassword(String real, String provided) {
        if (this.digest == null || this.digest.equals("")) {
            return real.equals(provided);
        }
        try {
            MessageDigest md = MessageDigest.getInstance(this.digest);
            byte[] data = md.digest(provided.getBytes());
            byte[] hexData = new byte[data.length * 2];
            HexTranslator ht = new HexTranslator();
            ht.encode(data, 0, data.length, hexData, 0);
            return real.equalsIgnoreCase(new String(hexData));
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"Should not occur.  Availability of algorithm has been checked at initialization.", (Throwable)e);
            return false;
        }
    }

    static {
        $assertionsDisabled = !PropertiesFileLoginModule.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)PropertiesFileLoginModule.class);
    }
}

