/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.security.jaas;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.security.jaas.JaasLoginModuleChain;
import org.apache.geronimo.security.jaas.LoginModuleControlFlag;
import org.apache.geronimo.security.jaas.LoginModuleControlFlagEditor;
import org.apache.geronimo.security.jaas.LoginModuleSettings;
import org.apache.geronimo.security.jaas.server.JaasLoginModuleConfiguration;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class JaasLoginModuleUse
implements JaasLoginModuleChain {
    public static final String KERNEL_NAME_LM_OPTION = "org.apache.geronimo.security.realm.GenericSecurityRealm.KERNEL";
    public static final String SERVERINFO_LM_OPTION = "org.apache.geronimo.security.realm.GenericSecurityRealm.SERVERINFO";
    public static final String CLASSLOADER_LM_OPTION = "org.apache.geronimo.security.realm.GenericSecurityRealm.CLASSLOADER";
    private final LoginModuleSettings loginModule;
    private final JaasLoginModuleUse next;
    private LoginModuleControlFlag controlFlag;
    private final Kernel kernel;
    public static final GBeanInfo GBEAN_INFO;

    public JaasLoginModuleUse() {
        this.loginModule = null;
        this.next = null;
        this.controlFlag = null;
        this.kernel = null;
    }

    public JaasLoginModuleUse(LoginModuleSettings loginModule, JaasLoginModuleUse next, String controlFlag, Kernel kernel) {
        this.loginModule = loginModule;
        this.next = next;
        LoginModuleControlFlagEditor editor = new LoginModuleControlFlagEditor();
        editor.setAsText(controlFlag);
        this.controlFlag = (LoginModuleControlFlag)editor.getValue();
        this.kernel = kernel;
    }

    public LoginModuleSettings getLoginModule() {
        return this.loginModule;
    }

    public JaasLoginModuleChain getNext() {
        return this.next;
    }

    public String getLoginModuleName() {
        return this.kernel.getAbstractNameFor((Object)this.loginModule).toURI().toString();
    }

    public String getNextName() {
        if (this.next == null) {
            return null;
        }
        return this.kernel.getAbstractNameFor((Object)this.next).toURI().toString();
    }

    public String getControlFlag() {
        return this.controlFlag.toString();
    }

    public void setControlFlag(String controlFlag) {
        LoginModuleControlFlagEditor ed = new LoginModuleControlFlagEditor();
        ed.setAsText(controlFlag);
        this.controlFlag = (LoginModuleControlFlag)ed.getValue();
    }

    public void configure(Set domainNames, List loginModuleConfigurations, Kernel kernel, ServerInfo serverInfo, ClassLoader classLoader) {
        Map<Object, Object> options = this.loginModule.getOptions();
        options = options != null ? new HashMap<Object, Object>(options) : new HashMap();
        if (kernel != null && !options.containsKey(KERNEL_NAME_LM_OPTION)) {
            options.put(KERNEL_NAME_LM_OPTION, kernel.getKernelName());
        }
        if (serverInfo != null && !options.containsKey(SERVERINFO_LM_OPTION)) {
            options.put(SERVERINFO_LM_OPTION, serverInfo);
        }
        if (classLoader != null && !options.containsKey(CLASSLOADER_LM_OPTION)) {
            options.put(CLASSLOADER_LM_OPTION, classLoader);
        }
        if (this.loginModule.getLoginDomainName() != null) {
            if (domainNames.contains(this.loginModule.getLoginDomainName())) {
                throw new IllegalStateException("Error in realm: one security realm cannot contain multiple login modules for the same login domain");
            }
            domainNames.add(this.loginModule.getLoginDomainName());
        }
        JaasLoginModuleConfiguration config = new JaasLoginModuleConfiguration(this.loginModule.getLoginModuleClass(), this.controlFlag, options, this.loginModule.isServerSide(), this.loginModule.getLoginDomainName(), this.loginModule.isWrapPrincipals(), this.loginModule.getClassLoader());
        loginModuleConfigurations.add(config);
        if (this.next != null) {
            this.next.configure(domainNames, loginModuleConfigurations, kernel, serverInfo, classLoader);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((Class)JaasLoginModuleUse.class, (String)"LoginModuleUse");
        infoBuilder.addAttribute("controlFlag", String.class, true);
        infoBuilder.addAttribute("kernel", Kernel.class, false, false);
        infoBuilder.addReference("LoginModule", LoginModuleSettings.class, "LoginModule");
        infoBuilder.addReference("Next", JaasLoginModuleUse.class);
        infoBuilder.addOperation("configure", new Class[]{Set.class, List.class, Kernel.class, ServerInfo.class, ClassLoader.class});
        infoBuilder.addInterface(JaasLoginModuleChain.class);
        infoBuilder.setConstructor(new String[]{"LoginModule", "Next", "controlFlag", "kernel"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

