/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.farm.plugin;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.apache.geronimo.farm.config.NodeInfo;
import org.apache.geronimo.farm.plugin.JpaClusterInfo;
import org.apache.geronimo.farm.plugin.JpaNodeInfo;
import org.apache.geronimo.farm.plugin.JpaPluginInstance;
import org.apache.geronimo.farm.plugin.JpaPluginList;
import org.apache.geronimo.farm.plugin.NodeListener;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.LifecycleException;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.persistence.PersistenceUnitGBean;
import org.apache.geronimo.system.plugin.DownloadResults;
import org.apache.geronimo.system.plugin.Farm;
import org.apache.geronimo.system.plugin.PluginInstaller;
import org.apache.geronimo.system.plugin.model.PluginListType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
public class FarmGBean
implements NodeListener,
Farm {
    private static final Logger log = LoggerFactory.getLogger(FarmGBean.class);
    private String defaultRepository;
    private EntityManagerFactory emf;

    public FarmGBean(String defaultPluginRepository, EntityManagerFactory emf) {
        this.defaultRepository = defaultPluginRepository;
        this.emf = emf;
    }

    public FarmGBean(@ParamAttribute(name="defaultPluginRepository") String defaultPluginRepository, @ParamReference(name="PersistenceUnit", namingType="PersistenceUnit") PersistenceUnitGBean persistenceUnitGBean) {
        this.defaultRepository = defaultPluginRepository;
        this.emf = persistenceUnitGBean.getEntityManagerFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, DownloadResults> addNode(String clusterName, NodeInfo nodeInfo) {
        JpaNodeInfo jpaNodeInfo;
        JpaClusterInfo cluster;
        log.info("Node " + nodeInfo.getName() + " added to cluster " + clusterName);
        FarmGBean farmGBean = this;
        synchronized (farmGBean) {
            JpaContext clusterContext = new JpaContext(this.emf);
            cluster = clusterContext.getClusterInfo(clusterName);
            jpaNodeInfo = clusterContext.getNodeInfo(cluster, nodeInfo);
            clusterContext.close();
        }
        HashMap<String, DownloadResults> installedPluginLists = new HashMap<String, DownloadResults>();
        for (JpaPluginList pluginList : cluster.getPluginLists()) {
            DownloadResults downloadResults = this.installToNode(pluginList, jpaNodeInfo);
            installedPluginLists.put(pluginList.getName(), downloadResults);
        }
        return installedPluginLists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNode(String clusterName, String nodeName) {
        log.info("Node " + nodeName + " renoved from cluster " + clusterName);
        FarmGBean farmGBean = this;
        synchronized (farmGBean) {
            JpaContext clusterContext = new JpaContext(this.emf);
            JpaClusterInfo cluster = clusterContext.getClusterInfo(clusterName);
            for (JpaNodeInfo nodeInfo : cluster.getJpaNodeInfos()) {
                if (!nodeName.equals(nodeInfo.getName())) continue;
                cluster.getJpaNodeInfos().remove(nodeInfo);
                break;
            }
            clusterContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, DownloadResults> addPluginList(String clusterName, JpaPluginList pluginList) {
        JpaClusterInfo cluster;
        FarmGBean farmGBean = this;
        synchronized (farmGBean) {
            JpaContext clusterContext = new JpaContext(this.emf);
            cluster = clusterContext.getClusterInfo(clusterName);
            cluster.getPluginLists().add(pluginList);
            clusterContext.close();
        }
        return this.installToCluster(pluginList, cluster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, DownloadResults> addPluginList(String clusterName, String pluginListName) {
        JpaPluginList pluginList;
        JpaClusterInfo cluster;
        FarmGBean farmGBean = this;
        synchronized (farmGBean) {
            JpaContext clusterContext = new JpaContext(this.emf);
            cluster = clusterContext.getClusterInfo(clusterName);
            pluginList = clusterContext.getPluginList(pluginListName, this.defaultRepository);
            cluster.getPluginLists().add(pluginList);
            clusterContext.close();
        }
        return this.installToCluster(pluginList, cluster);
    }

    public Map<String, DownloadResults> addPlugin(String pluginListName, String artifactURI) {
        return this.addPlugin(pluginListName, new JpaPluginInstance(artifactURI));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, DownloadResults> addPlugin(String pluginListName, JpaPluginInstance pluginInstance) {
        JpaPluginList pluginList;
        FarmGBean farmGBean = this;
        synchronized (farmGBean) {
            JpaContext pluginListContext = new JpaContext(this.emf);
            pluginList = pluginListContext.getPluginList(pluginListName, this.defaultRepository);
            pluginList.getPlugins().add(pluginInstance);
            pluginListContext.close();
        }
        return this.installToClusters(pluginList);
    }

    public Map<String, DownloadResults> removePluginFromPluginList(String pluginListName, String artifactURI) {
        return this.removePluginFromPluginList(pluginListName, new JpaPluginInstance(artifactURI));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, DownloadResults> removePluginFromPluginList(String pluginListName, JpaPluginInstance pluginInstance) {
        JpaPluginList pluginList;
        FarmGBean farmGBean = this;
        synchronized (farmGBean) {
            JpaContext pluginListContext = new JpaContext(this.emf);
            pluginList = pluginListContext.getPluginList(pluginListName, this.defaultRepository);
            pluginList.getPlugins().remove(pluginInstance);
            pluginListContext.close();
        }
        return this.removeFromClusters(pluginList, pluginInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, DownloadResults> removePluginListFromCluster(String clusterName, String pluginListName) {
        JpaPluginList pluginList;
        JpaClusterInfo cluster;
        FarmGBean farmGBean = this;
        synchronized (farmGBean) {
            JpaContext clusterContext = new JpaContext(this.emf);
            cluster = clusterContext.getClusterInfo(clusterName);
            pluginList = clusterContext.getPluginList(pluginListName, this.defaultRepository);
            cluster.getPluginLists().remove(pluginList);
            clusterContext.close();
        }
        return this.removeFromCluster(pluginList.getPlugins(), cluster);
    }

    public Map<String, DownloadResults> addPluginToCluster(String clusterName, String pluginListName, String artifactURI) {
        return this.addPluginToCluster(clusterName, pluginListName, new JpaPluginInstance(artifactURI));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, DownloadResults> addPluginToCluster(String clusterName, String pluginListName, JpaPluginInstance pluginInstance) {
        JpaPluginList pluginList;
        FarmGBean farmGBean = this;
        synchronized (farmGBean) {
            JpaContext clusterContext = new JpaContext(this.emf);
            JpaClusterInfo cluster = clusterContext.getClusterInfo(clusterName);
            pluginList = this.getPluginList(cluster, pluginListName);
            pluginList.getPlugins().add(pluginInstance);
            clusterContext.close();
        }
        return this.installToClusters(pluginList);
    }

    private Map<String, DownloadResults> installToClusters(JpaPluginList pluginList) {
        HashMap<String, DownloadResults> results = new HashMap<String, DownloadResults>();
        for (JpaClusterInfo cluster : pluginList.getClusters()) {
            results.putAll(this.installToCluster(pluginList, cluster));
        }
        return results;
    }

    private Map<String, DownloadResults> installToCluster(JpaPluginList pluginList, JpaClusterInfo cluster) {
        HashMap<String, DownloadResults> installedNodes = new HashMap<String, DownloadResults>();
        for (JpaNodeInfo jpaNodeInfo : cluster.getJpaNodeInfos()) {
            DownloadResults downloadResults = this.installToNode(pluginList, jpaNodeInfo);
            installedNodes.put(jpaNodeInfo.getName(), downloadResults);
        }
        return installedNodes;
    }

    private DownloadResults installToNode(JpaPluginList jpaPluginList, JpaNodeInfo jpaNodeInfo) {
        try {
            PluginInstaller pluginInstaller = jpaNodeInfo.getPluginInstaller();
            PluginListType pluginList = jpaPluginList.getPluginList();
            return pluginInstaller.install(pluginList, this.defaultRepository, false, null, null);
        }
        catch (IOException e) {
            DownloadResults downloadResults = new DownloadResults();
            downloadResults.setFailure((Exception)e);
            return downloadResults;
        }
    }

    private Map<String, DownloadResults> removeFromClusters(JpaPluginList clusterPluginList, JpaPluginInstance pluginInstance) {
        List<JpaPluginInstance> pluginList = pluginInstance == null ? clusterPluginList.getPlugins() : Collections.singletonList(pluginInstance);
        HashMap<String, DownloadResults> results = new HashMap<String, DownloadResults>();
        for (JpaClusterInfo cluster : clusterPluginList.getClusters()) {
            results.putAll(this.removeFromCluster(pluginList, cluster));
        }
        return results;
    }

    private Map<String, DownloadResults> removeFromCluster(List<JpaPluginInstance> pluginList, JpaClusterInfo cluster) {
        HashMap<String, DownloadResults> installedNodes = new HashMap<String, DownloadResults>();
        for (JpaNodeInfo jpaNodeInfo : cluster.getJpaNodeInfos()) {
            DownloadResults downloadResults = this.removeFromNode(pluginList, jpaNodeInfo);
            installedNodes.put(jpaNodeInfo.getName(), downloadResults);
        }
        return installedNodes;
    }

    private DownloadResults removeFromNode(List<JpaPluginInstance> pluginList, JpaNodeInfo jpaNodeInfo) {
        DownloadResults downloadResults = new DownloadResults();
        try {
            ConfigurationManager configurationManager = jpaNodeInfo.getConfigurationManager();
            for (JpaPluginInstance jpaPluginInstance : pluginList) {
                Artifact artifact = jpaPluginInstance.toArtifact();
                configurationManager.uninstallConfiguration(artifact);
                downloadResults.addRemovedConfigID(artifact);
            }
        }
        catch (IOException e) {
            downloadResults.setFailure((Exception)e);
        }
        catch (NoSuchConfigException e) {
            downloadResults.setFailure((Exception)((Object)e));
        }
        catch (LifecycleException e) {
            downloadResults.setFailure((Exception)((Object)e));
        }
        return downloadResults;
    }

    private JpaPluginList getPluginList(JpaClusterInfo cluster, String pluginListName) {
        for (JpaPluginList pluginList : cluster.getPluginLists()) {
            if (!pluginList.getName().equals(pluginListName)) continue;
            return pluginList;
        }
        JpaPluginList pluginList = new JpaPluginList();
        pluginList.setName(pluginListName);
        pluginList.setDefaultPluginRepository(this.defaultRepository);
        cluster.getPluginLists().add(pluginList);
        return pluginList;
    }

    public static class JpaContext {
        private EntityManager em;
        private EntityTransaction entityTransaction;

        public JpaContext(EntityManagerFactory emf) {
            this.em = emf.createEntityManager();
            this.entityTransaction = this.em.getTransaction();
            this.entityTransaction.begin();
        }

        public JpaClusterInfo getClusterInfo(String clusterName) {
            Query query = this.em.createNamedQuery("clusterByName");
            query.setParameter("name", (Object)clusterName);
            try {
                return (JpaClusterInfo)query.getSingleResult();
            }
            catch (NoResultException e) {
                JpaClusterInfo clusterInfo = new JpaClusterInfo();
                clusterInfo.setName(clusterName);
                this.em.persist((Object)clusterInfo);
                this.em.flush();
                return clusterInfo;
            }
        }

        public JpaNodeInfo getNodeInfo(JpaClusterInfo cluster, NodeInfo nodeInfo) {
            JpaNodeInfo jpaNodeInfo;
            Query query = this.em.createNamedQuery("nodeByName");
            query.setParameter("name", (Object)nodeInfo.getName());
            try {
                jpaNodeInfo = (JpaNodeInfo)query.getSingleResult();
            }
            catch (NoResultException e) {
                jpaNodeInfo = new JpaNodeInfo(nodeInfo);
                this.em.persist((Object)jpaNodeInfo);
            }
            if (jpaNodeInfo.getCluster() == null) {
                jpaNodeInfo.setCluster(cluster);
            } else if (!jpaNodeInfo.getCluster().getName().equals(cluster.getName())) {
                throw new IllegalStateException("cannot move node to another cluster");
            }
            this.em.flush();
            return jpaNodeInfo;
        }

        public JpaPluginList getPluginList(String name, String defaultRepository) {
            Query query = this.em.createNamedQuery("pluginListByName");
            query.setParameter("name", (Object)name);
            try {
                return (JpaPluginList)query.getSingleResult();
            }
            catch (NoResultException e) {
                JpaPluginList pluginList = new JpaPluginList();
                pluginList.setName(name);
                pluginList.setDefaultPluginRepository(defaultRepository);
                this.em.persist((Object)pluginList);
                this.em.flush();
                return pluginList;
            }
        }

        public void close() {
            this.entityTransaction.commit();
            this.em.close();
        }
    }
}

