/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.farm.plugin;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.geronimo.farm.config.NodeInfo;
import org.apache.geronimo.farm.discovery.DiscoveryAgent;
import org.apache.geronimo.farm.discovery.DiscoveryListener;
import org.apache.geronimo.farm.plugin.JpaNodeInfo;
import org.apache.geronimo.farm.plugin.NodeListener;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.system.plugin.DownloadResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
public class FarmDiscoveryListener
implements DiscoveryListener {
    private static final Logger log = LoggerFactory.getLogger(FarmDiscoveryListener.class);
    private DiscoveryAgent discoveryAgent;
    private NodeListener nodeListener;
    private String defaultClusterName;
    private String discoveryType;
    private String userName;
    private String password;

    public FarmDiscoveryListener(@ParamAttribute(name="defaultClusterName") String defaultClusterName, @ParamAttribute(name="discoveryType") String discoveryType, @ParamAttribute(name="userName") String userName, @ParamAttribute(name="password") String password, @ParamReference(name="DiscoveryAgent") DiscoveryAgent discoveryAgent, @ParamReference(name="NodeListener") NodeListener nodeListener) {
        discoveryAgent.setDiscoveryListener((DiscoveryListener)this);
        this.discoveryAgent = discoveryAgent;
        this.nodeListener = nodeListener;
        this.defaultClusterName = defaultClusterName;
        this.discoveryType = discoveryType;
        this.userName = userName;
        this.password = password;
    }

    public void doStart() throws Exception {
    }

    public void doStop() throws Exception {
        this.doFail();
    }

    public void doFail() {
        this.discoveryAgent.setDiscoveryListener(null);
    }

    public void serviceAdded(URI service) {
        NodeInfo nodeInfo = this.toNodeInfo(service);
        if (nodeInfo != null) {
            String clusterName = this.toClusterName(service);
            Map<String, DownloadResults> results = this.nodeListener.addNode(clusterName, nodeInfo);
            this.log(nodeInfo, results);
        }
    }

    public void serviceRemoved(URI service) {
        NodeInfo nodeInfo = this.toNodeInfo(service);
        if (nodeInfo != null) {
            String clusterName = this.toClusterName(service);
            this.nodeListener.removeNode(clusterName, nodeInfo.getName());
        }
    }

    NodeInfo toNodeInfo(URI service) {
        String typeScheme = service.getScheme();
        if (!this.discoveryType.equals(typeScheme)) {
            return null;
        }
        try {
            URI jmxService = new URI(service.getSchemeSpecificPart());
            JpaNodeInfo nodeInfo = new JpaNodeInfo();
            String host = jmxService.getHost();
            int port = jmxService.getPort();
            String urlPath = jmxService.getPath().substring(1);
            String protocol = jmxService.getScheme();
            String name = this.getValue("node", jmxService.getQuery(), host + ":" + port);
            nodeInfo.setName(name);
            nodeInfo.setConnectorInfo(this.userName, this.password, protocol, host, port, urlPath, false);
            return nodeInfo;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    String toClusterName(URI service) {
        String typeScheme = service.getScheme();
        if (!this.discoveryType.equals(typeScheme)) {
            return null;
        }
        try {
            URI jmxService = new URI(service.getSchemeSpecificPart());
            return this.getValue("cluster", jmxService.getQuery(), this.defaultClusterName);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private String getValue(String key, String query, String defaultValue) {
        String[] bits = query.split("[&=]");
        if (bits.length % 2 != 0) {
            throw new IllegalArgumentException("Can't parse query string: " + query);
        }
        for (int i = 0; i < bits.length; i += 2) {
            if (!key.equals(bits[i])) continue;
            return bits[i + 1];
        }
        return defaultValue;
    }

    private void log(NodeInfo nodeInfo, Map<String, DownloadResults> results) {
        log.info("installing to node: " + nodeInfo.getName());
        for (Map.Entry<String, DownloadResults> entry : results.entrySet()) {
            log.info("installation results for plugin list: " + entry.getKey());
            DownloadResults downloadResults = entry.getValue();
            log.info("installed: " + downloadResults.getInstalledConfigIDs());
            if (!downloadResults.isFailed()) continue;
            log.info("failure: ", (Throwable)downloadResults.getFailure());
        }
    }
}

