/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.persistence.builder;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.NamespaceDrivenBuilder;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.persistence.PersistenceUnitGBean;
import org.apache.geronimo.xbeans.persistence.PersistenceDocument;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.XmlObject;

public class PersistenceUnitBuilder
implements NamespaceDrivenBuilder {
    private static final QName PERSISTENCE_QNAME = PersistenceDocument.type.getDocumentElementName();
    private final Environment defaultEnvironment;
    private final String defaultPersistenceProviderClassName;
    public static final GBeanInfo GBEAN_INFO;

    public PersistenceUnitBuilder(Environment defaultEnvironment, String defaultPersistenceProviderClassName) {
        this.defaultEnvironment = defaultEnvironment;
        this.defaultPersistenceProviderClassName = defaultPersistenceProviderClassName;
    }

    public void buildEnvironment(XmlObject container, Environment environment) throws DeploymentException {
        XmlObject[] raws = container.selectChildren(PERSISTENCE_QNAME);
        if (raws.length > 0) {
            EnvironmentBuilder.mergeEnvironments((Environment)environment, (Environment)this.defaultEnvironment);
        }
    }

    public void build(XmlObject container, DeploymentContext applicationContext, DeploymentContext moduleContext) throws DeploymentException {
        XmlObject[] raws;
        for (XmlObject raw : raws = container.selectChildren(PERSISTENCE_QNAME)) {
            PersistenceDocument.Persistence.PersistenceUnit[] persistenceUnits;
            PersistenceDocument.Persistence persistence = (PersistenceDocument.Persistence)raw.copy().changeType(PersistenceDocument.Persistence.type);
            for (PersistenceDocument.Persistence.PersistenceUnit persistenceUnit : persistenceUnits = persistence.getPersistenceUnitArray()) {
                String[] jarFileUrlStrings;
                String[] mappingFileNameStrings;
                GBeanData gbeanData;
                String persistenceUnitName = persistenceUnit.getName().trim();
                try {
                    gbeanData = moduleContext.addGBean(persistenceUnitName, PersistenceUnitGBean.GBEAN_INFO);
                }
                catch (GBeanAlreadyExistsException e) {
                    throw new DeploymentException("Duplicate persistenceUnit name " + persistenceUnitName, (Throwable)e);
                }
                gbeanData.setAttribute("persistenceUnitName", (Object)persistenceUnitName);
                if (persistenceUnit.isSetProvider()) {
                    gbeanData.setAttribute("persistenceProviderClassName", (Object)persistenceUnit.getProvider().trim());
                } else {
                    gbeanData.setAttribute("persistenceProviderClassName", (Object)this.defaultPersistenceProviderClassName);
                }
                gbeanData.setAttribute("persistenceUnitTransactionType", (Object)persistenceUnit.getTransactionType().toString());
                if (persistenceUnit.isSetJtaDataSource()) {
                    String jtaDataSourceString = persistenceUnit.getJtaDataSource().trim();
                    try {
                        AbstractNameQuery jtaDataSourceNameQuery = new AbstractNameQuery(new URI(jtaDataSourceString + "#org.apache.geronimo.connector.outbound.ConnectionFactorySource"));
                        gbeanData.setReferencePattern("JtaDataSourceWrapper", jtaDataSourceNameQuery);
                    }
                    catch (URISyntaxException e) {
                        throw new DeploymentException("Could not create jta-data-source AbstractNameQuery from string: " + jtaDataSourceString, (Throwable)e);
                    }
                }
                if (persistenceUnit.isSetNonJtaDataSource()) {
                    String nonJtaDataSourceString = persistenceUnit.getNonJtaDataSource().trim();
                    try {
                        AbstractNameQuery nonJtaDataSourceNameQuery = new AbstractNameQuery(new URI(nonJtaDataSourceString + "#org.apache.geronimo.connector.outbound.ConnectionFactorySource"));
                        gbeanData.setReferencePattern("NonJtaDataSourceWrapper", nonJtaDataSourceNameQuery);
                    }
                    catch (URISyntaxException e) {
                        throw new DeploymentException("Could not create non-jta-data-source AbstractNameQuery from string: " + nonJtaDataSourceString, (Throwable)e);
                    }
                }
                ArrayList<String> mappingFileNames = new ArrayList<String>();
                for (String mappingFileNameString : mappingFileNameStrings = persistenceUnit.getMappingFileArray()) {
                    mappingFileNames.add(mappingFileNameString.trim());
                }
                gbeanData.setAttribute("mappingFileNames", mappingFileNames);
                ArrayList<URL> jarFileUrls = new ArrayList<URL>();
                for (String jarFileUrlString1 : jarFileUrlStrings = persistenceUnit.getJarFileArray()) {
                    String jarFileUrlString = jarFileUrlString1.trim();
                    try {
                        URL jarFileUrl = new URL(jarFileUrlString);
                        jarFileUrls.add(jarFileUrl);
                    }
                    catch (MalformedURLException e) {
                        throw new DeploymentException("could not create URL for jarFileURL", (Throwable)e);
                    }
                }
                gbeanData.setAttribute("jarFileUrls", jarFileUrls);
                String[] managedClassNameStrings = persistenceUnit.getClass1Array();
                ArrayList<String> managedClassNames = new ArrayList<String>();
                for (String managedClassNameString : managedClassNameStrings) {
                    managedClassNames.add(managedClassNameString.trim());
                }
                gbeanData.setAttribute("managedClassNames", managedClassNames);
                if (persistenceUnit.isSetExcludeUnlistedClasses()) {
                    gbeanData.setAttribute("excludeUnlistedClasses", (Object)persistenceUnit.getExcludeUnlistedClasses());
                } else {
                    gbeanData.setAttribute("excludeUnlistedClassesValue", (Object)false);
                }
                Properties properties = new Properties();
                if (persistenceUnit.isSetProperties()) {
                    PersistenceDocument.Persistence.PersistenceUnit.Properties.Property[] propertyObjects;
                    for (PersistenceDocument.Persistence.PersistenceUnit.Properties.Property propertyObject : propertyObjects = persistenceUnit.getProperties().getPropertyArray()) {
                        String key = propertyObject.getName().trim();
                        String value = propertyObject.getValue().trim();
                        properties.setProperty(key, value);
                    }
                }
                gbeanData.setAttribute("properties", (Object)properties);
                if (!(moduleContext instanceof EARContext)) continue;
                AbstractNameQuery transactionManagerName = ((EARContext)moduleContext).getTransactionManagerName();
                gbeanData.setReferencePattern("TransactionManager", transactionManagerName);
            }
        }
    }

    public QNameSet getSpecQNameSet() {
        return QNameSet.EMPTY;
    }

    public QNameSet getPlanQNameSet() {
        return QNameSet.singleton((QName)PERSISTENCE_QNAME);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(PersistenceUnitBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("defaultPersistenceProviderClassName", String.class, true, true);
        infoBuilder.setConstructor(new String[]{"defaultEnvironment", "defaultPersistenceProviderClassName"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

