/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openjpa;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.lifecycle.LifecycleListener;
import org.apache.openjpa.enhance.PCRegistry;

public class ConfigurationMonitorGBean
implements GBeanLifecycle {
    private static final Log log = LogFactory.getLog(ConfigurationMonitorGBean.class);
    private final Kernel kernel;
    private final LifecycleListener listener;
    private HashMap<AbstractName, ClassLoader> classLoaderMap = new HashMap();
    public static final GBeanInfo GBEAN_INFO;

    public ConfigurationMonitorGBean(Kernel kernel) {
        this.kernel = kernel;
        this.listener = this.createLifecycleListener();
    }

    private LifecycleListener createLifecycleListener() {
        return new LifecycleListener(){

            public void loaded(AbstractName abstractName) {
            }

            public void starting(AbstractName abstractName) {
            }

            public void running(AbstractName abstractName) {
                ConfigurationMonitorGBean.this.configurationRunning(abstractName);
            }

            public void stopping(AbstractName abstractName) {
            }

            public void stopped(AbstractName abstractName) {
                ConfigurationMonitorGBean.this.configurationStopped(abstractName);
            }

            public void failed(AbstractName abstractName) {
            }

            public void unloaded(AbstractName abstractName) {
            }
        };
    }

    private void configurationRunning(AbstractName name) {
        try {
            Configuration config = (Configuration)this.kernel.getGBean(name);
            this.classLoaderMap.put(name, config.getConfigurationClassLoader());
        }
        catch (GBeanNotFoundException gnfe) {
            log.warn((Object)("Could not retrieve GBean for artifact: " + name.toString()), (Throwable)gnfe);
        }
    }

    private void configurationStopped(AbstractName name) {
        ClassLoader classLoader = this.classLoaderMap.remove(name);
        if (classLoader == null) {
            log.debug((Object)("Could not locate ClassLoader for artifact: " + name.toString()));
        }
        PCRegistry.deRegister((ClassLoader)classLoader);
    }

    public void doStart() {
        AbstractNameQuery configurationQuery = new AbstractNameQuery(Configuration.class.getName());
        this.kernel.getLifecycleMonitor().addLifecycleListener(this.listener, configurationQuery);
    }

    public void doStop() {
        this.kernel.getLifecycleMonitor().removeLifecycleListener(this.listener);
    }

    public void doFail() {
        this.doStop();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(ConfigurationMonitorGBean.class);
        infoBuilder.addAttribute("kernel", Kernel.class, false);
        infoBuilder.setConstructor(new String[]{"kernel"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

