/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb.cdi;

import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.corespi.se.DefaultBDABeansXmlScanner;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.spi.BDABeansXmlScanner;
import org.apache.webbeans.spi.ScannerService;
import org.apache.xbean.finder.BundleAssignableClassFinder;
import org.apache.xbean.osgi.bundle.util.BundleResourceFinder;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.apache.xbean.osgi.bundle.util.ClassDiscoveryFilter;
import org.apache.xbean.osgi.bundle.util.DiscoveryRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class OsgiMetaDataScannerService
implements ScannerService {
    private WebBeansLogger logger = WebBeansLogger.getLogger(OsgiMetaDataScannerService.class);
    private final WebBeansContext webBeansContext;
    private static final String META_INF_BEANS_XML = "META-INF/beans.xml";
    private static final String WEB_INF_BEANS_XML = "WEB-INF/beans.xml";
    protected boolean isBDAScannerEnabled = false;
    protected BDABeansXmlScanner bdaBeansXmlScanner;
    private Set<Class<?>> beanClasses = new HashSet();
    private Set<URL> beanXMLs = new HashSet<URL>();
    private Set<String> beanArchiveJarNames = new HashSet<String>();

    public OsgiMetaDataScannerService(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public Set<String> getAllAnnotations(String className) {
        return Collections.EMPTY_SET;
    }

    public void init(Object object) {
        String usage = this.webBeansContext.getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.useBDABeansXMLScanner");
        this.isBDAScannerEnabled = Boolean.parseBoolean(usage);
        if (this.isBDAScannerEnabled) {
            this.bdaBeansXmlScanner = new DefaultBDABeansXmlScanner();
        }
    }

    public void release() {
        this.beanClasses = new HashSet();
        this.beanXMLs = new HashSet<URL>();
        this.beanArchiveJarNames = new HashSet<String>();
    }

    public void scan() throws WebBeansDeploymentException {
        this.logger.info("Using OsgiMetaDataScannerService!");
        Bundle mainBundle = BundleUtils.getContextBundle((boolean)true);
        if (mainBundle != null) {
            ServiceReference reference = mainBundle.getBundleContext().getServiceReference(PackageAdmin.class.getName());
            try {
                PackageAdmin packageAdmin = (PackageAdmin)mainBundle.getBundleContext().getService(reference);
                this.findBeansXml(mainBundle, packageAdmin);
                if (!this.beanXMLs.isEmpty()) {
                    this.findBeanClasses(mainBundle, packageAdmin);
                }
            }
            catch (Exception e) {
                throw new WebBeansDeploymentException("problem while scanning OSGi bundle", (Throwable)e);
            }
            finally {
                mainBundle.getBundleContext().ungetService(reference);
            }
        }
    }

    private void findBeanClasses(Bundle mainBundle, PackageAdmin packageAdmin) {
        BundleAssignableClassFinder bundleClassFinder = new BundleAssignableClassFinder(packageAdmin, mainBundle, new Class[]{Object.class}, new ClassDiscoveryFilter(){

            public boolean directoryDiscoveryRequired(String directory) {
                return true;
            }

            public boolean jarFileDiscoveryRequired(String jarUrl) {
                return OsgiMetaDataScannerService.this.beanArchiveJarNames.contains(jarUrl);
            }

            public boolean packageDiscoveryRequired(String packageName) {
                return true;
            }

            public boolean rangeDiscoveryRequired(DiscoveryRange discoveryRange) {
                return discoveryRange.equals((Object)DiscoveryRange.BUNDLE_CLASSPATH);
            }
        });
        Set acceptedClassNames = bundleClassFinder.find();
        for (String clsName : acceptedClassNames) {
            try {
                Class cls = mainBundle.loadClass(clsName);
                this.beanClasses.add(cls);
            }
            catch (Throwable e) {
                this.logger.info("cannot load class from bundle: " + clsName);
            }
        }
    }

    private void findBeansXml(Bundle mainBundle, PackageAdmin packageAdmin) throws Exception {
        BundleResourceFinder brfXmlJar = new BundleResourceFinder(packageAdmin, mainBundle, "", META_INF_BEANS_XML);
        BundleResourceFinder.ResourceFinderCallback rfCallback = new BundleResourceFinder.ResourceFinderCallback(){

            public boolean foundInDirectory(Bundle bundle, String basePath, URL url) throws Exception {
                OsgiMetaDataScannerService.this.logger.info("adding the following beans.xml URL: " + url);
                OsgiMetaDataScannerService.this.beanXMLs.add(url);
                return true;
            }

            public boolean foundInJar(Bundle bundle, String jarName, ZipEntry entry, InputStream in) throws Exception {
                URL jarURL = bundle.getEntry(jarName);
                URL beansUrl = new URL("jar:" + jarURL.toString() + "!/" + entry.getName());
                OsgiMetaDataScannerService.this.logger.info("adding the following beans.xml URL: " + beansUrl);
                OsgiMetaDataScannerService.this.beanXMLs.add(beansUrl);
                OsgiMetaDataScannerService.this.beanArchiveJarNames.add(jarName);
                return true;
            }
        };
        brfXmlJar.find(rfCallback);
        Enumeration urls = mainBundle.findEntries("", "beans.xml", true);
        boolean webBeansXmlFound = false;
        while (urls != null && urls.hasMoreElements()) {
            URL webBeansXml = (URL)urls.nextElement();
            if (!webBeansXml.toExternalForm().endsWith("/WEB-INF/beans.xml")) continue;
            if (webBeansXmlFound) {
                throw new WebBeansDeploymentException("found more than WEB-INF/beans.xml file!" + webBeansXml);
            }
            this.logger.info("adding the following WEB-INF/beans.xml URL: " + webBeansXml);
            this.beanXMLs.add(webBeansXml);
            webBeansXmlFound = true;
        }
    }

    public Set<URL> getBeanXmls() {
        return this.beanXMLs;
    }

    public Set<Class<?>> getBeanClasses() {
        return this.beanClasses;
    }

    public boolean isBDABeansXmlScanningEnabled() {
        return this.isBDAScannerEnabled;
    }

    public BDABeansXmlScanner getBDABeansXmlScanner() {
        return this.bdaBeansXmlScanner;
    }
}

