/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.Context;
import javax.resource.ResourceException;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectorInstanceContext;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectorInstanceContextImpl;
import org.apache.geronimo.connector.outbound.connectiontracking.TrackedConnectionAssociator;
import org.apache.geronimo.naming.java.RootContext;
import org.apache.geronimo.openejb.EjbDeployment;
import org.apache.geronimo.security.Callers;
import org.apache.geronimo.security.ContextManager;
import org.apache.openejb.BeanContext;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ThreadContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeronimoThreadContextListener
implements ThreadContextListener {
    private static final Logger log = LoggerFactory.getLogger(GeronimoThreadContextListener.class);
    private static final GeronimoThreadContextListener instance = new GeronimoThreadContextListener();
    private final Map<String, Deployment> ejbs = new ConcurrentHashMap<String, Deployment>();

    public static void init() {
    }

    private GeronimoThreadContextListener() {
    }

    public static GeronimoThreadContextListener get() {
        return instance;
    }

    public void addEjb(EjbDeployment ejbDeployment) {
        this.ejbs.put(ejbDeployment.getDeploymentId(), new Deployment(ejbDeployment));
    }

    public void removeEjb(String id) {
        this.ejbs.remove(id);
    }

    EjbDeployment getEjbDeployment(BeanContext deploymentInfo) {
        Deployment deployment = this.ejbs.get(deploymentInfo.getDeploymentID());
        if (deployment == null) {
            return null;
        }
        return deployment.get(deploymentInfo);
    }

    public void contextEntered(ThreadContext oldContext, ThreadContext newContext) {
        Subject defaultSubject;
        BeanContext deploymentInfo = newContext.getBeanContext();
        if (deploymentInfo == null) {
            return;
        }
        EjbDeployment ejbDeployment = this.getEjbDeployment(deploymentInfo);
        if (ejbDeployment == null) {
            return;
        }
        GeronimoCallContext geronimoCallContext = new GeronimoCallContext();
        TrackedConnectionAssociator trackedConnectionAssociator = ejbDeployment.getTrackedConnectionAssociator();
        if (trackedConnectionAssociator != null) {
            ConnectorInstanceContextImpl connectorContext = new ConnectorInstanceContextImpl(ejbDeployment.getUnshareableResources(), ejbDeployment.getApplicationManagedSecurityResources());
            try {
                geronimoCallContext.oldConnectorContext = trackedConnectionAssociator.enter((ConnectorInstanceContext)connectorContext);
            }
            catch (ResourceException e) {
                log.error("Error while entering TrackedConnectionAssociator");
                return;
            }
        }
        Context jndiContext = deploymentInfo.getJndiEnc();
        geronimoCallContext.oldJndiContext = RootContext.getComponentContext();
        RootContext.setComponentContext((Context)jndiContext);
        geronimoCallContext.contextID = PolicyContext.getContextID();
        String moduleID = newContext.getBeanContext().getModuleID();
        PolicyContext.setContextID((String)moduleID);
        if (ContextManager.getCurrentCaller() == null && (defaultSubject = ejbDeployment.getDefaultSubject()) != null) {
            ContextManager.setCallers((Subject)defaultSubject, (Subject)defaultSubject);
            geronimoCallContext.clearCallers = true;
        }
        Subject runAsSubject = ejbDeployment.getRunAs();
        geronimoCallContext.callers = ContextManager.pushNextCaller((Subject)runAsSubject);
        newContext.set(GeronimoCallContext.class, (Object)geronimoCallContext);
    }

    public void contextExited(ThreadContext exitedContext, ThreadContext reenteredContext) {
        BeanContext deploymentInfo = exitedContext.getBeanContext();
        if (deploymentInfo == null) {
            return;
        }
        EjbDeployment ejbDeployment = (EjbDeployment)deploymentInfo.get(EjbDeployment.class);
        if (ejbDeployment == null) {
            return;
        }
        GeronimoCallContext geronimoCallContext = (GeronimoCallContext)exitedContext.get(GeronimoCallContext.class);
        if (geronimoCallContext == null) {
            return;
        }
        ContextManager.popCallers((Callers)geronimoCallContext.callers);
        if (geronimoCallContext.clearCallers) {
            ContextManager.clearCallers();
        }
        PolicyContext.setContextID((String)geronimoCallContext.contextID);
        RootContext.setComponentContext((Context)geronimoCallContext.oldJndiContext);
        TrackedConnectionAssociator trackedConnectionAssociator = ejbDeployment.getTrackedConnectionAssociator();
        if (trackedConnectionAssociator != null) {
            try {
                trackedConnectionAssociator.exit(geronimoCallContext.oldConnectorContext);
            }
            catch (ResourceException e) {
                log.error("Error while exiting TrackedConnectionAssociator");
            }
        }
    }

    static {
        ThreadContext.addThreadContextListener((ThreadContextListener)instance);
    }

    private static final class GeronimoCallContext {
        private Context oldJndiContext;
        private ConnectorInstanceContext oldConnectorContext;
        private boolean clearCallers;
        private Callers callers;
        private String contextID;

        private GeronimoCallContext() {
        }
    }

    private static final class Deployment {
        private final EjbDeployment geronimoDeployment;
        private final AtomicReference<Future<EjbDeployment>> initialized = new AtomicReference();

        private Deployment(EjbDeployment geronimoDeployment) {
            this.geronimoDeployment = geronimoDeployment;
        }

        public EjbDeployment get(final BeanContext openejbDeployment) {
            try {
                Future<EjbDeployment> initializedRef = this.initialized.get();
                if (initializedRef != null) {
                    return initializedRef.get();
                }
                FutureTask<EjbDeployment> initializer = new FutureTask<EjbDeployment>(new Callable<EjbDeployment>(){

                    @Override
                    public EjbDeployment call() throws Exception {
                        return Deployment.this.geronimoDeployment.initialize(openejbDeployment);
                    }
                });
                do {
                    if (!this.initialized.compareAndSet(null, initializer)) continue;
                    initializer.run();
                } while ((initializedRef = this.initialized.get()) == null);
                return initializedRef.get();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new IllegalStateException("EjbDeployment.initialize() interrupted", e);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("EjbDeployment.initialize() failed", e.getCause());
            }
        }
    }
}

