/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb;

import java.net.InetSocketAddress;
import java.util.Properties;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.management.geronimo.NetworkConnector;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.ServiceManager;

public class EjbDaemonGBean
implements NetworkConnector,
GBeanLifecycle {
    private String host;
    private int port;
    private int threads;
    private ServiceManager serviceManager;
    private boolean secure;
    private String discoveryHost = null;
    private String discoveryURI = null;
    private String clusterName;
    private String multicastHost;
    private int multicastPort;
    private boolean multicastEnabled;
    private String multipointHost;
    private int multipointPort;
    private String multipointServers;
    private boolean multipointEnabled;
    private long heartRate;
    private int maxMissedHeartbeats;
    public static final GBeanInfo GBEAN_INFO;

    public EjbDaemonGBean() {
        System.setProperty("openejb.nobanner", "true");
        this.serviceManager = ServiceManager.getManager();
    }

    public String getProtocol() {
        return "ejbd";
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public boolean isMulticastEnabled() {
        return this.multicastEnabled;
    }

    public void setMulticastEnabled(boolean multicastEnabled) {
        this.multicastEnabled = multicastEnabled;
    }

    public String getMulticastHost() {
        return this.multicastHost;
    }

    public void setMulticastHost(String multicastHost) {
        this.multicastHost = multicastHost;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public void setMulticastPort(int multicastPort) {
        this.multicastPort = multicastPort;
    }

    public InetSocketAddress getListenAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public String getDiscoveryHost() {
        return this.discoveryHost;
    }

    public void setDiscoveryHost(String discoveryHost) {
        this.discoveryHost = discoveryHost;
    }

    public String getDiscoveryURI() {
        return this.discoveryURI;
    }

    public void setDiscoveryURI(String discoveryURI) {
        this.discoveryURI = discoveryURI;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getMultipointHost() {
        return this.multipointHost;
    }

    public void setMultipointHost(String multipointHost) {
        this.multipointHost = multipointHost;
    }

    public int getMultipointPort() {
        return this.multipointPort;
    }

    public void setMultipointPort(int multipointPort) {
        this.multipointPort = multipointPort;
    }

    public String getMultipointServers() {
        return this.multipointServers;
    }

    public void setMultipointServers(String multipointServers) {
        this.multipointServers = multipointServers;
    }

    public boolean isMultipointEnabled() {
        return this.multipointEnabled;
    }

    public void setMultipointEnabled(boolean multipointEnabled) {
        this.multipointEnabled = multipointEnabled;
    }

    public long getHeartRate() {
        return this.heartRate;
    }

    public void setHeartRate(long heartRate) {
        this.heartRate = heartRate;
    }

    public int getMaxMissedHeartbeats() {
        return this.maxMissedHeartbeats;
    }

    public void setMaxMissedHeartbeats(int maxMissedHeartbeats) {
        this.maxMissedHeartbeats = maxMissedHeartbeats;
    }

    public void doStart() throws Exception {
        Properties properties = SystemInstance.get().getProperties();
        properties.setProperty("ejbd.bind", this.host);
        properties.setProperty("ejbd.port", Integer.toString(this.port));
        properties.setProperty("multicast.bind", this.multicastHost);
        properties.setProperty("multicast.port", Integer.toString(this.multicastPort));
        properties.setProperty("multicast.disabled", Boolean.toString(!this.multicastEnabled));
        properties.setProperty("multicast.group", this.clusterName);
        properties.setProperty("multicast.heart_rate", Long.toString(this.heartRate));
        properties.setProperty("multicast.max_missed_heartbeats", Integer.toString(this.maxMissedHeartbeats));
        properties.setProperty("multipoint.bind", this.multipointHost);
        properties.setProperty("multipoint.port", Integer.toString(this.multipointPort));
        properties.setProperty("multipoint.initialServers", this.multipointServers);
        properties.setProperty("multipoint.disabled", Boolean.toString(!this.multipointEnabled));
        properties.setProperty("multipoint.group", this.clusterName);
        properties.setProperty("multipoint.heart_rate", Long.toString(this.heartRate));
        properties.setProperty("multipoint.max_missed_heartbeats", Integer.toString(this.maxMissedHeartbeats));
        if (this.discoveryHost != null && this.discoveryHost.length() > 0) {
            properties.setProperty("ejbd.discoveryHost", this.discoveryHost);
            properties.setProperty("ejbd.discovery", "ejb:ejbd://{discoveryHost}:{port}");
        } else {
            properties.setProperty("ejbd.discovery", "ejb:ejbd://{host}:{port}");
        }
        properties.setProperty("ejbd.secure", this.secure + "");
        properties.setProperty("ejbds.disabled", "true");
        if (this.threads > 0) {
            properties.setProperty("ejbd.threads", Integer.toString(this.threads));
        }
        this.serviceManager.init();
        this.serviceManager.start(false);
    }

    public void doStop() throws Exception {
        this.serviceManager.stop();
    }

    public void doFail() {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((String)"OpenEJB Daemon", EjbDaemonGBean.class);
        infoBuilder.addAttribute("host", String.class, true);
        infoBuilder.addAttribute("port", Integer.TYPE, true);
        infoBuilder.addAttribute("discoveryHost", String.class, true);
        infoBuilder.addAttribute("clusterName", String.class, true);
        infoBuilder.addAttribute("heartRate", Long.TYPE, true);
        infoBuilder.addAttribute("maxMissedHeartbeats", Integer.TYPE, true);
        infoBuilder.addAttribute("multicastHost", String.class, true);
        infoBuilder.addAttribute("multicastPort", Integer.TYPE, true);
        infoBuilder.addAttribute("multicastEnabled", Boolean.TYPE, true);
        infoBuilder.addAttribute("multipointHost", String.class, true);
        infoBuilder.addAttribute("multipointPort", Integer.TYPE, true);
        infoBuilder.addAttribute("multipointServers", String.class, true);
        infoBuilder.addAttribute("multipointEnabled", Boolean.TYPE, true);
        infoBuilder.addAttribute("threads", Integer.TYPE, true);
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

