/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb;

import javax.naming.Context;
import javax.resource.ResourceException;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectorInstanceContext;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectorInstanceContextImpl;
import org.apache.geronimo.connector.outbound.connectiontracking.TrackedConnectionAssociator;
import org.apache.geronimo.naming.java.RootContext;
import org.apache.geronimo.openejb.EjbDeployment;
import org.apache.geronimo.security.Callers;
import org.apache.geronimo.security.ContextManager;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ThreadContextListener;

public class GeronimoThreadContextListener
implements ThreadContextListener {
    private static final Log log = LogFactory.getLog(GeronimoThreadContextListener.class);
    private static final GeronimoThreadContextListener instance = new GeronimoThreadContextListener();

    public static void init() {
    }

    private GeronimoThreadContextListener() {
    }

    public void contextEntered(ThreadContext oldContext, ThreadContext newContext) {
        Subject defaultSubject;
        CoreDeploymentInfo deploymentInfo = newContext.getDeploymentInfo();
        if (deploymentInfo == null) {
            return;
        }
        EjbDeployment ejbDeployment = (EjbDeployment)deploymentInfo.get(EjbDeployment.class);
        if (ejbDeployment == null) {
            return;
        }
        GeronimoCallContext geronimoCallContext = new GeronimoCallContext();
        Context jndiContext = ejbDeployment.getComponentContext();
        geronimoCallContext.oldJndiContext = RootContext.getComponentContext();
        TrackedConnectionAssociator trackedConnectionAssociator = ejbDeployment.getTrackedConnectionAssociator();
        if (trackedConnectionAssociator != null) {
            ConnectorInstanceContextImpl connectorContext = new ConnectorInstanceContextImpl(ejbDeployment.getUnshareableResources(), ejbDeployment.getApplicationManagedSecurityResources());
            try {
                geronimoCallContext.oldConnectorContext = trackedConnectionAssociator.enter((ConnectorInstanceContext)connectorContext);
            }
            catch (ResourceException e) {
                log.error((Object)"Error while entering TrackedConnectionAssociator");
                return;
            }
        }
        RootContext.setComponentContext((Context)jndiContext);
        String moduleID = newContext.getDeploymentInfo().getModuleID();
        PolicyContext.setContextID((String)moduleID);
        if (ContextManager.getCurrentCaller() == null && (defaultSubject = ejbDeployment.getDefaultSubject()) != null) {
            ContextManager.setCallers((Subject)defaultSubject, (Subject)defaultSubject);
            geronimoCallContext.clearCallers = true;
        }
        Subject runAsSubject = ejbDeployment.getRunAs();
        geronimoCallContext.callers = ContextManager.pushNextCaller((Subject)runAsSubject);
        newContext.set(GeronimoCallContext.class, (Object)geronimoCallContext);
    }

    public void contextExited(ThreadContext exitedContext, ThreadContext reenteredContext) {
        CoreDeploymentInfo deploymentInfo = exitedContext.getDeploymentInfo();
        if (deploymentInfo == null) {
            return;
        }
        EjbDeployment ejbDeployment = (EjbDeployment)deploymentInfo.get(EjbDeployment.class);
        if (ejbDeployment == null) {
            return;
        }
        GeronimoCallContext geronimoCallContext = (GeronimoCallContext)exitedContext.get(GeronimoCallContext.class);
        if (geronimoCallContext == null) {
            return;
        }
        ContextManager.popCallers((Callers)geronimoCallContext.callers);
        if (geronimoCallContext.clearCallers) {
            ContextManager.clearCallers();
        }
        RootContext.setComponentContext((Context)geronimoCallContext.oldJndiContext);
        TrackedConnectionAssociator trackedConnectionAssociator = ejbDeployment.getTrackedConnectionAssociator();
        if (trackedConnectionAssociator != null) {
            try {
                trackedConnectionAssociator.exit(geronimoCallContext.oldConnectorContext);
            }
            catch (ResourceException e) {
                log.error((Object)"Error while exiting TrackedConnectionAssociator");
            }
        }
    }

    static {
        ThreadContext.addThreadContextListener((ThreadContextListener)instance);
    }

    private static final class GeronimoCallContext {
        private Context oldJndiContext;
        private ConnectorInstanceContext oldConnectorContext;
        private boolean clearCallers;
        private Callers callers;

        private GeronimoCallContext() {
        }
    }
}

