/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb;

import java.net.InetSocketAddress;
import java.util.Properties;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.management.geronimo.NetworkConnector;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.ServiceManager;

public class EjbDaemonGBean
implements NetworkConnector,
GBeanLifecycle {
    private String host;
    private int port;
    private int threads;
    private ServiceManager serviceManager;
    public static final GBeanInfo GBEAN_INFO;

    public EjbDaemonGBean() {
        System.setProperty("openejb.nobanner", "true");
        this.serviceManager = new ServiceManager();
    }

    public String getProtocol() {
        return "ejbd";
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public InetSocketAddress getListenAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public void doStart() throws Exception {
        Properties properties = SystemInstance.get().getProperties();
        properties.setProperty("ejbd.bind", this.host);
        properties.setProperty("ejbd.port", Integer.toString(this.port));
        if (this.threads > 0) {
            properties.setProperty("ejbd.threads", Integer.toString(this.threads));
        }
        this.serviceManager.init();
        this.serviceManager.start(false);
    }

    public void doStop() throws Exception {
        this.serviceManager.stop();
    }

    public void doFail() {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((String)"OpenEJB Daemon", EjbDaemonGBean.class);
        infoBuilder.addAttribute("host", String.class, true);
        infoBuilder.addAttribute("port", Integer.TYPE, true);
        infoBuilder.addAttribute("threads", Integer.TYPE, true);
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

