/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.openejb.ServerIdentityToken;
import org.apache.geronimo.security.SubjectId;
import org.apache.openejb.client.ClientSecurity;
import org.apache.openejb.client.ServerMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenejbRemoteLoginModule
implements LoginModule {
    private static final String SECURITY_REALM_KEY = "org.apache.geronimo.openejb.OpenejbRemoteLoginModule.RemoteSecurityRealm";
    private static final String SERVER_URI_KEY = "org.apache.geronimo.openejb.OpenejbRemoteLoginModule.ServerURI";
    private Subject subject;
    private CallbackHandler callbackHandler;
    private String securityRealm;
    private URI serverURI;
    private SubjectId identity;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.securityRealm = (String)options.get(SECURITY_REALM_KEY);
        this.serverURI = URI.create((String)options.get(SERVER_URI_KEY));
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("username"), new PasswordCallback("passsword", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            throw (LoginException)new LoginException("Could not execute callbacks").initCause(e);
        }
        catch (UnsupportedCallbackException e) {
            throw (LoginException)new LoginException("Could not execute callbacks").initCause(e);
        }
        String userName = ((NameCallback)callbacks[0]).getName();
        String password = new String(((PasswordCallback)callbacks[1]).getPassword());
        this.identity = (SubjectId)ClientSecurity.directAuthentication((String)this.securityRealm, (String)userName, (String)password, (ServerMetaData)new ServerMetaData(new URI[]{this.serverURI}));
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        this.subject.getPrivateCredentials().add(new ServerIdentityToken(this.serverURI, this.identity));
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        this.subject.getPrivateCredentials().remove(this.identity);
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        return true;
    }
}

